/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scaffold.maintenance.dto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.ymir.render.Paging;
import org.seasar.ymir.scaffold.maintenance.Constants;
import org.seasar.ymir.scaffold.maintenance.dto.ColumnDto;
import org.seasar.ymir.scaffold.maintenance.enm.Action;
import org.seasar.ymir.scaffold.maintenance.web.EntityBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewDto
implements Constants {
    private EntityBean entityBean;
    private Action action;
    private List<? extends Entity> entities;
    private Paging paging;

    public ViewDto(EntityBean entityBean, Action action) {
        this.entityBean = entityBean;
        this.action = action;
    }

    public void setResultBean(PagingResultBean<? extends Entity> bean) {
        this.entities = bean.getSelectedList();
        this.paging = new Paging(bean);
    }

    public List<ColumnDto> getColumns() {
        return this.entityBean.getColumns(this.action);
    }

    public List<String> getHiddenColumnNames() {
        return this.entityBean.getHiddenColumnNames(this.action);
    }

    public List<String> getUpdatableColumnNames() {
        return this.entityBean.getUpdatableColumnNames(this.action);
    }

    public String getEntityName() {
        return this.entityBean.getEntityName();
    }

    public Map<String, String> getPrimaryKeyMap(Entity entity) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : this.entityBean.getPrimaryKeyColumnNames()) {
            map.put(name, this.entityBean.getColumnValueAsString(entity, name));
        }
        return map;
    }

    public List<? extends Entity> getEntities() {
        return this.entities;
    }

    public Paging getPaging() {
        return this.paging;
    }

    public Action getAction() {
        return this.action;
    }
}

