/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scaffold.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskingMap<K, V>
implements Map<K, V> {
    private Map<K, V> map;
    private Set<K> visibleKeys;

    public MaskingMap(Map<K, V> map, Collection<K> visibleKeys) {
        this.map = map;
        this.visibleKeys = new HashSet<K>(visibleKeys);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.visibleKeys.contains(key)) {
            return false;
        }
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> set = new LinkedHashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            if (!this.visibleKeys.contains(entry.getKey())) continue;
            set.add(entry);
        }
        return set;
    }

    @Override
    public V get(Object key) {
        if (!this.visibleKeys.contains(key)) {
            return null;
        }
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet<K> set = new LinkedHashSet<K>();
        for (K key : this.map.keySet()) {
            if (!this.visibleKeys.contains(key)) continue;
            set.add(key);
        }
        return set;
    }

    @Override
    public V put(K key, V value) {
        if (!this.visibleKeys.contains(key)) {
            return null;
        }
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            if (!this.visibleKeys.contains(entry.getKey())) continue;
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (!this.visibleKeys.contains(key)) {
            return null;
        }
        return this.map.remove(key);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }
}

