/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scaffold.maintenance.zpt.interceptor;

import java.util.Date;
import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.ConstantElement;
import net.skirnir.freyja.Element;
import net.skirnir.freyja.EvaluationRuntimeException;
import net.skirnir.freyja.IllegalSyntaxException;
import net.skirnir.freyja.Position;
import net.skirnir.freyja.TagEvaluatorUtils;
import net.skirnir.freyja.TemplateContext;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.convention.YmirNamingConvention;
import org.seasar.ymir.scaffold.maintenance.web.MaintenancePage;
import org.seasar.ymir.zpt.MutableTagElement;
import org.seasar.ymir.zpt.TagRenderingInterceptor;
import org.seasar.ymir.zpt.TagRenderingInterceptorChain;

public class MaintenanceInterceptor
implements TagRenderingInterceptor {
    private static final String PREFIX_YS = "ys:";
    private static final String PREFIX_MAINTENANCE = "maintenance-";
    private static final String YS_EXPAND = "ys:maintenance-expand";
    private static final String EXPAND_ALL = "all";
    private static final String[] SPECIALATTRIBUTEPATTERNSTRINGS = new String[]{"^ys:maintenance-"};
    private static final String[] SPECIALTAGPATTERNSTRINGS = new String[0];
    @Binding(bindingType=BindingType.MUST)
    protected ApplicationManager applicationManager;
    @Binding(bindingType=BindingType.MUST)
    protected YmirNamingConvention ymirNamingConvention;

    public String[] getSpecialAttributePatternStrings() {
        return SPECIALATTRIBUTEPATTERNSTRINGS;
    }

    public String[] getSpecialTagPatternStrings() {
        return SPECIALTAGPATTERNSTRINGS;
    }

    public String render(TemplateContext context, String name, Attribute[] attributes, String body, TagRenderingInterceptorChain chain) {
        MutableTagElement element = MutableTagElement.newInstance((String)name, (Attribute[])attributes);
        element.setColumnNumber(context.getElement().getColumnNumber());
        element.setLineNumber(context.getElement().getLineNumber());
        try {
            element.removeAttributes(SPECIALATTRIBUTEPATTERNSTRINGS, new String[]{YS_EXPAND});
        }
        catch (IllegalSyntaxException ex) {
            throw new EvaluationRuntimeException((Throwable)ex);
        }
        if (EXPAND_ALL.equals(element.getDefilteredOriginalAttributeValue(YS_EXPAND))) {
            String columnName = element.getDefilteredOriginalAttributeValue("name");
            if (columnName == null) {
                throw new EvaluationRuntimeException("Attribute 'name' must be specified", (Position)element);
            }
            MaintenancePage self = (MaintenancePage)context.getVariableResolver().getVariable(context, "self");
            this.buildInputElement(element, self.getColumnInfo(columnName));
        }
        return chain.render(context, element.getName(), element.getAttributes(), TagEvaluatorUtils.evaluateElements((TemplateContext)context, (Element[])element.getBodyElements()));
    }

    protected void buildInputElement(MutableTagElement element, ColumnInfo columnInfo) {
        if (columnInfo == null) {
            return;
        }
        Class type = columnInfo.getPropertyType();
        if (type == String.class && "CLOB".equals(columnInfo.getColumnDbType())) {
            element.setName("textarea");
            element.removeAttribute("type");
            element.addAttribute("cols", (Object)64);
            element.addAttribute("rows", (Object)10);
            Attribute valueAttr = element.getOriginalAttribute("value");
            String value = valueAttr != null ? valueAttr.getValue() : "";
            element.setBodyElements(new Element[]{new ConstantElement(value)});
        } else {
            int size;
            element.setName("input");
            element.addAttribute("type", (Object)"text");
            if (type == String.class) {
                int columnSize = columnInfo.getColumnSize();
                if (columnSize < 500) {
                    size = (int)Math.min((double)columnSize * 1.5, 64.0);
                    element.addAttribute("maxlength", (Object)columnSize);
                } else {
                    size = 64;
                }
            } else {
                size = Date.class.isAssignableFrom(type) ? 20 : 20;
            }
            element.addAttribute("size", (Object)size);
        }
    }
}

