/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scaffold.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.Path;
import org.seasar.ymir.Request;
import org.seasar.ymir.YmirContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageUtils {
    public static final String SCHEME_FORWARD = "forward:";
    public static final String SCHEME_REDIRECT = "redirect:";
    public static final String SCHEME_PROCEED = "proceed:";
    public static final String SCHEME_PASSTHROUGH = "passthrough:";

    protected PageUtils() {
    }

    public static String transitTo(String scheme, String path, boolean asNoCache, Object ... params) {
        return scheme + PageUtils.constructPath(path, asNoCache, params);
    }

    public static String constructPath(String path, boolean asNoCache, Object ... params) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        if (params != null) {
            for (int i = 0; i < params.length; i += 2) {
                Object value;
                if (params[i] == null) {
                    throw new IllegalClientCodeRuntimeException("parameter name must be non-null value, but params[" + i + "] is null.");
                }
                if (i + 1 < params.length) {
                    value = params[i + 1];
                    if (value == null) {
                        throw new IllegalClientCodeRuntimeException("parameter value must be non-null value, but params[" + (i + 1) + "] is null.");
                    }
                } else {
                    value = "";
                }
                ArrayList<String> valueList = new ArrayList<String>();
                if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    for (int j = 0; j < length; ++j) {
                        Object v = Array.get(value, j);
                        if (v == null) {
                            throw new IllegalClientCodeRuntimeException("parameter value must be non-null value, but params[" + i + "][" + j + "] is null.");
                        }
                        valueList.add(v.toString());
                    }
                } else {
                    valueList.add(value.toString());
                }
                PageUtils.addParameter(parameterMap, params[i].toString(), valueList.toArray(new String[0]));
            }
        }
        return PageUtils.constructPath(path, asNoCache, parameterMap);
    }

    public static String constructPath(String path, boolean asNoCache, Map<String, String[]> parameterMap) {
        return PageUtils.newPath(path, parameterMap).setAsNoCache(asNoCache).asString();
    }

    public static Path newPath(String path, Map<String, String[]> parameterMap) {
        if (parameterMap == null) {
            parameterMap = new LinkedHashMap<String, String[]>();
        }
        return new Path(path, parameterMap, PageUtils.getCharacterEncoding());
    }

    public static String transitTo(String scheme, Class<?> pageClass, boolean asNoCache, Object ... params) {
        return scheme + PageUtils.constructPath(pageClass, asNoCache, params);
    }

    public static String constructPath(Class<?> pageClass, boolean asNoCache, Object ... params) {
        String path = YmirContext.getYmir().getPathOfPageClass(pageClass);
        if (path == null) {
            throw new IllegalClientCodeRuntimeException("Can't find path from page class (" + pageClass.getName() + "). You may need to add 'setReverseMapping' definition to PathMapping components in mapping.dicon");
        }
        return PageUtils.constructPath(path, asNoCache, params);
    }

    public static String constructPath(Class<?> pageClass, boolean asNoCache, Map<String, String[]> parameterMap) {
        String path = YmirContext.getYmir().getPathOfPageClass(pageClass);
        if (path == null) {
            throw new IllegalClientCodeRuntimeException("Can't find path from page class (" + pageClass.getName() + "). You may need to add 'setReverseMapping' definition to PathMapping components in mapping.dicon");
        }
        return PageUtils.constructPath(path, asNoCache, parameterMap);
    }

    public static Map<String, String[]> addParameter(Map<String, String[]> parameterMap, String name, String value) {
        if (value == null) {
            return parameterMap;
        }
        return PageUtils.addParameter(parameterMap, name, new String[]{value});
    }

    public static Map<String, String[]> addParameter(Map<String, String[]> parameterMap, String name, String[] value) {
        if (value == null || value.length == 0) {
            return parameterMap;
        }
        String[] v = parameterMap.get(name);
        if (v == null) {
            v = value;
        } else {
            String[] v2 = new String[v.length + value.length];
            System.arraycopy(v, 0, v2, 0, v.length);
            System.arraycopy(value, 0, v2, v.length, value.length);
            v = v2;
        }
        parameterMap.put(name, v);
        return parameterMap;
    }

    public static Map<String, String[]> setParameter(Map<String, String[]> parameterMap, String name, String value) {
        if (value == null) {
            parameterMap.remove(name);
            return parameterMap;
        }
        return PageUtils.setParameter(parameterMap, name, new String[]{value});
    }

    public static Map<String, String[]> setParameter(Map<String, String[]> parameterMap, String name, String[] value) {
        if (value == null || value.length == 0) {
            parameterMap.remove(name);
        } else {
            parameterMap.put(name, value);
        }
        return parameterMap;
    }

    static String getCharacterEncoding() {
        return ((Request)YmirContext.getYmir().getApplication().getS2Container().getComponent(Request.class)).getCharacterEncoding();
    }
}

