/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scaffold.maintenance.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.BehaviorWritable;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.ymir.Request;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.converter.PropertyHandler;
import org.seasar.ymir.converter.TypeConversionManager;
import org.seasar.ymir.dbflute.EntityManager;
import org.seasar.ymir.scaffold.maintenance.Constants;
import org.seasar.ymir.scaffold.maintenance.annotation.MaintenanceAdd;
import org.seasar.ymir.scaffold.maintenance.annotation.MaintenanceEdit;
import org.seasar.ymir.scaffold.maintenance.annotation.MaintenanceEntity;
import org.seasar.ymir.scaffold.maintenance.annotation.MaintenanceIndex;
import org.seasar.ymir.scaffold.maintenance.dto.ColumnDto;
import org.seasar.ymir.scaffold.maintenance.enm.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityBean
implements Constants {
    private EntityManager entityManager;
    private TypeConversionManager typeConversionManager;
    private String entityName;
    private Class<? extends Entity> entityClass;
    private DBMeta dbMeta;
    private BehaviorWritable behavior;
    private List<String> primaryKeyColumnNames;
    private String createdDateColumnName;
    private String modifiedDateColumnName;
    private List<ColumnDto> indexColumns = new ArrayList<ColumnDto>();
    private List<ColumnDto> addColumns = new ArrayList<ColumnDto>();
    private List<String> addUpdatableColumnNames = new ArrayList<String>();
    private List<ColumnDto> editColumns = new ArrayList<ColumnDto>();
    private List<String> editUpdatableColumnNames = new ArrayList<String>();
    private List<String> hiddenColumnNames = new ArrayList<String>();
    private int recordsByPage = 20;

    public EntityBean(AnnotationHandler annotationHandler, EntityManager entityManager, TypeConversionManager typeConversionManager, String entityName, Class<?> pageClass) {
        this.entityManager = entityManager;
        this.typeConversionManager = typeConversionManager;
        this.entityName = entityName;
        this.entityClass = entityManager.getEntityClass(entityName);
        if (this.entityClass == null) {
            throw new RuntimeException("Cannot find entity class for: " + entityName);
        }
        this.dbMeta = entityManager.getDBMeta(this.entityClass);
        this.behavior = entityManager.getBehavior(this.entityClass);
        this.primaryKeyColumnNames = entityManager.getPrimaryKeyColumnNames(this.entityClass);
        this.readAnnotations(annotationHandler, pageClass);
    }

    private void readAnnotations(AnnotationHandler annotationHandler, Class<?> pageClass) {
        this.createdDateColumnName = "created";
        this.modifiedDateColumnName = "modified";
        MaintenanceEntity entityAnn = (MaintenanceEntity)annotationHandler.getAnnotation(pageClass, MaintenanceEntity.class);
        if (entityAnn != null) {
            this.createdDateColumnName = entityAnn.createdDateColumn();
            if (this.createdDateColumnName.length() == 0) {
                this.createdDateColumnName = null;
            }
            this.modifiedDateColumnName = entityAnn.modifiedDateColumn();
            if (this.modifiedDateColumnName.length() == 0) {
                this.modifiedDateColumnName = null;
            }
        }
        LinkedHashSet<String> indexColumnNames = new LinkedHashSet<String>();
        HashSet<String> indexExcludeColumnNames = new HashSet<String>();
        MaintenanceIndex indexAnn = (MaintenanceIndex)annotationHandler.getAnnotation(pageClass, MaintenanceIndex.class);
        if (indexAnn != null) {
            indexColumnNames.addAll(Arrays.asList(indexAnn.columnsOrder()));
            indexExcludeColumnNames.addAll(Arrays.asList(indexAnn.excludeColumns()));
            this.recordsByPage = indexAnn.recordsByPage();
        }
        LinkedHashSet<String> addColumnNames = new LinkedHashSet<String>();
        MaintenanceAdd addAnn = (MaintenanceAdd)annotationHandler.getAnnotation(pageClass, MaintenanceAdd.class);
        if (addAnn != null) {
            addColumnNames.addAll(Arrays.asList(addAnn.columnsOrder()));
        }
        LinkedHashSet<String> editColumnNames = new LinkedHashSet<String>();
        HashSet<String> editExcludeColumnNames = new HashSet<String>();
        HashSet<String> readOnlyColumnNames = new HashSet<String>();
        MaintenanceEdit editAnn = (MaintenanceEdit)annotationHandler.getAnnotation(pageClass, MaintenanceEdit.class);
        if (editAnn != null) {
            editColumnNames.addAll(Arrays.asList(editAnn.columnsOrder()));
            editExcludeColumnNames.addAll(Arrays.asList(editAnn.excludeColumns()));
            readOnlyColumnNames.addAll(Arrays.asList(editAnn.readOnlyColumns()));
        }
        HashMap<String, ColumnInfo> columnInfoMap = new HashMap<String, ColumnInfo>();
        for (ColumnInfo columnInfo : this.dbMeta.getColumnInfoList()) {
            String name = columnInfo.getPropertyName();
            columnInfoMap.put(name, columnInfo);
            if (!"versionNo".equals(name)) {
                indexColumnNames.add(name);
                if (!columnInfo.isPrimary()) {
                    addColumnNames.add(name);
                }
                editColumnNames.add(name);
            }
            if (!columnInfo.isPrimary()) continue;
            readOnlyColumnNames.add(name);
            this.hiddenColumnNames.add(name);
        }
        addColumnNames.remove(this.createdDateColumnName);
        editColumnNames.remove(this.createdDateColumnName);
        addColumnNames.remove(this.modifiedDateColumnName);
        editColumnNames.remove(this.modifiedDateColumnName);
        for (String name : indexColumnNames) {
            if (indexExcludeColumnNames.contains(name)) continue;
            this.indexColumns.add(new ColumnDto((ColumnInfo)columnInfoMap.get(name)));
        }
        for (String name : addColumnNames) {
            this.addColumns.add(new ColumnDto((ColumnInfo)columnInfoMap.get(name)));
            this.addUpdatableColumnNames.add(name);
        }
        for (String name : editColumnNames) {
            if (editExcludeColumnNames.contains(name)) continue;
            boolean readOnly = readOnlyColumnNames.contains(name);
            this.editColumns.add(new ColumnDto((ColumnInfo)columnInfoMap.get(name), readOnly));
            if (readOnly) continue;
            this.editUpdatableColumnNames.add(name);
        }
    }

    public Class<? extends Entity> getEntityClass() {
        return this.entityClass;
    }

    public List<String> getPrimaryKeyColumnNames() {
        return this.primaryKeyColumnNames;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public ConditionBean newConditionBean() {
        return this.entityManager.newConditionBean(this.entityClass);
    }

    public BehaviorWritable getBehavior() {
        return this.behavior;
    }

    public Entity newEntity() {
        return this.entityManager.newEntity(this.entityClass);
    }

    public Entity loadEntity(Request request) {
        ConditionBean cb = this.newConditionBean();
        for (String name : this.getPrimaryKeyColumnNames()) {
            this.entityManager.setValue(cb, name, ConditionKey.CK_EQUAL, (Object)request.getParameter(name));
        }
        return this.behavior.readEntityWithDeletedCheck(cb);
    }

    public List<ColumnDto> getColumns(Action action) {
        switch (action) {
            case INDEX: {
                return this.indexColumns;
            }
            case ADD: {
                return this.addColumns;
            }
            case EDIT: {
                return this.editColumns;
            }
        }
        throw new IllegalArgumentException("Illegal action: " + action.getName());
    }

    public List<String> getUpdatableColumnNames(Action action) {
        switch (action) {
            case ADD: {
                return this.addUpdatableColumnNames;
            }
            case EDIT: {
                return this.editUpdatableColumnNames;
            }
        }
        throw new IllegalArgumentException("Illegal action: " + action.getName());
    }

    public List<String> getHiddenColumnNames(Action action) {
        if (action == Action.EDIT) {
            return this.hiddenColumnNames;
        }
        return Collections.emptyList();
    }

    public String getCreatedDateColumnName() {
        return this.createdDateColumnName;
    }

    public String getModifiedDateColumnName() {
        return this.modifiedDateColumnName;
    }

    public String getColumnValueAsString(Entity entity, String columnName) {
        PropertyHandler handler = this.typeConversionManager.getPropertyHandler((Object)entity, columnName);
        if (handler == null) {
            return null;
        }
        try {
            Object value = handler.getProperty();
            if (value != null) {
                return value.toString();
            }
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public int getRecordsByPage() {
        return this.recordsByPage;
    }

    public ColumnInfo getColumnInfo(String columnName) {
        return this.entityManager.getColumnInfo(this.entityClass, columnName);
    }
}

