/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.Element;
import net.skirnir.freyja.EvaluationRuntimeException;
import net.skirnir.freyja.ExpressionEvaluator;
import net.skirnir.freyja.FreyjaRuntimeException;
import net.skirnir.freyja.StringUtils;
import net.skirnir.freyja.TagEvaluatorUtils;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.VariableResolver;
import net.skirnir.freyja.render.html.Option;
import net.skirnir.freyja.zpt.Default;
import net.skirnir.freyja.zpt.TalTagEvaluator;
import net.skirnir.freyja.zpt.ZptTemplateContext;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.ymir.FormFile;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.MatchedPathMapping;
import org.seasar.ymir.Path;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassHint;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.FormDesc;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.impl.AnnotationDescImpl;
import org.seasar.ymir.extension.creator.impl.FormDescImpl;
import org.seasar.ymir.extension.creator.impl.MetaAnnotationDescImpl;
import org.seasar.ymir.extension.creator.mapping.impl.ActionSelectorSeedImpl;
import org.seasar.ymir.extension.zpt.AnalyzerContext;
import org.seasar.ymir.extension.zpt.AnalyzerUtils;
import org.seasar.ymir.extension.zpt.DescWrapper;
import org.seasar.ymir.extension.zpt.ParameterRole;
import org.seasar.ymir.scope.annotation.RequestParameter;
import org.seasar.ymir.util.BeanUtils;
import org.seasar.ymir.util.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzerTalTagEvaluator
extends TalTagEvaluator {
    private static final String PREFIX_STRING_EXPRESSION = "string:";
    private static final String KW_LOCAL = "local";
    private static final String KW_GLOBAL = "global ";
    private static final Set<String> BOOLEAN_ATTRIBUTE_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("compact", "noshade", "multiple", "readonly", "disabled", "nohref", "ismap", "noresize", "checked", "selected", "declare", "defer", "nowrap")));

    public String[] getSpecialTagPatternStrings() {
        return new String[]{"form", "input", "select", "textarea", "button"};
    }

    public String[] getSpecialAttributePatternStrings() {
        return (String[])ArrayUtil.add((Object[])super.getSpecialAttributePatternStrings(), (Object[])new String[]{"href", "src"});
    }

    public TemplateContext newContext() {
        return new AnalyzerContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String evaluate(TemplateContext context, String name, Attribute[] attrs, Element[] body) {
        AnalyzerContext analyzerContext = this.toAnalyzerContext(context);
        Attribute defineAttr = null;
        for (int i = 0; i < attrs.length; ++i) {
            if (!"tal:define".equals(attrs[i].getName())) continue;
            defineAttr = attrs[i];
            break;
        }
        boolean variableScopePushed = false;
        try {
            block31: {
                Set<String> runtimeAttributeNameSet;
                Map<String, Attribute> attrMap;
                block32: {
                    String type;
                    FormDesc formDesc;
                    String annotation;
                    block33: {
                        if (defineAttr != null) {
                            analyzerContext.pushVariableScope();
                            variableScopePushed = true;
                            this.processDefine(analyzerContext, context.getExpressionEvaluator(), context.getVariableResolver(), defineAttr);
                        }
                        AnnotationResult result = this.findAnnotation(context, name, attrs);
                        annotation = result.getAnnotation();
                        attrs = result.getTheOtherAttributes();
                        attrMap = this.evaluate(analyzerContext, attrs);
                        runtimeAttributeNameSet = this.getRuntimeAttributeNameSet(analyzerContext, attrs);
                        if ("form".equals(name)) {
                            analyzerContext.setFormDesc(this.registerTransitionClassDesc(analyzerContext, attrMap, runtimeAttributeNameSet, "action", this.getAttributeValue(attrMap, "method", "GET").toUpperCase(), true));
                            try {
                                String string = super.evaluate(context, name, attrs, body);
                                return string;
                            }
                            finally {
                                FormDesc formDesc2 = analyzerContext.getFormDesc();
                                if (formDesc2 != null) {
                                    formDesc2.close();
                                    analyzerContext.setFormDesc(null);
                                }
                            }
                        }
                        if (!"input".equals(name) && !"select".equals(name) && !"textarea".equals(name) && !"button".equals(name) || runtimeAttributeNameSet.contains("name")) break block32;
                        formDesc = analyzerContext.getFormDesc();
                        if (formDesc == null) break block31;
                        type = this.getAttributeValue(attrMap, "type", null);
                        if ((!"input".equals(name) || !"submit".equals(type) && !"button".equals(type) && !"image".equals(type)) && (!"button".equals(name) || !"submit".equals(type) && !"button".equals(type))) break block33;
                        formDesc.setActionMethodDesc(this.getAttributeValue(attrMap, "name", null));
                        break block31;
                    }
                    PropertyDesc propertyDesc = this.processParameterTag(analyzerContext, attrMap, annotation, formDesc);
                    if (propertyDesc != null) {
                        String parameterName = this.getAttributeValue(attrMap, "name", null);
                        boolean isRadio = "input".equals(name) && "radio".equals(type);
                        formDesc.addParameter(parameterName, isRadio);
                        TypeDesc typeDesc = propertyDesc.getTypeDesc();
                        if (!typeDesc.isExplicit()) {
                            if (analyzerContext.isInRepeat()) {
                                if (parameterName.indexOf(91) < 0 && !isRadio) {
                                    analyzerContext.setToCollection(typeDesc, null);
                                }
                            } else if (formDesc.isMultipleParameter(parameterName)) {
                                analyzerContext.setToCollection(typeDesc, null);
                            }
                            if ("input".equals(name) && "file".equals(type)) {
                                typeDesc.setComponentClassDesc(FormFile.class);
                            }
                        }
                        PropertyDesc firstPropertyDesc = formDesc.getActionPageClassDesc().getPropertyDesc(BeanUtils.getFirstSimpleSegment((String)parameterName));
                        if (formDesc.getDtoClassDesc() != null) {
                            PropertyDesc cloned = firstPropertyDesc.transcriptTo(firstPropertyDesc.getDescPool().newPropertyDesc(firstPropertyDesc.getName()));
                            cloned.setTypeDesc(firstPropertyDesc.getTypeDesc());
                            formDesc.getDtoClassDesc().setPropertyDesc(cloned);
                            firstPropertyDesc.setAnnotationDescOnGetter(new MetaAnnotationDescImpl("formProperty", new String[]{formDesc.getName()}, new Class[0]));
                            firstPropertyDesc.setAnnotationDescOnSetter(new MetaAnnotationDescImpl("formProperty", new String[]{formDesc.getName()}, new Class[0]));
                        }
                        if (BeanUtils.isSingleSegment((String)parameterName)) {
                            propertyDesc.setAnnotationDescOnSetter(new AnnotationDescImpl(RequestParameter.class.getName()));
                            break block31;
                        } else {
                            firstPropertyDesc.setAnnotationDescOnGetter(new AnnotationDescImpl(RequestParameter.class.getName()));
                        }
                    }
                    break block31;
                }
                if ("option".equals(name)) {
                    Class<org.seasar.ymir.render.html.Option> optionClass = org.seasar.ymir.render.html.Option.class;
                    if (!analyzerContext.isOnDtoSearchPath(optionClass.getName()) && !analyzerContext.isOnDtoSearchPath((optionClass = Option.class).getName())) {
                        optionClass = null;
                    }
                    if (optionClass != null) {
                        Object evaluated;
                        String returned = super.evaluate(context, name, attrs, body);
                        String statement = this.getAttributeValue(attrMap, "tal:repeat", null);
                        if (statement != null && (evaluated = context.getExpressionEvaluator().evaluate(context, context.getVariableResolver(), statement.substring(statement.indexOf(32)).trim())) instanceof DescWrapper[]) {
                            PropertyDesc pd = ((DescWrapper[])evaluated)[0].getPropertyDesc();
                            TypeDesc td = pd.getTypeDesc();
                            if (pd != null && !td.isExplicit()) {
                                td.setComponentClassDesc(optionClass);
                                td.setCollection(true);
                                if (analyzerContext.isRepeatedPropertyGeneratedAsList()) {
                                    td.setCollectionClass(List.class);
                                } else {
                                    td.setCollectionClass(null);
                                }
                            }
                        }
                        String string = returned;
                        return string;
                    }
                } else {
                    this.registerTransitionClassDesc(analyzerContext, attrMap, runtimeAttributeNameSet, "href", "GET", false);
                    this.registerTransitionClassDesc(analyzerContext, attrMap, runtimeAttributeNameSet, "src", "GET", false);
                }
            }
            String string = super.evaluate(context, name, attrs, body);
            return string;
        }
        finally {
            if (variableScopePushed) {
                analyzerContext.popVariableScope();
            }
        }
    }

    Set<String> getRuntimeAttributeNameSet(AnalyzerContext analyzerContext, Attribute[] attrs) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < attrs.length; ++i) {
            if (!"tal:attributes".equals(attrs[i].getName())) continue;
            String[] statements = this.parseStatements(TagEvaluatorUtils.defilter((String)attrs[i].getValue()));
            for (int j = 0; j < statements.length; ++j) {
                String statement = statements[j];
                int delim = statement.indexOf(32);
                String name = statement.substring(0, delim).trim();
                String expression = statement.substring(delim).trim();
                if (this.isStringTypeExpressionAndContainsRuntimeParameterOnlyAsIndex(expression) || this.isDefinedAndStringTypeExpressionAndContainsRuntimeParameterOnlyAsIndex(analyzerContext, expression)) continue;
                set.add(name);
            }
            break;
        }
        return set;
    }

    boolean isDefinedAndStringTypeExpressionAndContainsRuntimeParameterOnlyAsIndex(AnalyzerContext analyzerContext, String expression) {
        if (!AnalyzerUtils.isValidVariableName(expression)) {
            return false;
        }
        return this.isStringTypeExpressionAndContainsRuntimeParameterOnlyAsIndex(analyzerContext.getDefinedVariableExpression(expression));
    }

    boolean isStringTypeExpressionAndContainsRuntimeParameterOnlyAsIndex(String expression) {
        int idx;
        if (expression == null) {
            return false;
        }
        if (!expression.startsWith(PREFIX_STRING_EXPRESSION)) {
            return false;
        }
        expression = expression.substring(PREFIX_STRING_EXPRESSION.length()).trim();
        int pre = 0;
        while ((idx = expression.indexOf(36, pre)) >= 0) {
            if (idx == 0 || expression.charAt(idx - 1) != '[') {
                return false;
            }
            if (idx + 1 < expression.length() && expression.charAt(idx + 1) == '{') {
                int rightParen = this.findEndEdge(expression, idx + 1);
                if (rightParen + 1 >= expression.length() || expression.charAt(rightParen + 1) != ']') {
                    return false;
                }
                pre = rightParen + 2;
                continue;
            }
            int rightEdge = expression.indexOf(93, idx + 1);
            if (rightEdge < 0 || !AnalyzerUtils.isValidVariableName(expression.substring(idx + 1, rightEdge))) {
                return false;
            }
            pre = rightEdge + 1;
        }
        return true;
    }

    int findEndEdge(String expression, int idx) {
        int depth = 0;
        while (idx < expression.length()) {
            char ch = expression.charAt(idx);
            if (ch == '{') {
                ++depth;
            } else if (ch == '}') {
                --depth;
            }
            if (depth == 0) break;
            ++idx;
        }
        return idx;
    }

    FormDesc registerTransitionClassDesc(AnalyzerContext analyzerContext, Map<String, Attribute> attrMap, Set<String> runtimeAttributeNameSet, String attrName, String methodName, boolean form) {
        PropertyDesc propertyDesc;
        SourceCreator creator = analyzerContext.getSourceCreator();
        String url = this.getAttributeValue(attrMap, attrName, null);
        if ("#".equals(url)) {
            return null;
        }
        Path path = this.constructPath(analyzerContext.getPath(), url);
        if (path == null) {
            return null;
        }
        HttpMethod method = HttpMethod.enumOf((String)methodName);
        MatchedPathMapping matched = creator.findMatchedPathMapping(path.getTrunk(), method);
        if (matched == null || matched.isDenied()) {
            return null;
        }
        String className = creator.getClassName(matched.getPageComponentName());
        if (className == null) {
            return null;
        }
        ClassDesc classDesc = DescPool.getDefault().getClassDesc(className);
        block5: for (String name : path.getParameterMap().keySet()) {
            if (!this.shouldGeneratePropertyForParameter(name)) continue;
            if (BeanUtils.isSingleSegment((String)name)) {
                ParameterRole role = this.inferParameterRole(analyzerContext, path, classDesc, name);
                switch (role) {
                    case PARAMETER: {
                        propertyDesc = analyzerContext.addProperty(classDesc, name, 3);
                        propertyDesc.setAnnotationDescOnSetter(new AnnotationDescImpl(RequestParameter.class.getName()));
                        break;
                    }
                    case BUTTON: {
                        MethodDesc methodDesc = analyzerContext.getSourceCreator().newActionMethodDesc(classDesc, path.getTrunk(), HttpMethod.GET, new ActionSelectorSeedImpl(name));
                        if (classDesc.getMethodDesc(methodDesc) != null) continue block5;
                        classDesc.setMethodDesc(methodDesc);
                        break;
                    }
                    case UNDECIDED: {
                        Object[] parameters = (String[])classDesc.getAttribute("undecidedParameterNames");
                        parameters = parameters == null ? new String[]{name} : (String[])ArrayUtil.add((Object[])parameters, (Object)name);
                        classDesc.setAttribute("undecidedParameterNames", parameters);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Logic error");
                    }
                }
                continue;
            }
            PropertyDesc propertyDesc2 = analyzerContext.addProperty(classDesc, BeanUtils.getFirstSimpleSegment((String)name), 1);
            propertyDesc2.setAnnotationDescOnGetter(new AnnotationDescImpl(RequestParameter.class.getName()));
        }
        if (form) {
            String name;
            ClassDesc dtoClassDesc = null;
            String formName = null;
            if (creator.getSourceCreatorSetting().isFormDtoCreationFeatureEnabled() && !runtimeAttributeNameSet.contains("name") && AnalyzerUtils.isValidVariableName(name = this.getAttributeValue(attrMap, "name", null))) {
                formName = name;
                propertyDesc = analyzerContext.addProperty(classDesc, name, 0);
                propertyDesc.setAnnotationDesc(new MetaAnnotationDescImpl("property", new String[]{name}, new Class[0]));
                dtoClassDesc = propertyDesc.getTypeDesc().getComponentClassDesc();
                dtoClassDesc.setAttribute("ownerPage", classDesc);
            }
            return new FormDescImpl(creator, classDesc, dtoClassDesc, formName, path.getTrunk(), method);
        }
        MethodDesc methodDesc = creator.newActionMethodDesc(classDesc, path.getTrunk(), method, new ActionSelectorSeedImpl());
        classDesc.setMethodDesc(methodDesc);
        return null;
    }

    ParameterRole inferParameterRole(AnalyzerContext context, Path path, ClassDesc classDesc, String parameterName) {
        ParameterRole role;
        String[] parameterValue = (String[])path.getParameterMap().get(parameterName);
        if (parameterValue == null || parameterValue.length != 1 || !"".equals(parameterValue[0])) {
            return ParameterRole.PARAMETER;
        }
        SourceCreator sourceCreator = context.getSourceCreator();
        ClassHint classHint = context.getClassHint(classDesc.getName());
        if (classHint != null && (role = classHint.getParameterRole(parameterName)) != ParameterRole.UNDECIDED) {
            return role;
        }
        if (sourceCreator.getPropertyDescriptor(classDesc.getName(), parameterName) != null) {
            return ParameterRole.PARAMETER;
        }
        String methodName = sourceCreator.newActionMethodDesc(classDesc, path.getTrunk(), HttpMethod.GET, new ActionSelectorSeedImpl(parameterName)).getName();
        Class<?> clazz = sourceCreator.getClass(classDesc.getName());
        if (clazz != null) {
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return ParameterRole.BUTTON;
            }
        }
        return ParameterRole.UNDECIDED;
    }

    Path constructPath(String basePath, String pathWithParameters) {
        if (pathWithParameters == null) {
            return null;
        }
        return new Path(ServletUtils.toAbsolutePath((String)basePath, (String)pathWithParameters));
    }

    AnnotationResult findAnnotation(TemplateContext context, String name, Attribute[] attrs) {
        String behaviorDuplicateTag = context.getProperty("behavior.duplicate-tag");
        String annotation = null;
        ArrayList<Attribute> attrList = new ArrayList<Attribute>();
        for (int i = 0; i < attrs.length; ++i) {
            if ("tal:annotation".equals(attrs[i].getName())) {
                if (annotation != null && !"ignore".equals(behaviorDuplicateTag)) {
                    throw new EvaluationRuntimeException("Duplicate tag found: " + attrs[i].getName() + ": " + TagEvaluatorUtils.getBeginTagString((String)name, (Attribute[])attrs)).setLineNumber(attrs[i].getLineNumber()).setColumnNumber(attrs[i].getColumnNumber());
                }
                annotation = attrs[i].getValue();
                continue;
            }
            attrList.add(attrs[i]);
        }
        return new AnnotationResult(annotation, attrList.toArray(new Attribute[0]));
    }

    PropertyDesc processParameterTag(AnalyzerContext context, Map<String, Attribute> attrMap, String annotation, FormDesc formDesc) {
        String name = this.getAttributeValue(attrMap, "name", null);
        if (name != null && this.shouldGeneratePropertyForParameter(name)) {
            return context.getRequestParameterPropertyDesc(formDesc.getActionPageClassDesc(), name, 3);
        }
        return null;
    }

    boolean shouldGeneratePropertyForParameter(String name) {
        int idx;
        if (name == null || name.startsWith("org.seasar.ymir.")) {
            return false;
        }
        int pre = 0;
        while ((idx = name.indexOf(46, pre)) >= 0) {
            if (!this.shouldGeneratePropertyForParameterSegment(name.substring(pre, idx))) {
                return false;
            }
            pre = idx + 1;
        }
        return this.shouldGeneratePropertyForParameterSegment(name.substring(pre));
    }

    boolean shouldGeneratePropertyForParameterSegment(String name) {
        if (name == null) {
            return false;
        }
        if (name.endsWith("]")) {
            int lbracket = name.indexOf(91);
            if (lbracket < 0) {
                return false;
            }
            name = name.substring(0, lbracket);
        }
        return AnalyzerUtils.isValidVariableName(name);
    }

    Map<String, Attribute> evaluate(ZptTemplateContext context, Attribute[] attrs) {
        ExpressionEvaluator expEvaluator = context.getExpressionEvaluator();
        VariableResolver varResolver = context.getVariableResolver();
        ArrayList<Attribute> attrList = new ArrayList<Attribute>();
        Attribute attributesAttr = null;
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i].getName().startsWith("tal:")) {
                if (!"tal:attributes".equals(attrs[i].getName())) continue;
                attributesAttr = attrs[i];
                continue;
            }
            attrList.add(attrs[i]);
        }
        if (attributesAttr != null) {
            attrs = this.processAttributes(context, expEvaluator, varResolver, attributesAttr, attrs, true);
        }
        return TagEvaluatorUtils.toMap((Attribute[])attrs);
    }

    AnalyzerContext toAnalyzerContext(TemplateContext context) {
        return (AnalyzerContext)context;
    }

    String getAttributeValue(Map<String, Attribute> attrMap, String name, String defaultValue) {
        Attribute attr = attrMap.get(name);
        if (attr != null) {
            return TagEvaluatorUtils.defilter((String)attr.getValue());
        }
        return defaultValue;
    }

    protected boolean evaluateCondition(TemplateContext context, ExpressionEvaluator expEvaluator, VariableResolver varResolver, String condition) {
        if (condition.trim().length() == 0) {
            return false;
        }
        return this.evaluateIfTrue(context, expEvaluator, varResolver, condition);
    }

    protected boolean evaluateOmitTag(TemplateContext context, ExpressionEvaluator expEvaluator, VariableResolver varResolver, String condition) {
        if (condition.trim().length() == 0) {
            return true;
        }
        return this.evaluateIfTrue(context, expEvaluator, varResolver, condition);
    }

    protected boolean evaluateIfTrue(TemplateContext context, ExpressionEvaluator expEvaluator, VariableResolver varResolver, String condition) {
        DescWrapper wrapper;
        PropertyDesc pd;
        Object evaluated = expEvaluator.evaluate(context, varResolver, condition);
        if (evaluated instanceof DescWrapper && (pd = (wrapper = (DescWrapper)evaluated).getPropertyDesc()) != null && !pd.getTypeDesc().isExplicit()) {
            pd.decrementReferCount();
            pd.setMayBoolean(true);
        }
        return expEvaluator.isTrue(evaluated);
    }

    protected void processDefine(ZptTemplateContext talContext, ExpressionEvaluator expEvaluator, VariableResolver varResolver, Attribute attr) {
        super.processDefine(talContext, expEvaluator, varResolver, attr);
        AnalyzerContext analyzerContext = this.toAnalyzerContext((TemplateContext)talContext);
        String[] statements = this.parseStatements(TagEvaluatorUtils.defilter((String)attr.getValue()));
        for (int i = 0; i < statements.length; ++i) {
            String statement = statements[i];
            int scope = 0;
            if (statement.startsWith(KW_LOCAL)) {
                scope = 0;
                statement = StringUtils.trimLeft((String)statement.substring(KW_LOCAL.length()));
            } else if (statement.startsWith(KW_GLOBAL)) {
                scope = 1;
                statement = StringUtils.trimLeft((String)statement.substring(KW_GLOBAL.length()));
            }
            int sp = statement.indexOf(32);
            String varname = statement.substring(0, sp).trim();
            String value = StringUtils.trimLeft((String)statement.substring(sp + 1));
            analyzerContext.defineVariableExpression(scope, varname, value);
        }
    }

    protected Attribute[] processAttributes(ZptTemplateContext talContext, ExpressionEvaluator expEvaluator, VariableResolver varResolver, Attribute attr, Attribute[] htmlAttrs, boolean isHTML) {
        LinkedHashMap<String, Object> attrMap = new LinkedHashMap<String, Object>();
        String[] statements = this.parseStatements(TagEvaluatorUtils.defilter((String)attr.getValue()));
        for (int i = 0; i < statements.length; ++i) {
            Object evaluated;
            String statement = statements[i];
            int sp = statement.indexOf(32);
            if (sp < 0) {
                throw new EvaluationRuntimeException("Syntax error: " + statement).setLineNumber(attr.getLineNumber()).setColumnNumber(attr.getColumnNumber());
            }
            String varname = statement.substring(0, sp).trim();
            String value = StringUtils.trimLeft((String)statement.substring(sp + 1));
            try {
                evaluated = expEvaluator.evaluate((TemplateContext)talContext, varResolver, value);
            }
            catch (FreyjaRuntimeException ex) {
                throw ex.setLineNumber(attr.getLineNumber()).setColumnNumber(attr.getColumnNumber());
            }
            catch (RuntimeException ex) {
                throw new EvaluationRuntimeException("Can't evaluate tal:attributes expression", (Throwable)ex).setLineNumber(attr.getLineNumber()).setColumnNumber(attr.getColumnNumber());
            }
            if (evaluated != Default.instance) {
                if (isHTML && BOOLEAN_ATTRIBUTE_SET.contains(varname)) {
                    if (evaluated instanceof DescWrapper) {
                        this.changeTypeToBoolean((DescWrapper)evaluated);
                    }
                    evaluated = expEvaluator.isTrue(evaluated);
                } else if (evaluated != null) {
                    evaluated = this.renderEvaluatedValue((TemplateContext)talContext, evaluated);
                }
            }
            attrMap.put(varname, evaluated);
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>(htmlAttrs.length + attrMap.size());
        for (int i = 0; i < htmlAttrs.length; ++i) {
            String key = htmlAttrs[i].getName();
            if (attrMap.containsKey(key)) {
                Object evaluated = attrMap.get(key);
                if (isHTML && BOOLEAN_ATTRIBUTE_SET.contains(key)) {
                    if (evaluated == Default.instance || ((Boolean)evaluated).booleanValue()) {
                        String quote = htmlAttrs[i].getQuote();
                        if (quote.length() == 0) {
                            quote = "\"";
                        }
                        list.add(new Attribute(key, key, quote));
                    }
                } else if (evaluated != null) {
                    String evaluatedString = Default.instance.equals(evaluated) ? htmlAttrs[i].getValue() : TagEvaluatorUtils.filter((String)evaluated.toString());
                    list.add(new Attribute(key, evaluatedString, htmlAttrs[i].getQuote()));
                }
                attrMap.remove(key);
                continue;
            }
            list.add(htmlAttrs[i]);
        }
        for (Map.Entry entry : attrMap.entrySet()) {
            String key = (String)entry.getKey();
            Object evaluated = entry.getValue();
            if (isHTML && BOOLEAN_ATTRIBUTE_SET.contains(key)) {
                if (evaluated == Default.instance || !((Boolean)evaluated).booleanValue()) continue;
                list.add(new Attribute(key, key, "\""));
                continue;
            }
            if (evaluated == null || evaluated == Default.instance) continue;
            String evaluatedString = TagEvaluatorUtils.filter((String)evaluated.toString());
            list.add(new Attribute(key, evaluatedString, "\""));
        }
        return list.toArray(new Attribute[0]);
    }

    void changeTypeToBoolean(DescWrapper wrapper) {
        PropertyDesc propertyDesc = wrapper.getPropertyDesc();
        if (propertyDesc == null) {
            return;
        }
        TypeDesc typeDesc = propertyDesc.getTypeDesc();
        if (!typeDesc.isExplicit() && !propertyDesc.isTypeAlreadySet(2000)) {
            propertyDesc.setTypeDesc(Boolean.TYPE);
            propertyDesc.getTypeDesc().setExplicit(true);
            propertyDesc.notifyTypeUpdated(2000);
        }
    }

    static class AnnotationResult {
        private String annotation_;
        private Attribute[] theOtherAttributes_;

        public AnnotationResult(String annotation, Attribute[] theOtherAttributes) {
            this.annotation_ = annotation;
            this.theOtherAttributes_ = theOtherAttributes;
        }

        public String getAnnotation() {
            return this.annotation_;
        }

        public Attribute[] getTheOtherAttributes() {
            return this.theOtherAttributes_;
        }
    }
}

