/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.util.type;

import java.util.ArrayList;
import java.util.List;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.extension.creator.util.type.BaseToken;
import org.seasar.ymir.extension.creator.util.type.Token;
import org.seasar.ymir.extension.creator.util.type.TokenVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeToken
implements Token {
    private BaseToken name_;
    private TypeToken[] types_;

    public TypeToken(String token) {
        this.tokenize(token);
    }

    void tokenize(String string) {
        String suffix;
        if (string.endsWith("[]")) {
            suffix = "[]";
            string = string.substring(0, string.length() - "[]".length()).trim();
        } else {
            suffix = "";
        }
        int idx = string.indexOf(60);
        if (idx < 0) {
            this.name_ = new BaseToken(string + suffix);
            this.types_ = new TypeToken[0];
        } else {
            this.name_ = new BaseToken(string.substring(0, idx) + suffix);
            this.types_ = this.tokenizeTypes(string.substring(idx + 1, string.length() - 1)).toArray(new TypeToken[0]);
        }
    }

    List<TypeToken> tokenizeTypes(String string) {
        ArrayList<TypeToken> list = new ArrayList<TypeToken>();
        int beginTypeSpec = string.indexOf(60);
        int comma = string.indexOf(44);
        if (comma >= 0 && beginTypeSpec >= 0 && beginTypeSpec < comma) {
            int end = this.skipSpace(string, this.skipTypeSpec(string, beginTypeSpec) + 1);
            if (end < string.length() - "[]".length() && "[]".equals(string.substring(end, end + "[]".length()))) {
                end += "[]".length();
            }
            comma = end < string.length() && string.charAt(end) == ',' ? end : -1;
        }
        if (comma >= 0) {
            list.add(new TypeToken(string.substring(0, comma).trim()));
            list.addAll(this.tokenizeTypes(string.substring(comma + 1).trim()));
        } else {
            list.add(new TypeToken(string.trim()));
        }
        return list;
    }

    int skipSpace(String string, int begin) {
        for (int i = begin; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            return i;
        }
        return string.length();
    }

    int skipTypeSpec(String string, int begin) {
        for (int i = begin + 1; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == '<') {
                i = this.skipTypeSpec(string, i);
                continue;
            }
            if (ch != '>') continue;
            return i;
        }
        throw new IllegalArgumentException("Illegal format: " + string);
    }

    public String toString() {
        return this.getAsString();
    }

    @Override
    public String getAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DescUtils.getComponentName(this.name_.getBaseName()));
        if (this.types_.length > 0) {
            String delim = String.valueOf('<');
            for (TypeToken type : this.types_) {
                sb.append(delim).append(type.getAsString());
                delim = ", ";
            }
            sb.append('>');
        }
        if (DescUtils.isArray(this.name_.getBaseName())) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public <R> R accept(TokenVisitor<?> visitor) {
        Object result = visitor.visit(this.name_);
        if (result != null) {
            return (R)result;
        }
        for (TypeToken type : this.types_) {
            result = visitor.visit(type);
            if (result == null) continue;
            return (R)result;
        }
        return null;
    }

    public BaseToken getName() {
        return this.name_;
    }

    @Override
    public String getBaseName() {
        return this.name_.getBaseName();
    }

    @Override
    public void setBaseName(String baseName) {
        this.name_.setBaseName(baseName);
    }

    public TypeToken[] getTypes() {
        return this.types_;
    }
}

