/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator;

import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassType;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.impl.ClassDescImpl;

public class EntityMetaData {
    private DescPool pool_;
    private String entityName_;
    private String dtoClassName_;
    private String beanClassName_;
    private String daoClassName_;
    private String dxoClassName_;
    private String converterClassName_;

    public EntityMetaData(DescPool pool, String className) {
        this.pool_ = pool;
        this.analyze(className);
    }

    void analyze(String className) {
        this.entityName_ = new ClassDescImpl(null, className).getNameBase();
        String subPackageName = this.getSubPackageName(className);
        this.dtoClassName_ = this.pool_.getSourceCreator().getDtoPackageName() + "." + subPackageName + this.entityName_ + ClassType.DTO.getSuffix();
        this.beanClassName_ = this.pool_.getSourceCreator().getDaoPackageName() + "." + this.entityName_;
        this.daoClassName_ = this.pool_.getSourceCreator().getDaoPackageName() + "." + this.entityName_ + ClassType.DAO.getSuffix();
        this.dxoClassName_ = this.pool_.getSourceCreator().getDxoPackageName() + "." + subPackageName + this.entityName_ + ClassType.DXO.getSuffix();
        this.converterClassName_ = this.pool_.getSourceCreator().getConverterPackageName() + "." + subPackageName + this.entityName_ + ClassType.CONVERTER.getSuffix();
    }

    String getSubPackageName(String className) {
        String name = className.substring(this.pool_.getSourceCreator().getFirstRootPackageName().length() + 1);
        int start = name.indexOf(46) + 1;
        int end = name.lastIndexOf(46) + 1;
        return name.substring(start, end);
    }

    public String getEntityName() {
        return this.entityName_;
    }

    public ClassDesc getDtoClassDesc() {
        return this.pool_.getClassDesc(this.dtoClassName_);
    }

    public ClassDesc getBeanClassDesc() {
        return this.pool_.getClassDesc(this.beanClassName_);
    }

    public ClassDesc getDaoClassDesc() {
        return this.pool_.getClassDesc(this.daoClassName_);
    }

    public ClassDesc getDxoClassDesc() {
        return this.pool_.getClassDesc(this.dxoClassName_);
    }

    public ClassDesc getConverterClassDesc() {
        return this.pool_.getClassDesc(this.converterClassName_);
    }
}

