/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.VariableResolver;
import net.skirnir.freyja.impl.VariableResolverImpl;
import org.seasar.framework.container.S2Container;
import org.seasar.ymir.Request;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.util.GenericsUtils;
import org.seasar.ymir.extension.zpt.AnalyzerContext;
import org.seasar.ymir.extension.zpt.AnalyzerUtils;
import org.seasar.ymir.extension.zpt.DescWrapper;
import org.seasar.ymir.message.Messages;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.token.Token;

public class AnalyzerVariableResolver
implements VariableResolver {
    private VariableResolver delegated_;

    public AnalyzerVariableResolver(VariableResolver delegated) {
        this.delegated_ = delegated;
    }

    public boolean containsVariable(String name) {
        return this.delegated_.containsVariable(name);
    }

    public Object getVariable(TemplateContext context, String name) {
        VariableResolver.Entry entry = this.getVariableEntry(context, name);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    private String inferTypeOfVariable(AnalyzerContext analyzerContext, String name) {
        if ("self".equals(name)) {
            return analyzerContext.getPageClassName();
        }
        if ("notes".equals(name)) {
            return Notes.class.getName();
        }
        if ("ymirRequest".equals(name)) {
            return Request.class.getName();
        }
        if ("container".equals(name)) {
            return S2Container.class.getName();
        }
        if ("messages".equals(name)) {
            return Messages.class.getName();
        }
        if ("token".equals(name)) {
            return Token.class.getName();
        }
        if ("variables".equals(name)) {
            return VariableResolver.class.getName();
        }
        if ("param-self".equals(name)) {
            return analyzerContext.getPageClassName();
        }
        if (!AnalyzerUtils.isValidVariableName(name)) {
            return Object.class.getName();
        }
        return null;
    }

    public VariableResolver.Entry getVariableEntry(TemplateContext context, String name) {
        AnalyzerContext analyzerContext = (AnalyzerContext)context;
        if (analyzerContext != null && !analyzerContext.shouldIgnoreVariable(name)) {
            Class<Object> clazz;
            String className;
            Object value = this.delegated_.getVariable(context, name);
            if (value instanceof DescWrapper) {
                className = ((DescWrapper)value).getValueClassDesc().getName();
            } else {
                className = GenericsUtils.getNonGenericClassName(this.inferTypeOfVariable(analyzerContext, name));
                if (className != null) {
                    clazz = analyzerContext.getSourceCreator().getClass(className);
                    if (!(clazz == null || value == null || clazz.isAssignableFrom(value.getClass()) && analyzerContext.getSourceCreator().isOuter(className))) {
                        value = null;
                    }
                } else {
                    className = value != null ? value.getClass().getName() : analyzerContext.getSourceCreator().inferPropertyClassName(name, analyzerContext.getPageClassName());
                }
                if (value == null) {
                    value = new DescWrapper(analyzerContext, DescPool.getDefault().getClassDesc(className));
                }
                analyzerContext.setUsedClassName(className);
            }
            clazz = analyzerContext.getSourceCreator().getClass(className);
            if (clazz == null) {
                clazz = Object.class;
            }
            return new VariableResolverImpl.EntryImpl(name, clazz, value);
        }
        return this.delegated_.getVariableEntry(context, name);
    }

    public String[] getVariableNames() {
        return this.delegated_.getVariableNames();
    }

    public void removeVariable(String name) {
        this.delegated_.removeVariable(name);
    }

    public void setVariable(String name, Object value) {
        this.delegated_.setVariable(name, value);
    }
}

