/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.io.IORuntimeException;
import org.seasar.ymir.extension.creator.BodyDesc;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.SourceGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerSourceGenerator
implements SourceGenerator {
    private SourceCreator sourceCreator_;

    @Binding(bindingType=BindingType.MUST)
    public void setSourceCreator(SourceCreator sourceCreator) {
        this.sourceCreator_ = sourceCreator;
    }

    @Override
    public String generateGapSource(ClassDesc classDesc) {
        if (classDesc == null) {
            return null;
        }
        String templateName = classDesc.getType().getSuffix() + ".java";
        return this.generateClassSource(templateName, classDesc);
    }

    @Override
    public String generateBaseSource(ClassDesc classDesc) {
        if (classDesc == null) {
            return null;
        }
        String templateName = classDesc.getType().getSuffix() + "Base.java";
        return this.generateClassSource(templateName, classDesc);
    }

    @Override
    public String generateClassSource(String templateName, ClassDesc classDesc) {
        return this.generateSource(templateName, classDesc.getSourceGeneratorParameter());
    }

    @Override
    public String generateTemplateSource(String suffix, Map<String, Object> root) {
        return this.generateSource("Template" + suffix, root);
    }

    @Override
    public String generateBodySource(BodyDesc bodyDesc) {
        if (bodyDesc == null) {
            return null;
        }
        return this.generateSource("Body." + bodyDesc.getKey(), bodyDesc.getRoot());
    }

    String generateSource(String templateName, Map<String, Object> root) {
        Configuration cfg = new Configuration();
        cfg.setEncoding(Locale.getDefault(), "UTF-8");
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "template"));
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        root = new HashMap<String, Object>(root);
        root.put("application", this.sourceCreator_.getApplication());
        root.put("fieldSpecialPrefix", this.sourceCreator_.getSourceCreatorSetting().getFieldSpecialPrefix());
        root.put("fieldPrefix", this.sourceCreator_.getSourceCreatorSetting().getFieldPrefix());
        root.put("fieldSuffix", this.sourceCreator_.getSourceCreatorSetting().getFieldSuffix());
        StringWriter sw = new StringWriter();
        try {
            cfg.getTemplate(templateName + ".ftl").process(root, (Writer)sw);
        }
        catch (TemplateException ex) {
            throw new RuntimeException(ex);
        }
        catch (FileNotFoundException ex) {
            return "";
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
        return sw.toString();
    }
}

