/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.InvalidClassDescException;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.extension.creator.action.impl.AbstractAction;
import org.seasar.ymir.extension.creator.impl.BodyDescImpl;
import org.seasar.ymir.extension.creator.mapping.impl.ActionSelectorSeedImpl;

public class CreateClassAndTemplateAction
extends AbstractAction
implements UpdateAction {
    private static final String PARAM_REDIRECTPATH = "__ymir__redirectPath";

    public CreateClassAndTemplateAction(SourceCreator sourceCreator) {
        super(sourceCreator);
    }

    public Response act(Request request, PathMetaData pathMetaData) {
        if (this.isSkipButtonPushed(request)) {
            return null;
        }
        String subTask = request.getParameter("__ymir__subTask");
        if ("template".equals(subTask)) {
            return this.actTemplate(request, pathMetaData);
        }
        if ("redirect".equals(subTask)) {
            return this.actRedirect(request, pathMetaData);
        }
        return this.actDefault(request, pathMetaData);
    }

    Response actDefault(Request request, PathMetaData pathMetaData) {
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("pathMetaData", pathMetaData);
        return this.getSourceCreator().getResponseCreator().createResponse("createClassAndTemplate", variableMap);
    }

    Response actTemplate(Request request, PathMetaData pathMetaData) {
        String method = request.getParameter("__ymir__method");
        if (method == null) {
            return null;
        }
        this.updateMapping(pathMetaData);
        String template = this.getSourceCreator().getSourceGenerator().generateTemplateSource(this.getSuffix(pathMetaData.getTemplate().getName()), new HashMap<String, Object>());
        if (template == null) {
            template = "";
        }
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("pathMetaData", pathMetaData);
        variableMap.put("template", template);
        return this.getSourceCreator().getResponseCreator().createResponse("createClassAndTemplate_template", variableMap);
    }

    Response actRedirect(Request request, PathMetaData pathMetaData) {
        HttpMethod method = this.getHttpMethod(request);
        if (method == null) {
            return null;
        }
        String redirectPath = request.getParameter(PARAM_REDIRECTPATH);
        if (redirectPath == null) {
            return null;
        }
        DescPool pool = this.newDescPool();
        String path = pathMetaData.getPath();
        pool.setBornOf(path);
        ClassDesc classDesc = this.getSourceCreator().newClassDesc(pool, pathMetaData.getClassName(), null);
        MethodDesc methodDesc = this.getSourceCreator().newActionMethodDesc(pool, path, method, new ActionSelectorSeedImpl());
        methodDesc.setReturnTypeDesc((Type)((Object)String.class));
        methodDesc.getReturnTypeDesc().setExplicit(true);
        methodDesc.setBodyDesc(new BodyDescImpl("return " + this.quote("redirect:" + redirectPath) + ";", new String[0]));
        classDesc.setMethodDesc(methodDesc);
        String[] lackingClassNames = null;
        try {
            this.getSourceCreator().updateClass(classDesc);
        }
        catch (InvalidClassDescException ex) {
            lackingClassNames = ex.getLackingClassNames();
        }
        boolean successfullySynchronized = this.synchronizeResources(new String[]{this.getRootPackagePath()});
        this.pause(1000L);
        this.openJavaCodeInEclipseEditor(pathMetaData.getClassName());
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("pathMetaData", pathMetaData);
        variableMap.put("lackingClassNames", lackingClassNames);
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("createClassAndTemplate_redirect", variableMap);
    }
}

