/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.seasar.ymir.annotation.Meta;
import org.seasar.ymir.annotation.Metas;
import org.seasar.ymir.extension.creator.AnnotatedDesc;
import org.seasar.ymir.extension.creator.AnnotationDesc;
import org.seasar.ymir.extension.creator.BodyDesc;
import org.seasar.ymir.extension.creator.Born;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.MetaAnnotationDesc;
import org.seasar.ymir.extension.creator.MetasAnnotationDesc;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.impl.AnnotationDescImpl;
import org.seasar.ymir.extension.creator.impl.ClassDescImpl;
import org.seasar.ymir.extension.creator.impl.MetaAnnotationDescImpl;
import org.seasar.ymir.extension.creator.impl.MetasAnnotationDescImpl;
import org.seasar.ymir.extension.zpt.DescWrapper;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescUtils {
    private static final String PACKAGEPREFIX_JAVA_LANG = "java.lang.";
    private static final Pattern PATTERN_CAPABLE_PARAMETER = Pattern.compile("[a-zA-Z_0-9\\.]+");

    private DescUtils() {
    }

    public static AnnotationDesc[] newAnnotationDescs(AnnotatedElement element) {
        if (element == null) {
            return new AnnotationDesc[0];
        }
        Annotation[] annotations = element.getAnnotations();
        AnnotationDesc[] ads = new AnnotationDesc[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            ads[i] = DescUtils.newAnnotationDesc(annotations[i]);
        }
        return ads;
    }

    public static AnnotationDesc newAnnotationDesc(Annotation annotation) {
        if (annotation instanceof Metas) {
            return new MetasAnnotationDescImpl((Metas)annotation);
        }
        if (annotation instanceof Meta) {
            return new MetaAnnotationDescImpl((Meta)annotation);
        }
        return new AnnotationDescImpl(annotation);
    }

    public static void setAnnotationDesc(Map<String, AnnotationDesc> annotationDescMap, AnnotationDesc annotationDesc) {
        if (Meta.class.getName().equals(annotationDesc.getName())) {
            MetaAnnotationDesc metaAd = (MetaAnnotationDesc)annotationDesc;
            MetasAnnotationDesc metas = (MetasAnnotationDesc)annotationDescMap.get(Metas.class.getName());
            if (metas != null) {
                String metaName = metaAd.getMetaName();
                MetaAnnotationDesc[] mads = metas.getMetaAnnotationDescs();
                ArrayList<MetaAnnotationDesc> madList = new ArrayList<MetaAnnotationDesc>(mads.length + 1);
                for (MetaAnnotationDesc mad : mads) {
                    if (mad.getMetaName().equals(metaName)) {
                        metaAd = DescUtils.merge(mad, metaAd);
                        continue;
                    }
                    madList.add(mad);
                }
                madList.add(metaAd);
                metas = new MetasAnnotationDescImpl(madList.toArray(new MetaAnnotationDesc[0]));
                annotationDescMap.put(Metas.class.getName(), metas);
                return;
            }
            MetaAnnotationDesc mad = (MetaAnnotationDesc)annotationDescMap.get(Meta.class.getName());
            if (mad != null) {
                if (mad.getMetaName().equals(metaAd.getMetaName())) {
                    annotationDescMap.put(Meta.class.getName(), DescUtils.merge(mad, metaAd));
                } else {
                    annotationDescMap.put(Metas.class.getName(), new MetasAnnotationDescImpl(mad, metaAd));
                    annotationDescMap.remove(Meta.class.getName());
                }
                return;
            }
        } else if (Metas.class.getName().equals(annotationDesc.getName())) {
            MetasAnnotationDesc metasAd = (MetasAnnotationDesc)annotationDesc;
            LinkedHashMap<String, MetaAnnotationDesc> madMap = new LinkedHashMap<String, MetaAnnotationDesc>();
            MetasAnnotationDesc metas = (MetasAnnotationDesc)annotationDescMap.get(Metas.class.getName());
            MetaAnnotationDesc meta = (MetaAnnotationDesc)annotationDescMap.get(Meta.class.getName());
            if (metas != null) {
                for (MetaAnnotationDesc mad : metas.getMetaAnnotationDescs()) {
                    madMap.put(mad.getMetaName(), mad);
                }
            } else if (meta != null) {
                madMap.put(meta.getMetaName(), meta);
                annotationDescMap.remove(Meta.class.getName());
            }
            for (MetaAnnotationDesc mad : metasAd.getMetaAnnotationDescs()) {
                String metaName = mad.getMetaName();
                madMap.put(metaName, DescUtils.merge((MetaAnnotationDesc)madMap.get(metaName), mad));
            }
            metas = new MetasAnnotationDescImpl(madMap.values().toArray(new MetaAnnotationDesc[0]));
            annotationDescMap.put(Metas.class.getName(), metas);
            return;
        }
        annotationDescMap.put(annotationDesc.getName(), annotationDesc);
    }

    static MetaAnnotationDesc merge(MetaAnnotationDesc meta1, MetaAnnotationDesc meta2) {
        if (meta1 == null) {
            return meta2;
        }
        if (meta2 == null) {
            return meta1;
        }
        String name = meta2.getMetaName();
        if (DescUtils.isMergeableMeta(name)) {
            return new MetaAnnotationDescImpl(name, DescUtils.mergeValue(meta1.getValues(name), meta2.getValues(name)), DescUtils.mergeValue(meta1.getClassValues(name), meta2.getClassValues(name)));
        }
        return meta2;
    }

    public static String getMetaFirstValue(Map<String, AnnotationDesc> annotationDescMap, String name) {
        String value;
        MetaAnnotationDesc metas = (MetaAnnotationDesc)annotationDescMap.get(AnnotatedDesc.ANNOTATION_NAME_METAS);
        if (metas != null && (value = metas.getValue(name)) != null) {
            return value;
        }
        MetaAnnotationDesc meta = (MetaAnnotationDesc)annotationDescMap.get(AnnotatedDesc.ANNOTATION_NAME_META);
        if (meta != null) {
            return meta.getValue(name);
        }
        return null;
    }

    public static boolean hasMeta(Map<String, AnnotationDesc> annotationDescMap, String name) {
        MetaAnnotationDesc metas = (MetaAnnotationDesc)annotationDescMap.get(AnnotatedDesc.ANNOTATION_NAME_METAS);
        if (metas != null) {
            return metas.hasValue(name);
        }
        MetaAnnotationDesc meta = (MetaAnnotationDesc)annotationDescMap.get(AnnotatedDesc.ANNOTATION_NAME_META);
        if (meta != null) {
            return meta.hasValue(name);
        }
        return false;
    }

    public static String[] getMetaValue(Map<String, AnnotationDesc> annotationDescMap, String name) {
        String[] values;
        String[] values2;
        MetaAnnotationDesc metas = (MetaAnnotationDesc)annotationDescMap.get(AnnotatedDesc.ANNOTATION_NAME_METAS);
        if (metas != null && (values2 = metas.getValues(name)) != null) {
            return values2;
        }
        MetaAnnotationDesc meta = (MetaAnnotationDesc)annotationDescMap.get(AnnotatedDesc.ANNOTATION_NAME_META);
        if (meta != null && (values = meta.getValues(name)) != null) {
            return values;
        }
        return null;
    }

    public static Class<?>[] getMetaClassValue(Map<String, AnnotationDesc> annotationDescMap, String name) {
        Class<?>[] classValues;
        Class<?>[] classValues2;
        MetaAnnotationDesc metas = (MetaAnnotationDesc)annotationDescMap.get(AnnotatedDesc.ANNOTATION_NAME_METAS);
        if (metas != null && (classValues2 = metas.getClassValues(name)) != null) {
            return classValues2;
        }
        MetaAnnotationDesc meta = (MetaAnnotationDesc)annotationDescMap.get(AnnotatedDesc.ANNOTATION_NAME_META);
        if (meta != null && (classValues = meta.getClassValues(name)) != null) {
            return classValues;
        }
        return null;
    }

    public static MetaAnnotationDesc[] getMetaAnnotationDescs(Map<String, AnnotationDesc> annotationDescMap) {
        MetasAnnotationDesc metas = (MetasAnnotationDesc)annotationDescMap.get(AnnotatedDesc.ANNOTATION_NAME_METAS);
        if (metas != null) {
            return metas.getMetaAnnotationDescs();
        }
        MetaAnnotationDesc meta = (MetaAnnotationDesc)annotationDescMap.get(AnnotatedDesc.ANNOTATION_NAME_META);
        if (meta != null) {
            return new MetaAnnotationDesc[]{meta};
        }
        return new MetaAnnotationDesc[0];
    }

    public static boolean isMetaAnnotation(AnnotationDesc ad) {
        return ad != null && (Meta.class.getName().equals(ad.getName()) || Metas.class.getName().equals(ad.getName()));
    }

    public static void merge(PropertyDesc pd1, PropertyDesc pd2, boolean force) {
        if (!force && !pd1.isTypeAlreadySet(Integer.MAX_VALUE) && pd2.isTypeAlreadySet(Integer.MAX_VALUE) || force && (!pd1.isTypeAlreadySet(Integer.MAX_VALUE) || pd2.isTypeAlreadySet(Integer.MAX_VALUE))) {
            DescUtils.transcript(pd1.getTypeDesc(), pd2.getTypeDesc());
        } else {
            DescUtils.merge(pd1.getTypeDesc(), pd2.getTypeDesc(), force);
        }
        pd1.addMode(pd2.getMode());
        pd1.setAnnotationDescs(DescUtils.merge(pd1.getAnnotationDescs(), pd2.getAnnotationDescs(), force));
        pd1.setAnnotationDescsOnGetter(DescUtils.merge(pd1.getAnnotationDescsOnGetter(), pd2.getAnnotationDescsOnGetter(), force));
        pd1.setAnnotationDescsOnSetter(DescUtils.merge(pd1.getAnnotationDescsOnSetter(), pd2.getAnnotationDescsOnSetter(), force));
        DescUtils.mergeAttributes(pd1.getAttributeMap(), pd2.getAttributeMap(), force);
    }

    public static void merge(MethodDesc md1, MethodDesc md2, boolean force) {
        BodyDesc bodyDesc;
        TypeDesc returnTd2;
        TypeDesc returnTd1;
        if (force) {
            md1.setParameterDescs(md2.getParameterDescs());
        }
        if (DescUtils.merge(returnTd1 = md1.getReturnTypeDesc(), returnTd2 = md2.getReturnTypeDesc(), force) && (bodyDesc = md2.getBodyDesc()) != null) {
            md1.setBodyDesc(bodyDesc);
        }
        md1.setAnnotationDescs(DescUtils.merge(md1.getAnnotationDescs(), md2.getAnnotationDescs(), force));
        DescUtils.mergeAttributes(md1.getAttributeMap(), md2.getAttributeMap(), force);
    }

    public static boolean merge(TypeDesc td1, TypeDesc td2, boolean force) {
        if (td1.equals(td2)) {
            return force;
        }
        if (!force && !td1.isExplicit() && td2.isExplicit() || force && (!td1.isExplicit() || td2.isExplicit())) {
            DescUtils.transcript(td1, td2);
            return true;
        }
        if (td1.getCollectionClassName() != null && td1.getCollectionClassName().equals(td2.getCollectionClassName()) && td1.getCollectionImplementationClassName() == null) {
            td1.setCollectionImplementationClassName(td2.getCollectionImplementationClassName());
        }
        return false;
    }

    static void transcript(TypeDesc toTypeDesc, TypeDesc fromTypeDesc) {
        boolean transcriptCollectionImplementationClassName = true;
        if (toTypeDesc.getCollectionClassName() != null && toTypeDesc.getCollectionClassName().equals(fromTypeDesc.getCollectionClassName()) && fromTypeDesc.getCollectionImplementationClassName() == null) {
            transcriptCollectionImplementationClassName = false;
        }
        toTypeDesc.setComponentClassDesc(fromTypeDesc.getComponentClassDesc());
        toTypeDesc.setCollection(fromTypeDesc.isCollection());
        toTypeDesc.setCollectionClassName(fromTypeDesc.getCollectionClassName());
        if (transcriptCollectionImplementationClassName) {
            toTypeDesc.setCollectionImplementationClassName(fromTypeDesc.getCollectionImplementationClassName());
        }
    }

    public static AnnotationDesc[] merge(AnnotationDesc[] ad1s, AnnotationDesc[] ad2s, boolean force) {
        ClassDescImpl dummyCd = new ClassDescImpl(null, "");
        if (force) {
            for (AnnotationDesc ad1 : ad1s) {
                dummyCd.setAnnotationDesc(ad1);
            }
            for (AnnotationDesc ad2 : ad2s) {
                dummyCd.setAnnotationDesc(ad2);
            }
        } else {
            for (AnnotationDesc ad2 : ad2s) {
                dummyCd.setAnnotationDesc(ad2);
            }
            for (AnnotationDesc ad1 : ad1s) {
                dummyCd.setAnnotationDesc(ad1);
            }
        }
        return dummyCd.getAnnotationDescs();
    }

    public static Class<?> getClass(String className) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = DescUtils.class.getClassLoader();
        }
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class<?> findClass(String className) {
        if (className == null) {
            return null;
        }
        Class clazz = ClassUtils.getPrimitive((String)className);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = DescUtils.class.getClassLoader();
        }
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            if (className.indexOf(46) < 0) {
                try {
                    return cl.loadClass(PACKAGEPREFIX_JAVA_LANG + className);
                }
                catch (ClassNotFoundException ignore) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static void removeMetaAnnotationDesc(Map<String, AnnotationDesc> annotationDescMap, String metaName) {
        MetasAnnotationDesc metas = (MetasAnnotationDesc)annotationDescMap.get(Metas.class.getName());
        if (metas != null) {
            MetaAnnotationDesc[] mads = metas.getMetaAnnotationDescs();
            ArrayList<MetaAnnotationDesc> madList = new ArrayList<MetaAnnotationDesc>(mads.length);
            for (MetaAnnotationDesc mad : mads) {
                if (mad.getMetaName().equals(metaName)) continue;
                madList.add(mad);
            }
            if (madList.size() > 0) {
                metas = new MetasAnnotationDescImpl(madList.toArray(new MetaAnnotationDesc[0]));
                annotationDescMap.put(Metas.class.getName(), metas);
            } else {
                annotationDescMap.remove(Metas.class.getName());
            }
        } else {
            MetaAnnotationDesc meta = (MetaAnnotationDesc)annotationDescMap.get(Meta.class.getName());
            if (meta != null && meta.getMetaName().equals(metaName)) {
                annotationDescMap.remove(Meta.class.getName());
            }
        }
    }

    static boolean isMergeableMeta(String metaName) {
        return metaName.equals("bornOf");
    }

    static <T> T[] mergeValue(T[] values1, T[] values2) {
        if (values1 == null && values2 == null) {
            return null;
        }
        TreeSet<T> valueSet = new TreeSet<T>();
        if (values1 != null) {
            valueSet.addAll(Arrays.asList(values1));
        }
        if (values2 != null) {
            valueSet.addAll(Arrays.asList(values2));
        }
        return valueSet.toArray((Object[])Array.newInstance(values1.getClass().getComponentType(), valueSet.size()));
    }

    public static String getPackageName(DescWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        return wrapper.getValueClassDesc().getPackageName();
    }

    public static String getPackageName(ClassDesc classDesc) {
        if (classDesc == null) {
            return null;
        }
        return classDesc.getPackageName();
    }

    public static String capFirst(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static Field findField(String fieldName, Class<?> clazz) {
        if (fieldName == null) {
            return null;
        }
        while (true) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((clazz = clazz.getSuperclass()) != null && clazz != Object.class) continue;
                return null;
            }
            break;
        }
    }

    public static void removeStandardClassNames(Set<String> classNameSet) {
        Iterator<String> itr = classNameSet.iterator();
        while (itr.hasNext()) {
            String className = itr.next();
            if (!ClassUtils.isStandard((String)className)) continue;
            itr.remove();
        }
    }

    public static AnnotationDesc newBornOfMetaAnnotationDesc(String[] values) {
        return DescUtils.newBornOfMetaAnnotationDesc(values, null);
    }

    public static AnnotationDesc newBornOfMetaAnnotationDesc(String[] values, String bornOf) {
        if (bornOf != null) {
            if (values == null) {
                values = new String[]{bornOf};
            } else {
                TreeSet<String> set = new TreeSet<String>(Arrays.asList(values));
                set.add(bornOf);
                values = set.toArray(new String[0]);
            }
        }
        return new MetaAnnotationDescImpl("bornOf", values);
    }

    public static void mergeAttributes(Map<String, Object> attributeMap, Map<String, Object> attributeMap2, boolean force) {
        for (Map.Entry<String, Object> entry : attributeMap2.entrySet()) {
            String key = entry.getKey();
            Object value = attributeMap.containsKey(key) ? ("parameters".equals(key) ? DescUtils.mergeParametersAttribute(attributeMap.get(key), entry.getValue(), force) : (force ? entry.getValue() : attributeMap.get(key))) : entry.getValue();
            attributeMap.put(key, value);
        }
    }

    private static Born<String>[] mergeParametersAttribute(Object parameters, Object parameters2, boolean force) {
        LinkedHashMap map = new LinkedHashMap();
        for (Born parameter : (Born[])parameters) {
            map.put(parameter.getElement(), parameter);
        }
        for (Born parameter2 : (Born[])parameters2) {
            Born born = new Born(parameter2.getElement(), parameter2.getBornOf());
            Born parameter = (Born)map.get(parameter2.getElement());
            if (parameter != null) {
                born.addBornOf(parameter.getBornOf());
            }
            map.put(parameter2.getElement(), born);
        }
        return map.values().toArray(new Born[0]);
    }

    public static void addParameter(PropertyDesc propertyDesc, String parameter) {
        String[] stringArray;
        String bornOf = propertyDesc.getDescPool().getBornOf();
        if (bornOf != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = bornOf;
        } else {
            stringArray = null;
        }
        DescUtils.addParameter(propertyDesc, parameter, stringArray);
    }

    public static void addParameter(PropertyDesc propertyDesc, String parameter, String[] bornOf) {
        if (!DescUtils.isCapableParameter(parameter)) {
            return;
        }
        Born[] parameterBorns = (Born[])propertyDesc.getAttribute("parameters");
        Born<String> newBorn = new Born<String>(parameter, bornOf);
        if (parameterBorns == null) {
            parameterBorns = new Born[]{newBorn};
        } else {
            for (Born born : parameterBorns) {
                if (!parameter.equals(born.getElement())) continue;
                return;
            }
            Born[] newParameterBorns = new Born[parameterBorns.length + 1];
            System.arraycopy(parameterBorns, 0, newParameterBorns, 0, parameterBorns.length);
            newParameterBorns[parameterBorns.length] = newBorn;
            parameterBorns = newParameterBorns;
        }
        propertyDesc.setAttribute("parameters", parameterBorns);
    }

    static boolean isCapableParameter(String parameter) {
        return PATTERN_CAPABLE_PARAMETER.matcher(parameter).matches();
    }

    public static void removeBornOfFromAttributes(String bornOf, Map<String, Object> attributeMap) {
        for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
            if (!"parameters".equals(entry.getKey())) continue;
            ArrayList<Born> list = new ArrayList<Born>();
            for (Born parameter : (Born[])entry.getValue()) {
                if (parameter.removeBornOf(bornOf)) continue;
                list.add(parameter);
            }
            entry.setValue(list.toArray(new Born[0]));
        }
    }
}

