/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import org.seasar.kvasir.util.StringUtils;
import org.seasar.ymir.annotation.Meta;
import org.seasar.ymir.extension.creator.MetaAnnotationDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaAnnotationDescImpl
implements MetaAnnotationDesc {
    private String metaName_;
    private String[] metaValue_;
    private Class<?>[] metaClassValue_;

    public MetaAnnotationDescImpl(Meta meta) {
        this(meta.name(), meta.value(), meta.classValue());
    }

    public MetaAnnotationDescImpl(String metaName, String[] metaValue) {
        this(metaName, metaValue, new Class[0]);
    }

    public MetaAnnotationDescImpl(String metaName, Class<?>[] metaClassValue) {
        this(metaName, new String[0], metaClassValue);
    }

    public MetaAnnotationDescImpl(String metaName, String[] metaValue, Class<?>[] metaClassValue) {
        this.metaName_ = metaName;
        this.metaValue_ = metaValue;
        this.metaClassValue_ = metaClassValue;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public String getString() {
        return "@" + this.getName() + this.getBody();
    }

    @Override
    public String getMetaName() {
        return this.metaName_;
    }

    @Override
    public String getBody() {
        StringBuilder sb = new StringBuilder();
        sb.append("(name = \"").append(this.metaName_).append("\"");
        if (this.metaValue_.length > 0) {
            sb.append(", value = ").append(this.toLiteral(this.metaValue_));
        }
        if (this.metaClassValue_.length > 0) {
            sb.append(", classValue = ").append(this.toLiteral(this.metaClassValue_));
        }
        sb.append(")");
        return sb.toString();
    }

    protected String toLiteral(Object[] objs) {
        if (objs == null) {
            return String.valueOf(null);
        }
        if (objs.length == 1) {
            return this.toLiteral(objs[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String delim = "";
        for (int i = 0; i < objs.length; ++i) {
            sb.append(delim).append(this.toLiteral(objs[i]));
            delim = ", ";
        }
        sb.append("}");
        return sb.toString();
    }

    protected String toLiteral(Object obj) {
        if (obj == null) {
            return String.valueOf(null);
        }
        if (obj instanceof Class) {
            return ((Class)obj).getName() + ".class";
        }
        return StringUtils.quoteString((String)obj.toString(), (char)'\"');
    }

    @Override
    public String getName() {
        return Meta.class.getName();
    }

    @Override
    public void setBody(String body) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getValue(String name) {
        if (name.equals(this.metaName_) && this.metaValue_.length > 0) {
            return this.metaValue_[0];
        }
        return null;
    }

    @Override
    public boolean hasValue(String name) {
        return name.equals(this.metaName_);
    }

    @Override
    public String[] getValues(String name) {
        if (name.equals(this.metaName_)) {
            return this.metaValue_;
        }
        return null;
    }

    @Override
    public Class<?>[] getClassValues(String name) {
        if (name.equals(this.metaName_)) {
            return this.metaClassValue_;
        }
        return null;
    }
}

