/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassType;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.action.impl.PropertyDescDto;

public class ClassDescDto {
    private String name_;
    private PropertyDescDto[] propertyDescs_;
    private boolean checked_;
    private boolean dto_;
    private boolean page_;
    private String pairTypeName_;
    private String superclassName_;
    private String[] undecidedParameterNames_;

    public ClassDescDto(ClassDesc classDesc, boolean checked) {
        this.name_ = classDesc.getName();
        this.checked_ = checked;
        this.dto_ = classDesc.isTypeOf(ClassType.DTO);
        this.page_ = classDesc.isTypeOf(ClassType.PAGE);
        this.pairTypeName_ = PropertyUtils.join((String[])classDesc.getMetaValue("conversion"));
        String superclassName = classDesc.getSuperclassName();
        if (Object.class.getName().equals(superclassName)) {
            superclassName = null;
        }
        this.superclassName_ = superclassName;
        this.undecidedParameterNames_ = (String[])classDesc.getAttribute("undecidedParameterNames");
        ClassDesc ownerPageClassDesc = (ClassDesc)classDesc.getAttribute("ownerPage");
        PropertyDesc[] pds = classDesc.getPropertyDescs();
        this.propertyDescs_ = new PropertyDescDto[pds.length];
        for (int i = 0; i < pds.length; ++i) {
            this.propertyDescs_[i] = new PropertyDescDto(pds[i], ownerPageClassDesc != null && ownerPageClassDesc.getPropertyDesc(pds[i].getName()) != null);
        }
    }

    public boolean isChecked() {
        return this.checked_;
    }

    public String getName() {
        return this.name_;
    }

    public PropertyDescDto[] getPropertyDescs() {
        return this.propertyDescs_;
    }

    public boolean isDto() {
        return this.dto_;
    }

    public boolean isPage() {
        return this.page_;
    }

    public String getPairTypeName() {
        return this.pairTypeName_;
    }

    public String getSuperclassName() {
        return this.superclassName_;
    }

    public String[] getUndecidedParameterNames() {
        return this.undecidedParameterNames_;
    }
}

