/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.ymir.extension.creator.ClassCreationHintBag;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.ParameterDesc;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.impl.MethodDescImpl;
import org.seasar.ymir.extension.creator.impl.ParameterDescImpl;
import org.seasar.ymir.extension.creator.impl.PropertyDescImpl;
import org.seasar.ymir.extension.creator.impl.TypeDescImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescPool
implements Iterable<ClassDesc> {
    private static ThreadLocal<DescPool> pools_ = new ThreadLocal();
    private Map<String, ClassDesc> classDescMap_ = new HashMap<String, ClassDesc>();
    private SourceCreator sourceCreator_;
    private ClassCreationHintBag hintBag_;

    private DescPool(SourceCreator sourceCreator, ClassCreationHintBag hintBag) {
        this.sourceCreator_ = sourceCreator;
        this.hintBag_ = hintBag;
    }

    public static DescPool getDefault() {
        return pools_.get();
    }

    public static void setDefault(DescPool pool) {
        pools_.set(pool);
    }

    public static DescPool newInstance(SourceCreator sourceCreator, ClassCreationHintBag hintBag) {
        return new DescPool(sourceCreator, hintBag);
    }

    public ClassDesc getClassDesc(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return this.getClassDesc(clazz.getName());
    }

    public ClassDesc getClassDesc(String className) {
        if (className == null) {
            return null;
        }
        ClassDesc classDesc = this.classDescMap_.get(className);
        if (classDesc == null) {
            classDesc = this.sourceCreator_.newClassDesc(this, className, this.hintBag_);
            this.classDescMap_.put(className, classDesc);
        }
        return classDesc;
    }

    public TypeDesc newTypeDesc(String typeName) {
        return new TypeDescImpl(this, typeName);
    }

    public TypeDesc newTypeDesc(Type type) {
        return new TypeDescImpl(this, type);
    }

    public TypeDesc newTypeDesc(ClassDesc classDesc) {
        return new TypeDescImpl(this, classDesc);
    }

    public void clear() {
        this.classDescMap_.clear();
    }

    @Override
    public Iterator<ClassDesc> iterator() {
        return this.classDescMap_.values().iterator();
    }

    public List<ClassDesc> getGeneratedClassDescs() {
        ArrayList<ClassDesc> list = new ArrayList<ClassDesc>();
        for (ClassDesc classDesc : this.classDescMap_.values()) {
            if (!this.getSourceCreator().isGeneratedClass(classDesc.getName())) continue;
            list.add(classDesc);
        }
        return list;
    }

    public boolean contains(String className) {
        return this.classDescMap_.containsKey(className);
    }

    public ClassCreationHintBag getHintBag() {
        return this.hintBag_;
    }

    public SourceCreator getSourceCreator() {
        return this.sourceCreator_;
    }

    public ClassDesc registerClassDesc(ClassDesc classDesc) {
        if (classDesc.getDescPool() != this) {
            throw new IllegalArgumentException("Can't register ClassDesc born from another DescPool");
        }
        return this.classDescMap_.put(classDesc.getName(), classDesc);
    }

    public ClassDesc unregisterClassDesc(String className) {
        if (className == null) {
            return null;
        }
        return this.classDescMap_.remove(className);
    }

    public ClassDesc unregisterClassDesc(ClassDesc classDesc) {
        if (classDesc == null) {
            return null;
        }
        if (classDesc.getDescPool() != this) {
            throw new IllegalArgumentException("Can't unregister ClassDesc born from another DescPool");
        }
        return this.classDescMap_.remove(classDesc.getName());
    }

    public PropertyDesc newPropertyDesc(String name) {
        return new PropertyDescImpl(this, name);
    }

    public MethodDesc newMethodDesc(String name) {
        return new MethodDescImpl(this, name);
    }

    public ParameterDesc newParameterDesc() {
        return new ParameterDescImpl(this);
    }
}

