/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.ymir.extension.creator.AnnotationDesc;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.Desc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.MetaAnnotationDesc;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.impl.AbstractAnnotatedDesc;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescImpl
extends AbstractAnnotatedDesc
implements PropertyDesc {
    private static final Log log_ = LogFactory.getLog(PropertyDescImpl.class);
    private DescPool pool_;
    private Desc<?> parent_;
    private String name_;
    private TypeDesc typeDesc_;
    private int mode_;
    private int probability_ = 0;
    private Map<String, AnnotationDesc> annotationDescForGetterMap_ = new TreeMap<String, AnnotationDesc>();
    private Map<String, AnnotationDesc> annotationDescForSetterMap_ = new TreeMap<String, AnnotationDesc>();
    private String getterName_;
    private boolean mayBoolean_;
    private int referCount_;

    public PropertyDescImpl(DescPool pool, String name) {
        this.pool_ = pool;
        this.name_ = name;
        this.setTypeDesc((Type)((Object)String.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDescImpl(DescPool pool, PropertyDescriptor descriptor) {
        Field field;
        this.pool_ = pool;
        this.name_ = descriptor.getName();
        this.setTypeDesc(this.newTypeDesc(descriptor));
        if (descriptor.getReadMethod() != null) {
            this.addMode(1);
            this.setGetterName(descriptor.getReadMethod().getName());
            for (AnnotationDesc annotationDesc : DescUtils.newAnnotationDescs(descriptor.getReadMethod())) {
                this.setAnnotationDescOnGetter(annotationDesc);
            }
        }
        if (descriptor.getWriteMethod() != null) {
            this.addMode(2);
            for (AnnotationDesc annotationDesc : DescUtils.newAnnotationDescs(descriptor.getWriteMethod())) {
                this.setAnnotationDescOnSetter(annotationDesc);
            }
        }
        if ((field = this.findField(descriptor)) != null) {
            for (AnnotationDesc annotationDesc : DescUtils.newAnnotationDescs(field)) {
                this.setAnnotationDesc(annotationDesc);
            }
            if (List.class.isAssignableFrom(descriptor.getPropertyType()) && field != null) {
                Class<?> clazz = descriptor.getReadMethod() != null ? descriptor.getReadMethod().getDeclaringClass() : descriptor.getWriteMethod().getDeclaringClass();
                boolean accessible = field.isAccessible();
                try {
                    field.setAccessible(true);
                    Object instance = ClassUtils.newInstance(clazz);
                    Object value = field.get(instance);
                    if (value != null) {
                        this.getTypeDesc().setCollectionImplementationClass(value.getClass());
                    }
                }
                catch (Throwable ignore) {
                    log_.debug((Object)("Can't get initial value of field (" + field.getName() + "): class=" + clazz.getName()), ignore);
                }
                finally {
                    field.setAccessible(accessible);
                }
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name_ == null ? 0 : this.name_.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDescImpl other = (PropertyDescImpl)obj;
        return !(this.name_ == null ? other.name_ != null : !this.name_.equals(other.name_));
    }

    private TypeDesc newTypeDesc(PropertyDescriptor descriptor) {
        Type type = descriptor.getReadMethod() != null ? descriptor.getReadMethod().getGenericReturnType() : descriptor.getWriteMethod().getGenericParameterTypes()[0];
        return this.pool_.newTypeDesc(type);
    }

    private Field findField(PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        Field field = this.pool_.getSourceCreator().findField(descriptor.getReadMethod(), name);
        if (field == null) {
            field = this.pool_.getSourceCreator().findField(descriptor.getWriteMethod(), name);
        }
        return field;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.typeDesc_).append(" ").append(this.name_).append("(");
        if ((this.mode_ & 1) != 0) {
            sb.append("r");
        }
        if ((this.mode_ & 2) != 0) {
            sb.append("w");
        }
        sb.append(")");
        String initialValue = this.getInitialValue();
        if (initialValue != null) {
            sb.append(" = ").append(initialValue);
        }
        return sb.toString();
    }

    @Override
    public DescPool getDescPool() {
        return this.pool_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public TypeDesc getTypeDesc() {
        return this.typeDesc_;
    }

    @Override
    public void setTypeDesc(TypeDesc typeDesc) {
        this.typeDesc_ = typeDesc;
        this.typeDesc_.setParent(this);
    }

    @Override
    public TypeDesc setTypeDesc(Type type) {
        TypeDesc typeDesc = this.pool_.newTypeDesc(type);
        this.setTypeDesc(typeDesc);
        return typeDesc;
    }

    @Override
    public int getMode() {
        return this.mode_;
    }

    @Override
    public void setMode(int mode) {
        this.mode_ = mode;
    }

    @Override
    public void addMode(int mode) {
        this.mode_ |= mode;
    }

    @Override
    public boolean isReadable() {
        return (this.mode_ & 1) != 0;
    }

    @Override
    public boolean isWritable() {
        return (this.mode_ & 2) != 0;
    }

    @Override
    public String getGetterName() {
        return this.getterName_ != null ? this.getterName_ : this.constructGetterName();
    }

    @Override
    public void setGetterName(String getterName) {
        this.getterName_ = getterName;
    }

    String constructGetterName() {
        if ("boolean".equals(this.typeDesc_.getName())) {
            return "is" + DescUtils.capFirst(this.name_);
        }
        return "get" + DescUtils.capFirst(this.name_);
    }

    @Override
    public boolean isTypeAlreadySet(int probability) {
        return this.probability_ >= probability;
    }

    @Override
    public void notifyTypeUpdated(int probability) {
        if (this.isTypeAlreadySet(probability)) {
            throw new IllegalStateException("Can't make probability down: current=" + this.probability_ + ", new=" + probability);
        }
        this.probability_ = probability;
    }

    @Override
    public AnnotationDesc getAnnotationDescOnGetter(String name) {
        return this.annotationDescForGetterMap_.get(name);
    }

    @Override
    public void setAnnotationDescOnGetter(AnnotationDesc annotationDesc) {
        DescUtils.setAnnotationDesc(this.annotationDescForGetterMap_, annotationDesc);
    }

    @Override
    public void removeMetaAnnotationDescOnGetter(String metaName) {
        DescUtils.removeMetaAnnotationDesc(this.annotationDescForGetterMap_, metaName);
    }

    @Override
    public void removeMetaAnnotationDescOnSetter(String metaName) {
        DescUtils.removeMetaAnnotationDesc(this.annotationDescForSetterMap_, metaName);
    }

    @Override
    public AnnotationDesc[] getAnnotationDescsOnGetter() {
        return this.annotationDescForGetterMap_.values().toArray(new AnnotationDesc[0]);
    }

    @Override
    public void setAnnotationDescsOnGetter(AnnotationDesc[] annotationDescs) {
        this.annotationDescForGetterMap_.clear();
        for (AnnotationDesc annotationDesc : annotationDescs) {
            this.setAnnotationDescOnGetter(annotationDesc);
        }
    }

    @Override
    public AnnotationDesc getAnnotationDescOnSetter(String name) {
        return this.annotationDescForSetterMap_.get(name);
    }

    @Override
    public void setAnnotationDescOnSetter(AnnotationDesc annotationDesc) {
        DescUtils.setAnnotationDesc(this.annotationDescForSetterMap_, annotationDesc);
    }

    @Override
    public AnnotationDesc[] getAnnotationDescsOnSetter() {
        return this.annotationDescForSetterMap_.values().toArray(new AnnotationDesc[0]);
    }

    @Override
    public void setAnnotationDescsOnSetter(AnnotationDesc[] annotationDescs) {
        this.annotationDescForSetterMap_.clear();
        for (AnnotationDesc annotationDesc : annotationDescs) {
            this.setAnnotationDescOnSetter(annotationDesc);
        }
    }

    @Override
    public void setAnnotationDescs(AnnotationDesc[] annotationDescs) {
        super.clear();
        for (AnnotationDesc annotationDesc : annotationDescs) {
            this.setAnnotationDesc(annotationDesc);
        }
    }

    @Override
    public String getMetaFirstValueOnGetter(String name) {
        return DescUtils.getMetaFirstValue(this.annotationDescForGetterMap_, name);
    }

    @Override
    public String getMetaFirstValueOnSetter(String name) {
        return DescUtils.getMetaFirstValue(this.annotationDescForSetterMap_, name);
    }

    @Override
    public String[] getMetaValueOnGetter(String name) {
        return DescUtils.getMetaValue(this.annotationDescForGetterMap_, name);
    }

    @Override
    public String[] getMetaValueOnSetter(String name) {
        return DescUtils.getMetaValue(this.annotationDescForSetterMap_, name);
    }

    @Override
    public Class<?>[] getMetaClassValueOnGetter(String name) {
        return DescUtils.getMetaClassValue(this.annotationDescForGetterMap_, name);
    }

    @Override
    public Class<?>[] getMetaClassValueOnSetter(String name) {
        return DescUtils.getMetaClassValue(this.annotationDescForSetterMap_, name);
    }

    @Override
    public boolean hasMetaOnGetter(String name) {
        return DescUtils.hasMeta(this.annotationDescForGetterMap_, name);
    }

    @Override
    public boolean hasMetaOnSetter(String name) {
        return DescUtils.hasMeta(this.annotationDescForSetterMap_, name);
    }

    @Override
    public MetaAnnotationDesc[] getMetaAnnotationDescsOnGetter() {
        return DescUtils.getMetaAnnotationDescs(this.annotationDescForGetterMap_);
    }

    @Override
    public MetaAnnotationDesc[] getMetaAnnotationDescsOnSetter() {
        return DescUtils.getMetaAnnotationDescs(this.annotationDescForSetterMap_);
    }

    @Override
    public String getInitialValue() {
        if (this.typeDesc_ == null) {
            return null;
        }
        String initialValue = null;
        ClassDesc componentClassDesc = this.typeDesc_.getComponentClassDesc();
        String componentClassName = componentClassDesc.getName();
        if (this.typeDesc_.isCollection()) {
            String collectionClassName = this.typeDesc_.getCollectionClassName();
            if (collectionClassName != null) {
                String collectionImplementationClassName = this.typeDesc_.getCollectionImplementationClassName();
                if (collectionImplementationClassName != null) {
                    initialValue = "new " + DescUtils.normalizePackage(collectionImplementationClassName + "<" + componentClassName + ">") + "()";
                } else if (List.class.getName().equals(collectionClassName)) {
                    initialValue = "new " + DescUtils.normalizePackage(ArrayList.class.getName() + "<" + componentClassName + ">") + "()";
                }
            } else {
                initialValue = "new " + DescUtils.normalizePackage(componentClassName) + "[0]";
            }
        } else {
            boolean generateInitialValue = false;
            if (this.pool_.getSourceCreator().isDtoClass(componentClassName)) {
                Class<?> clazz = DescUtils.getClass(componentClassName);
                if (clazz != null) {
                    try {
                        clazz.newInstance();
                        generateInitialValue = true;
                    }
                    catch (InstantiationException ignore) {
                    }
                    catch (IllegalAccessException ignore) {}
                } else {
                    generateInitialValue = true;
                }
            }
            if (generateInitialValue) {
                initialValue = "new " + this.typeDesc_.getName() + "()";
            }
        }
        return initialValue;
    }

    @Override
    public PropertyDesc transcriptTo(PropertyDesc desc) {
        DescPool pool = desc.getDescPool();
        super.transcriptTo(desc);
        if (this.typeDesc_ != null) {
            desc.setTypeDesc(this.typeDesc_.transcriptTo(pool.newTypeDesc(this.typeDesc_.getName())));
        }
        desc.setMode(this.mode_);
        if (this.probability_ > 0) {
            desc.notifyTypeUpdated(this.probability_);
        }
        for (AnnotationDesc annotationDesc : this.getAnnotationDescsOnGetter()) {
            desc.setAnnotationDescOnGetter((AnnotationDesc)annotationDesc.clone());
        }
        for (AnnotationDesc annotationDesc : this.getAnnotationDescsOnSetter()) {
            desc.setAnnotationDescOnSetter((AnnotationDesc)annotationDesc.clone());
        }
        desc.setGetterName(this.getterName_);
        return desc;
    }

    @Override
    public <D extends Desc<?>> D getParent() {
        return (D)this.parent_;
    }

    @Override
    public void setParent(Desc<?> parent) {
        this.parent_ = parent;
    }

    @Override
    public boolean isMayBoolean() {
        return this.mayBoolean_;
    }

    @Override
    public void setMayBoolean(boolean mayBoolean) {
        this.mayBoolean_ = mayBoolean;
    }

    @Override
    public int getReferCount() {
        return this.referCount_;
    }

    @Override
    public void setReferCount(int referCount) {
        this.referCount_ = referCount;
    }

    @Override
    public void incrementReferCount() {
        ++this.referCount_;
    }

    @Override
    public void decrementReferCount() {
        --this.referCount_;
    }

    @Override
    public int getProbability() {
        return this.probability_;
    }
}

