/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.extension.creator.AnnotatedDesc;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassType;
import org.seasar.ymir.extension.creator.Desc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.MethodDescKey;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.impl.AbstractAnnotatedDesc;
import org.seasar.ymir.extension.creator.impl.MetaAnnotationDescImpl;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescImpl
extends AbstractAnnotatedDesc
implements ClassDesc {
    private DescPool pool_;
    private String name_;
    private ClassType type_;
    private String superclassName_;
    private boolean abstract_;
    private TypeDesc[] interfaceTypeDescs_ = new TypeDesc[0];
    private Map<String, PropertyDesc> propertyDescMap_ = new LinkedHashMap<String, PropertyDesc>();
    private Map<MethodDescKey, MethodDesc> methodDescMap_ = new LinkedHashMap<MethodDescKey, MethodDesc>();
    private Map<String, Object> parameter_;
    private String bornOf_;
    private Desc<?> parent_;

    public ClassDescImpl(DescPool pool, String name) {
        this.pool_ = pool;
        this.name_ = name;
        this.type_ = ClassType.typeOfClass(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name_ == null ? 0 : this.name_.hashCode());
        result = 31 * result + (this.pool_ == null ? 0 : this.pool_.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassDescImpl other = (ClassDescImpl)obj;
        if (this.name_ == null ? other.name_ != null : !this.name_.equals(other.name_)) {
            return false;
        }
        return !(this.pool_ == null ? other.pool_ != null : !this.pool_.equals(other.pool_));
    }

    public String toString() {
        return this.name_;
    }

    @Override
    public DescPool getDescPool() {
        return this.pool_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public ClassType getType() {
        return this.type_;
    }

    @Override
    public boolean isTypeOf(ClassType type) {
        return type == this.getType();
    }

    @Override
    public TypeDesc[] getInterfaceTypeDescs() {
        return this.interfaceTypeDescs_;
    }

    @Override
    public void setInterfaceTypeDescs(TypeDesc[] interfaceTypeDescs) {
        for (TypeDesc interfaceTypeDesc : this.interfaceTypeDescs_ = interfaceTypeDescs) {
            interfaceTypeDesc.setParent(this);
        }
    }

    @Override
    public PropertyDesc addProperty(String name, int mode) {
        PropertyDesc propertyDesc = this.getPropertyDesc(name);
        if (propertyDesc == null) {
            propertyDesc = this.pool_.newPropertyDesc(name);
            propertyDesc.setParent(this);
            this.propertyDescMap_.put(name, propertyDesc);
        }
        propertyDesc.addMode(mode);
        return propertyDesc;
    }

    @Override
    public PropertyDesc getPropertyDesc(String name) {
        return this.propertyDescMap_.get(name);
    }

    @Override
    public void setPropertyDesc(PropertyDesc propertyDesc) {
        if (propertyDesc.getDescPool() != this.pool_) {
            throw new IllegalArgumentException("Can't set PropertyDesc born from another DescPool");
        }
        propertyDesc.setParent(this);
        this.propertyDescMap_.put(propertyDesc.getName(), propertyDesc);
    }

    @Override
    public void removePropertyDesc(String name) {
        this.propertyDescMap_.remove(name);
    }

    @Override
    public PropertyDesc[] getPropertyDescs() {
        return this.propertyDescMap_.values().toArray(new PropertyDesc[0]);
    }

    @Override
    public PropertyDesc[] getPropertyDescsOrderByName() {
        PropertyDesc[] pds = this.getPropertyDescs();
        Arrays.sort(pds, new Comparator<PropertyDesc>(){

            @Override
            public int compare(PropertyDesc o1, PropertyDesc o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return pds;
    }

    @Override
    public MethodDesc getMethodDesc(MethodDesc methodDesc) {
        return this.methodDescMap_.get(new MethodDescKey(methodDesc));
    }

    @Override
    public void setMethodDesc(MethodDesc methodDesc) {
        methodDesc.setParent(this);
        this.methodDescMap_.put(new MethodDescKey(methodDesc), methodDesc);
    }

    @Override
    public MethodDesc[] getMethodDescs() {
        return this.methodDescMap_.values().toArray(new MethodDesc[0]);
    }

    @Override
    public MethodDesc[] getMethodDescsOrderByName() {
        MethodDesc[] mds = this.getMethodDescs();
        Arrays.sort(mds, new Comparator<MethodDesc>(){

            @Override
            public int compare(MethodDesc o1, MethodDesc o2) {
                return new MethodDescKey(o1).compareTo(new MethodDescKey(o2));
            }
        });
        return mds;
    }

    @Override
    public void removeMethodDesc(MethodDesc methodDesc) {
        this.methodDescMap_.remove(new MethodDescKey(methodDesc));
    }

    @Override
    public String getSuperclassName() {
        return this.superclassName_;
    }

    @Override
    public void setSuperclassName(String superclassName) {
        this.superclassName_ = superclassName;
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    @Override
    public void setAbstract(boolean isAbstract) {
        this.abstract_ = isAbstract;
    }

    @Override
    public void merge(ClassDesc classDesc, boolean force) {
        if (classDesc == null) {
            return;
        }
        if (classDesc.getSuperclassName() != null && !classDesc.getSuperclassName().equals(Object.class.getName()) && (force || this.superclassName_ == null)) {
            this.setSuperclassName(classDesc.getSuperclassName());
        }
        if (force) {
            this.setAbstract(classDesc.isAbstract());
        }
        LinkedHashSet<TypeDesc> interfaceTypeDescSet = new LinkedHashSet<TypeDesc>();
        interfaceTypeDescSet.addAll(Arrays.asList(this.interfaceTypeDescs_));
        interfaceTypeDescSet.addAll(Arrays.asList(classDesc.getInterfaceTypeDescs()));
        this.setInterfaceTypeDescs(interfaceTypeDescSet.toArray(new TypeDesc[0]));
        for (PropertyDesc propertyDesc : classDesc.getPropertyDescs()) {
            PropertyDesc pd = this.getPropertyDesc(propertyDesc.getName());
            if (pd == null) {
                this.setPropertyDesc(propertyDesc.transcriptTo(this.pool_.newPropertyDesc(propertyDesc.getName())));
                continue;
            }
            DescUtils.merge(pd, propertyDesc, force);
        }
        for (AnnotatedDesc<PropertyDesc> annotatedDesc : classDesc.getMethodDescs()) {
            MethodDesc md = this.getMethodDesc((MethodDesc)annotatedDesc);
            if (md == null) {
                this.setMethodDesc((MethodDesc)((Object)annotatedDesc.transcriptTo((PropertyDesc)((Object)this.pool_.newMethodDesc(annotatedDesc.getName())))));
                continue;
            }
            DescUtils.merge(md, annotatedDesc, force);
        }
        this.setAnnotationDescs(DescUtils.merge(this.getAnnotationDescs(), classDesc.getAnnotationDescs(), force));
    }

    @Override
    public void applyBornOfToAllMembers() {
        String bornOf = this.getBornOf();
        if (bornOf == null) {
            return;
        }
        for (PropertyDesc propertyDesc : this.getPropertyDescs()) {
            this.applyBornOfTo(propertyDesc, bornOf);
        }
        for (AnnotatedDesc<PropertyDesc> annotatedDesc : this.getMethodDescs()) {
            this.applyBornOfTo((MethodDesc)annotatedDesc, bornOf);
        }
    }

    void applyBornOfTo(MethodDesc methodDesc, String bornOf) {
        methodDesc.setAnnotationDesc(new MetaAnnotationDescImpl("bornOf", new String[]{bornOf}));
    }

    void applyBornOfTo(PropertyDesc propertyDesc, String bornOf) {
        propertyDesc.setAnnotationDescOnGetter(new MetaAnnotationDescImpl("bornOf", new String[]{bornOf}));
        propertyDesc.setAnnotationDescOnSetter(new MetaAnnotationDescImpl("bornOf", new String[]{bornOf}));
        propertyDesc.setAnnotationDesc(new MetaAnnotationDescImpl("bornOf", new String[]{bornOf}));
    }

    @Override
    public void removeBornOfFromAllMembers(String bornOf) {
        if (bornOf == null) {
            return;
        }
        for (PropertyDesc propertyDesc : this.getPropertyDescs()) {
            this.removeBornOfFrom(propertyDesc, bornOf);
        }
        for (AnnotatedDesc<PropertyDesc> annotatedDesc : this.getMethodDescs()) {
            this.removeBornOfFrom((MethodDesc)annotatedDesc, bornOf);
        }
    }

    void removeBornOfFrom(MethodDesc methodDesc, String bornOf) {
        String[] values = methodDesc.getMetaValue("bornOf");
        if (values != null) {
            methodDesc.removeMetaAnnotationDesc("bornOf");
            ArrayList<String> valueList = new ArrayList<String>();
            for (String value : values) {
                if (value.equals(bornOf)) continue;
                valueList.add(value);
            }
            values = valueList.toArray(new String[0]);
            if (values.length == 0) {
                this.removeMethodDesc(methodDesc);
            } else {
                methodDesc.setAnnotationDesc(new MetaAnnotationDescImpl("bornOf", values));
            }
        }
    }

    void removeBornOfFrom(PropertyDesc propertyDesc, String bornOf) {
        ArrayList<String> valueList;
        int mode = propertyDesc.getMode();
        boolean mayFieldBeRemoved = false;
        String[] values = propertyDesc.getMetaValueOnGetter("bornOf");
        if (values != null) {
            propertyDesc.removeMetaAnnotationDescOnGetter("bornOf");
            valueList = new ArrayList<String>();
            for (String value : values) {
                if (value.equals(bornOf)) continue;
                valueList.add(value);
            }
            values = valueList.toArray(new String[0]);
            if (values.length == 0) {
                propertyDesc.setMode(mode &= 0xFFFFFFFE);
            } else {
                propertyDesc.setAnnotationDescOnGetter(new MetaAnnotationDescImpl("bornOf", values));
            }
        }
        if ((values = propertyDesc.getMetaValueOnSetter("bornOf")) != null) {
            propertyDesc.removeMetaAnnotationDescOnSetter("bornOf");
            valueList = new ArrayList();
            for (String value : values) {
                if (value.equals(bornOf)) continue;
                valueList.add(value);
            }
            values = valueList.toArray(new String[0]);
            if (values.length == 0) {
                propertyDesc.setMode(mode &= 0xFFFFFFFD);
            } else {
                propertyDesc.setAnnotationDescOnSetter(new MetaAnnotationDescImpl("bornOf", values));
            }
        }
        if ((values = propertyDesc.getMetaValue("bornOf")) != null) {
            propertyDesc.removeMetaAnnotationDesc("bornOf");
            valueList = new ArrayList();
            for (String value : values) {
                if (value.equals(bornOf)) continue;
                valueList.add(value);
            }
            values = valueList.toArray(new String[0]);
            if (values.length == 0) {
                mayFieldBeRemoved = true;
            } else {
                propertyDesc.setAnnotationDesc(new MetaAnnotationDescImpl("bornOf", values));
            }
        }
        if (mode == 0 && mayFieldBeRemoved) {
            this.removePropertyDesc(propertyDesc.getName());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.propertyDescMap_.isEmpty() && this.methodDescMap_.isEmpty();
    }

    @Override
    public void clear() {
        super.clear();
        this.parameter_ = null;
        this.interfaceTypeDescs_ = new TypeDesc[0];
        this.propertyDescMap_.clear();
        this.methodDescMap_.clear();
    }

    @Override
    public void setPropertyDescs(PropertyDesc[] propertyDescs) {
        this.propertyDescMap_.clear();
        for (PropertyDesc propertyDesc : propertyDescs) {
            this.setPropertyDesc(propertyDesc);
        }
    }

    @Override
    public void setMethodDescs(MethodDesc[] methodDescs) {
        this.methodDescMap_.clear();
        for (MethodDesc methodDesc : methodDescs) {
            this.setMethodDesc(methodDesc);
        }
    }

    @Override
    public String getPathOfClass() {
        return YmirContext.getYmir().getPathOfPageClass(this.getName());
    }

    @Override
    public String getShortName() {
        return ClassUtils.getShortName((String)this.getName());
    }

    @Override
    public String getNameBase() {
        return this.getNameBase(this.getName());
    }

    String getNameBase(String name) {
        name = ClassUtils.getShortName((String)name);
        return name.substring(0, name.length() - this.getType().getSuffix().length());
    }

    @Override
    public String getPackageName() {
        return this.getPackageName(this.getName());
    }

    String getPackageName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return "";
        }
        return name.substring(0, dot);
    }

    @Override
    public String getInstanceName() {
        return this.getInstanceName(this.getName());
    }

    String getInstanceName(String name) {
        String instanceName = this.uncapFirst(ClassUtils.getShorterName((String)name));
        if (instanceName.equals(name)) {
            instanceName = instanceName + "Value";
        }
        return instanceName;
    }

    String uncapFirst(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    @Override
    public Map<String, Object> getOptionalSourceGeneratorParameter() {
        return this.parameter_;
    }

    @Override
    public void setOptionalSourceGeneratorParameter(Map<String, Object> parameter) {
        this.parameter_ = parameter;
    }

    @Override
    public String getBornOf() {
        return this.bornOf_;
    }

    @Override
    public void setBornOf(String bornOf) {
        this.bornOf_ = bornOf;
    }

    @Override
    public ClassDesc transcriptTo(ClassDesc desc) {
        DescPool pool = desc.getDescPool();
        super.transcriptTo(desc);
        desc.setSuperclassName(this.superclassName_);
        desc.setAbstract(this.abstract_);
        ArrayList<TypeDesc> list = new ArrayList<TypeDesc>();
        for (TypeDesc interfaceTypeDesc : this.interfaceTypeDescs_) {
            list.add(interfaceTypeDesc.transcriptTo(pool.newTypeDesc(interfaceTypeDesc.getName())));
        }
        desc.setInterfaceTypeDescs(list.toArray(new TypeDesc[0]));
        for (PropertyDesc propertyDesc : this.propertyDescMap_.values()) {
            desc.setPropertyDesc(propertyDesc.transcriptTo(pool.newPropertyDesc(propertyDesc.getName())));
        }
        for (MethodDesc methodDesc : this.methodDescMap_.values()) {
            desc.setMethodDesc(methodDesc.transcriptTo(pool.newMethodDesc(methodDesc.getName())));
        }
        if (this.parameter_ != null) {
            desc.setOptionalSourceGeneratorParameter(new HashMap<String, Object>(this.parameter_));
        }
        desc.setBornOf(this.bornOf_);
        return desc;
    }

    @Override
    public <D extends Desc<?>> D getParent() {
        return (D)this.parent_;
    }

    @Override
    public void setParent(Desc<?> parent) {
        this.parent_ = parent;
    }
}

