/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassType;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.zpt.AnalyzerContext;
import org.seasar.ymir.extension.zpt.AnalyzerUtils;
import org.seasar.ymir.zpt.annotation.IgnoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@IgnoreException(value={NoSuchMethodException.class})
public class DescWrapper {
    private AnalyzerContext analyzerContext_;
    private ClassDesc valueClassDesc_;
    private DescWrapper parent_;
    private PropertyDesc propertyDesc_;

    public DescWrapper(AnalyzerContext analyzerContext, ClassDesc valueClassDesc) {
        this.analyzerContext_ = analyzerContext;
        this.valueClassDesc_ = valueClassDesc;
    }

    private DescWrapper(DescWrapper parent, PropertyDesc propertyDesc) {
        this.analyzerContext_ = parent.getAnalizerContext();
        this.parent_ = parent;
        this.propertyDesc_ = propertyDesc;
    }

    public String toString() {
        return "0";
    }

    public Object get(String name) {
        int mode;
        if (!AnalyzerUtils.isValidVariableName(name)) {
            return null;
        }
        ClassDesc cd = this.getValueClassDescToModifyProeprty(name);
        PropertyDesc pd = cd.getPropertyDesc(name);
        if (pd == null && this.hasPresentSuperclassReadableProperty(cd, name)) {
            return null;
        }
        int n = mode = cd.isTypeOf(ClassType.DTO) ? 3 : 1;
        if (pd == null) {
            if (this.analyzerContext_.isOuter(cd) && !this.analyzerContext_.hasProperty(cd.getName(), name)) {
                return null;
            }
            pd = this.analyzerContext_.addProperty(cd, name, mode);
        } else {
            pd.addMode(mode);
        }
        pd.incrementReferCount();
        DescWrapper returned = new DescWrapper(this, pd);
        if (pd.getTypeDesc().isCollection()) {
            return new DescWrapper[]{returned};
        }
        return returned;
    }

    boolean hasPresentSuperclassReadableProperty(ClassDesc classDesc, String name) {
        Class<?> superclass = this.findPresentSuperclass(classDesc);
        if (superclass != null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(superclass);
                for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                    if (!name.equals(propertyDescriptor.getName()) || propertyDescriptor.getReadMethod() == null) continue;
                    return true;
                }
            }
            catch (IntrospectionException ignore) {
                // empty catch block
            }
        }
        return false;
    }

    Class<?> findPresentSuperclass(ClassDesc classDesc) {
        ClassDesc cd = classDesc;
        String superclassName = null;
        Class<?> superclass = null;
        while ((superclassName = cd.getSuperclassName()) != null && (superclass = this.analyzerContext_.getSourceCreator().getClass(superclassName)) == null) {
            cd = this.analyzerContext_.getSourceCreator().newClassDesc(null, superclassName, null);
        }
        return superclass;
    }

    public AnalyzerContext getAnalizerContext() {
        return this.analyzerContext_;
    }

    public PropertyDesc getPropertyDesc() {
        return this.propertyDesc_;
    }

    public ClassDesc getValueClassDescToModifyProeprty(String propertyName) {
        if (this.valueClassDesc_ != null) {
            return this.valueClassDesc_;
        }
        this.analyzerContext_.replaceTypeToGeneratedClassIfNeedToAddProperty(this.propertyDesc_, propertyName, this.parent_.getValueClassDesc());
        return this.propertyDesc_.getTypeDesc().getComponentClassDesc();
    }

    public ClassDesc getValueClassDesc() {
        if (this.valueClassDesc_ != null) {
            return this.valueClassDesc_;
        }
        return this.propertyDesc_.getTypeDesc().getComponentClassDesc();
    }

    public DescWrapper getParent() {
        return this.parent_;
    }

    public void setVariableName(String variableName, boolean asCollection, String collectionClassName, int probability) {
        if (this.propertyDesc_ != null && !this.propertyDesc_.getTypeDesc().isExplicit()) {
            this.propertyDesc_ = this.analyzerContext_.addProperty(this.parent_.getValueClassDescToModifyProeprty(this.propertyDesc_.getName()), this.propertyDesc_.getName(), this.propertyDesc_.getMode(), variableName, asCollection, collectionClassName, probability);
        }
    }
}

