/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.skirnir.freyja.EvaluationRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.cms.pluggable.ClassTraverser;
import org.seasar.cms.pluggable.hotdeploy.LocalHotdeployS2Container;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.kvasir.util.StringUtils;
import org.seasar.kvasir.util.collection.MapProperties;
import org.seasar.kvasir.util.io.IOUtils;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionNotFoundRuntimeException;
import org.seasar.ymir.Application;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.MatchedPathMapping;
import org.seasar.ymir.PathMapping;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.ResponseCreator;
import org.seasar.ymir.ResponseType;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.constraint.PermissionDeniedException;
import org.seasar.ymir.conversation.annotation.Begin;
import org.seasar.ymir.extension.creator.AnnotationDesc;
import org.seasar.ymir.extension.creator.ClassCreationHintBag;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassDescBag;
import org.seasar.ymir.extension.creator.ClassDescModifier;
import org.seasar.ymir.extension.creator.ClassDescSet;
import org.seasar.ymir.extension.creator.ClassHint;
import org.seasar.ymir.extension.creator.ClassType;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.DescValidator;
import org.seasar.ymir.extension.creator.EntityMetaData;
import org.seasar.ymir.extension.creator.InvalidClassDescException;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.MethodDescKey;
import org.seasar.ymir.extension.creator.ParameterDesc;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.SourceCreatorSetting;
import org.seasar.ymir.extension.creator.SourceGenerator;
import org.seasar.ymir.extension.creator.Template;
import org.seasar.ymir.extension.creator.TemplateAnalyzer;
import org.seasar.ymir.extension.creator.TemplateProvider;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.action.ActionSelector;
import org.seasar.ymir.extension.creator.action.Condition;
import org.seasar.ymir.extension.creator.action.State;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.extension.creator.action.UpdateByExceptionAction;
import org.seasar.ymir.extension.creator.action.impl.CreateActionAction;
import org.seasar.ymir.extension.creator.action.impl.CreateClassAction;
import org.seasar.ymir.extension.creator.action.impl.CreateClassAndTemplateAction;
import org.seasar.ymir.extension.creator.action.impl.CreateConfigurationAction;
import org.seasar.ymir.extension.creator.action.impl.CreateMessageAction;
import org.seasar.ymir.extension.creator.action.impl.CreateMessagesAction;
import org.seasar.ymir.extension.creator.action.impl.CreateTemplateAction;
import org.seasar.ymir.extension.creator.action.impl.DoEditTemplateAction;
import org.seasar.ymir.extension.creator.action.impl.DoUpdateTemplateAction;
import org.seasar.ymir.extension.creator.action.impl.ResourceAction;
import org.seasar.ymir.extension.creator.action.impl.SystemConsoleAction;
import org.seasar.ymir.extension.creator.action.impl.UpdateClassesAction;
import org.seasar.ymir.extension.creator.impl.AnnotationDescImpl;
import org.seasar.ymir.extension.creator.impl.BodyDescImpl;
import org.seasar.ymir.extension.creator.impl.ClassDescImpl;
import org.seasar.ymir.extension.creator.impl.DefaultTemplateProvider;
import org.seasar.ymir.extension.creator.impl.LazyPathMetaData;
import org.seasar.ymir.extension.creator.impl.MethodDescImpl;
import org.seasar.ymir.extension.creator.impl.ParameterDescImpl;
import org.seasar.ymir.extension.creator.impl.PropertyDescImpl;
import org.seasar.ymir.extension.creator.impl.ThrowsDescImpl;
import org.seasar.ymir.extension.creator.impl.TypeDescImpl;
import org.seasar.ymir.extension.creator.mapping.ActionSelectorSeed;
import org.seasar.ymir.extension.creator.mapping.ExtraPathMapping;
import org.seasar.ymir.extension.creator.mapping.PathMappingExtraData;
import org.seasar.ymir.extension.creator.mapping.impl.ActionSelectorSeedImpl;
import org.seasar.ymir.extension.creator.mapping.impl.ExtraPathMappingImpl;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.extension.creator.util.MetaUtils;
import org.seasar.ymir.extension.creator.util.PersistentProperties;
import org.seasar.ymir.extension.creator.util.SourceCreatorUtils;
import org.seasar.ymir.impl.YmirImpl;
import org.seasar.ymir.message.MessageNotFoundRuntimeException;
import org.seasar.ymir.message.MessagesNotFoundRuntimeException;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.scope.annotation.Inject;
import org.seasar.ymir.util.ClassUtils;
import org.seasar.ymir.util.HTMLUtils;
import org.seasar.ymir.util.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCreatorImpl
implements SourceCreator {
    private static final String PROPERTY_ID = "id";
    private static final String ID_ANNOTATIONNAME = "org.seasar.dao.annotation.tiger.Id";
    private static final String ID_BODY = "(org.seasar.dao.annotation.tiger.IdType.IDENTITY)";
    private static final Class<?> ID_TYPE = Integer.TYPE;
    private static final String PACKAGEPREFIX_JAVA_LANG = "java.lang.";
    private static final String PACKAGEPREFIX_JAVA_UTIL = "java.util.";
    private static final String PACKAGEPREFIX_FREYJA_RENDER_HTML = "net.skirnir.freyja.render.html.";
    private static final String RESOURCE_PREAMBLE_JAVA = "org/seasar/ymir/extension/Preamble.java.txt";
    private static final String PREFIX_ACTION = "A";
    private YmirImpl ymir_;
    private NamingConvention namingConvention_;
    private TemplateAnalyzer analyzer_;
    private ClassDescModifier[] classDescModifiers_ = new ClassDescModifier[0];
    private String sourceEncoding_ = "UTF-8";
    private SourceGenerator sourceGenerator_;
    private ResponseCreator responseCreator_;
    public Properties sourceCreatorProperties_;
    private ApplicationManager applicationManager_;
    private TemplateProvider templateProvider_ = new DefaultTemplateProvider(this);
    private SourceCreatorSetting setting_ = new SourceCreatorSetting(this);
    private Map<Class<? extends PathMapping>, PathMappingExtraData<?>> pathMappingExtraDataMap_ = new HashMap();
    private ActionSelector<UpdateAction> actionSelector_ = new ActionSelector<CreateTemplateAction>().register(new Condition(State.ANY, State.ANY, State.FALSE, HttpMethod.GET), new CreateTemplateAction(this)).register(new Condition(State.ANY, State.ANY, State.TRUE, HttpMethod.GET), (CreateTemplateAction)((Object)new UpdateClassesAction(this))).register(new Condition(State.ANY, State.FALSE, State.FALSE, HttpMethod.POST), (CreateTemplateAction)((Object)new CreateClassAndTemplateAction(this))).register(new Condition(State.ANY, State.ANY, State.TRUE, HttpMethod.POST), (CreateTemplateAction)((Object)new UpdateClassesAction(this))).register(new Condition(State.TRUE, State.TRUE, State.FALSE, HttpMethod.POST), new CreateTemplateAction(this)).register("createClass", (CreateTemplateAction)((Object)new CreateClassAction(this))).register("createTemplate", new CreateTemplateAction(this)).register("createClassAndTemplate", (CreateTemplateAction)((Object)new CreateClassAndTemplateAction(this))).register("updateClasses", (CreateTemplateAction)((Object)new UpdateClassesAction(this))).register("createConfiguration", (CreateTemplateAction)((Object)new CreateConfigurationAction(this))).register("systemConsole", (CreateTemplateAction)((Object)new SystemConsoleAction(this))).register("resource", (CreateTemplateAction)((Object)new ResourceAction(this))).register("editTemplate.do", (CreateTemplateAction)((Object)new DoEditTemplateAction(this))).register("updateTemplate.do", (CreateTemplateAction)((Object)new DoUpdateTemplateAction(this)));
    private ActionSelector<UpdateByExceptionAction> byExceptionActionSelector_ = new ActionSelector<CreateMessagesAction>().register(MessagesNotFoundRuntimeException.class, new CreateMessagesAction(this)).register("createMessages", new CreateMessagesAction(this)).register(MessageNotFoundRuntimeException.class, (CreateMessagesAction)((Object)new CreateMessageAction(this))).register("createMessage", (CreateMessagesAction)((Object)new CreateMessageAction(this))).register(ActionNotFoundRuntimeException.class, (CreateMessagesAction)((Object)new CreateActionAction(this))).register("createAction", (CreateMessagesAction)((Object)new CreateActionAction(this)));
    private boolean initialized_;
    private Log log_ = LogFactory.getLog(SourceCreatorImpl.class);

    @Binding(bindingType=BindingType.MUST)
    public void setTemplateAnalyzer(TemplateAnalyzer analyzer) {
        this.analyzer_ = analyzer;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention_ = namingConvention;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setYmir(Ymir ymir) {
        if (!(ymir instanceof YmirImpl)) {
            throw new ComponentNotFoundRuntimeException((Object)"YmirImpl");
        }
        this.ymir_ = (YmirImpl)ymir;
    }

    @Binding(value="@org.seasar.ymir.util.ContainerUtils@findAllComponents(container, @org.seasar.ymir.extension.creator.ClassDescModifier@class)", bindingType=BindingType.MUST)
    public void setClassDescModifiers(ClassDescModifier[] classDescModifiers) {
        this.classDescModifiers_ = classDescModifiers;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding_ = sourceEncoding;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setSourceGenerator(SourceGenerator sourceGenerator) {
        this.sourceGenerator_ = sourceGenerator;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setResponseCreator(ResponseCreator responseCreator) {
        this.responseCreator_ = responseCreator;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(value="@org.seasar.ymir.util.ContainerUtils@findAllComponents(container, @org.seasar.ymir.extension.creator.mapping.PathMappingExtraData@class)", bindingType=BindingType.MUST)
    public void setPathMappingExtraDatas(PathMappingExtraData<?>[] pathMappingExtraDatas) {
        for (int i = 0; i < pathMappingExtraDatas.length; ++i) {
            this.pathMappingExtraDataMap_.put(pathMappingExtraDatas[i].getPathMappingClass(), pathMappingExtraDatas[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response update(Request request, Response response) {
        Response newResponse;
        UpdateAction action;
        SourceCreatorImpl sourceCreatorImpl = this;
        synchronized (sourceCreatorImpl) {
            if (!this.initialized_) {
                this.setProjectRootIfNotDetecetd(this.getApplication());
                this.initialized_ = true;
            }
        }
        if (!this.shouldUpdate()) {
            return response;
        }
        LazyPathMetaData pathMetaData = this.createLazyPathMetaData(request, response);
        String path = pathMetaData.getPath();
        String forwardPath = pathMetaData.getForwardPath();
        HttpMethod method = pathMetaData.getMethod();
        if (request.getParameter("__ymir__task") == null && !this.shouldUpdate(forwardPath)) {
            return response;
        }
        Object condition = null;
        if (request.getParameter("__ymir__task") != null) {
            condition = request.getParameter("__ymir__task");
        } else if (path.startsWith("/__ymir__/")) {
            int slash = path.indexOf(47, "/__ymir__/".length());
            condition = slash >= 0 ? path.substring("/__ymir__/".length(), slash) : path.substring("/__ymir__/".length());
        } else {
            if (!request.getCurrentDispatch().isMatched()) {
                return response;
            }
            if (response.getType() != ResponseType.PASSTHROUGH && response.getType() != ResponseType.FORWARD) {
                return response;
            }
        }
        if (condition == null) {
            if (!this.isAlreadyConfigured(this.getApplication())) {
                condition = "createConfiguration";
            } else {
                String className = pathMetaData.getClassName();
                File sourceFile = pathMetaData.getSourceFile();
                Template template = pathMetaData.getTemplate();
                if ("".equals(forwardPath)) {
                    if (className == null || sourceFile.exists()) {
                        return response;
                    }
                    condition = "createClass";
                } else {
                    condition = new Condition(State.valueOf(className != null), State.valueOf(sourceFile.exists()), State.valueOf(template.exists()), method);
                }
            }
        }
        if ((action = this.actionSelector_.getAction(condition)) != null && (newResponse = action.act(request, pathMetaData)) != null) {
            response = newResponse;
        }
        return response;
    }

    void setProjectRootIfNotDetecetd(Application application) {
        if (application.getProjectRoot() != null && new File(application.getProjectRoot()).exists()) {
            return;
        }
        String projectRoot = SourceCreatorUtils.findProjectRootDirectory(application);
        application.setProjectRoot(projectRoot);
        this.log_.info((Object)("Project root has been detected and set automatically: " + projectRoot));
    }

    LazyPathMetaData createLazyPathMetaData(Request request, Response response) {
        String path = request.getCurrentDispatch().getPath();
        String forwardPath = null;
        if (response != null) {
            if (response.getType() == ResponseType.FORWARD) {
                forwardPath = response.getPath();
            } else if (response.getType() == ResponseType.PASSTHROUGH) {
                forwardPath = path;
            }
        }
        return new LazyPathMetaData(this, path, this.getOriginalMethod(request), forwardPath);
    }

    public Response updateByException(Request request, Throwable t) {
        int slash;
        if (!this.shouldUpdate()) {
            return null;
        }
        if (t instanceof EvaluationRuntimeException && t.getCause() != null) {
            t = t.getCause();
        }
        String path = ServletUtils.normalizePath((String)request.getCurrentDispatch().getPath());
        Object condition = null;
        condition = request.getParameter("__ymir__task") != null ? request.getParameter("__ymir__task") : (path.startsWith("/__ymir__/") ? ((slash = path.indexOf(47, "/__ymir__/".length())) >= 0 ? path.substring("/__ymir__/".length(), slash) : path.substring("/__ymir__/".length())) : t.getClass());
        UpdateByExceptionAction action = this.byExceptionActionSelector_.getAction(condition);
        if (action == null) {
            return null;
        }
        return action.act(request, this.createLazyPathMetaData(request, null), t);
    }

    HttpMethod getOriginalMethod(Request request) {
        String originalMethod = request.getParameter("__ymir__method");
        if (originalMethod != null) {
            return HttpMethod.enumOf((String)originalMethod);
        }
        return request.getMethod();
    }

    public boolean shouldUpdate() {
        return this.setting_.isSourceCreatorEnabled();
    }

    @Override
    public boolean shouldUpdate(String path) {
        return path == null || this.setting_.isSourceCreatorEnabledWith(path);
    }

    boolean isAlreadyConfigured(Application application) {
        String originalProjectRoot = SourceCreatorUtils.getOriginalProjectRoot(application);
        String projectRoot = application.getProjectRoot();
        return projectRoot != null && (originalProjectRoot == null || originalProjectRoot.equals(projectRoot)) && application.getFirstRootPackageName() != null;
    }

    @Override
    public ClassDescBag gatherClassDescs(PathMetaData[] pathMetaDatas) {
        return this.gatherClassDescs(pathMetaDatas, null, null);
    }

    @Override
    public ClassDescBag gatherClassDescs(PathMetaData[] pathMetaDatas, ClassCreationHintBag hintBag, String[] ignoreVariables) {
        DescPool pool = DescPool.newInstance(this, hintBag);
        for (int i = 0; i < pathMetaDatas.length; ++i) {
            this.gatherClassDescs(pool, pathMetaDatas[i], ignoreVariables);
        }
        ClassDesc[] classDescs = this.addRelativeClassDescs(pool.getGeneratedClassDescs().toArray(new ClassDesc[0]), hintBag);
        return this.classifyClassDescs(classDescs);
    }

    @Override
    public void updateClasses(ClassDescBag classDescBag) {
        if (this.setting_.isConverterCreationFeatureEnabled()) {
            for (ClassDesc dtoCd : classDescBag.getClassDescs(ClassType.DTO)) {
                String[] pairTypeNames = this.getPairTypeNames(dtoCd);
                if (pairTypeNames == null) continue;
                ClassDesc converterCd = this.createConverterClassDesc(dtoCd, pairTypeNames);
                if (this.getClass(converterCd.getName()) == null) {
                    classDescBag.addAsCreated(converterCd);
                    continue;
                }
                classDescBag.addAsUpdated(converterCd);
            }
        }
        ClassDescSet classDescSet = classDescBag.getClassDescSet();
        ClassDesc[] pageClassDescs = classDescBag.getClassDescs(ClassType.PAGE);
        for (int i = 0; i < pageClassDescs.length; ++i) {
            ClassDesc classDesc;
            Class<?> superclass;
            this.addConverterSetterToPageClassDesc(pageClassDescs[i], classDescSet);
            String superclassName = pageClassDescs[i].getSuperclassName();
            if (superclassName == null || (superclass = this.getClass(superclassName)) != null || this.isOuter(classDesc = this.newClassDesc(pageClassDescs[i].getDescPool(), superclassName, null))) continue;
            this.writeSourceFile("PageSuperclass.java", classDesc, false);
            classDescBag.addAsCreated(classDesc, true);
        }
        this.writeSourceFiles(classDescBag);
    }

    void addConverterSetterToPageClassDesc(ClassDesc pageClassDesc, ClassDescSet classDescSet) {
        this.addConverterSetterToPageClassDesc(pageClassDesc, pageClassDesc, classDescSet);
    }

    void addConverterSetterToPageClassDesc(ClassDesc pageClassDesc, ClassDesc dtoClassDesc, ClassDescSet classDescSet) {
        for (PropertyDesc pd : dtoClassDesc.getPropertyDescs()) {
            TypeDesc td = pd.getTypeDesc();
            ClassDesc dtoCd = td.getComponentClassDesc();
            if (!DescValidator.validate(td, classDescSet).isValid() || dtoCd.getType() != ClassType.DTO) continue;
            EntityMetaData metaData = new EntityMetaData(pageClassDesc.getDescPool(), dtoCd.getName());
            this.addComponentSetterToPageIfValid(pageClassDesc, pageClassDesc.getDescPool().newTypeDesc(metaData.newConverterClassDesc()), classDescSet);
            this.addConverterSetterToPageClassDesc(pageClassDesc, dtoCd, classDescSet);
        }
    }

    boolean isOuter(ClassDesc classDesc) {
        return !classDesc.getPackageName().startsWith(this.getFirstRootPackageName() + ".");
    }

    protected ClassDesc createConverterClassDesc(ClassDesc dtoCd, String[] pairTypeNames) {
        DescPool pool = dtoCd.getDescPool();
        ClassDesc converterCd = new EntityMetaData(pool, dtoCd.getName()).newConverterClassDesc();
        converterCd.setBornOf(dtoCd.getBornOf());
        HashMap<String, Object> param = new HashMap<String, Object>();
        ClassDesc clonedDtoCd = dtoCd.transcriptTo(DescPool.newInstance(this, null).getClassDesc(dtoCd.getName()));
        this.mergeWithExistentClass(clonedDtoCd);
        param.put("targetClassDesc", clonedDtoCd);
        ArrayList<TypeDesc> pairTdList = new ArrayList<TypeDesc>();
        for (int i = 0; i < pairTypeNames.length; ++i) {
            Class<?> pairClass = this.getClass(DescUtils.getNonGenericClassName(pairTypeNames[i]));
            if (pairClass == null || pairClass == Object.class) continue;
            pool.registerClassDesc(this.newClassDesc(pool, pairClass, false));
            pairTdList.add(pool.newTypeDesc(pairTypeNames[i]));
        }
        param.put("pairTypeDescs", pairTdList.toArray(new TypeDesc[0]));
        converterCd.setOptionalSourceGeneratorParameter(param);
        return converterCd;
    }

    public void gatherClassDescs(DescPool pool, PathMetaData pathMetaData, String[] ignoreVariables) {
        MethodDescImpl methodDesc;
        MethodDesc actionMethodDesc;
        String path = pathMetaData.getPath();
        HttpMethod method = pathMetaData.getMethod();
        String pageClassName = pathMetaData.getClassName();
        this.analyzer_.analyze(this.getServletContext(), this.getHttpServletRequest(), this.getHttpServletResponse(), this.getRequest(), path, method, pathMetaData.getTemplate(), pageClassName, pool, ignoreVariables);
        for (int i = 0; i < this.classDescModifiers_.length; ++i) {
            this.classDescModifiers_[i].modify(pool, pathMetaData);
        }
        ClassDesc pageClassDesc = pool.getClassDesc(pageClassName);
        if (pageClassDesc.getMethodDesc(actionMethodDesc = this.newActionMethodDesc(pageClassDesc, path, method)) == null) {
            pageClassDesc.setMethodDesc(actionMethodDesc);
        }
        MethodDesc prerenderMethodDesc = this.getExtraPathMapping(path, method).newPrerenderActionMethodDesc(pageClassDesc, new ActionSelectorSeedImpl());
        pageClassDesc.setMethodDesc(prerenderMethodDesc);
        if (this.isValidationFailedMethodEnabled()) {
            methodDesc = new MethodDescImpl(pageClassDesc.getDescPool(), "_validationFailed");
            methodDesc.setParameterDescs(new ParameterDesc[]{new ParameterDescImpl(pageClassDesc.getDescPool(), (Type)((Object)Notes.class), "notes")});
            pageClassDesc.setMethodDesc(methodDesc);
        }
        if (this.isPermissionDeniedMethodEnabled()) {
            methodDesc = new MethodDescImpl(pageClassDesc.getDescPool(), "_permissionDenied");
            methodDesc.setParameterDescs(new ParameterDesc[]{new ParameterDescImpl(pageClassDesc.getDescPool(), (Type)((Object)PermissionDeniedException.class), "ex")});
            methodDesc.setThrowsDesc(new ThrowsDescImpl(PermissionDeniedException.class));
            methodDesc.setBodyDesc(new BodyDescImpl("_permissionDenied", new HashMap<String, Object>()));
            pageClassDesc.setMethodDesc(methodDesc);
        }
    }

    MethodDesc newActionMethodDesc(ClassDesc classDesc, String path, HttpMethod method) {
        Action action;
        Class<?> pageClass = this.getClass(classDesc.getName());
        if (pageClass != null && (action = this.ymir_.findMatchedPathMapping(path, method).getAction(SourceCreatorUtils.newPageComponent(pageClass), SourceCreatorUtils.newRequest(path, method, null))) != null) {
            MethodDescImpl methodDesc = new MethodDescImpl(classDesc.getDescPool(), action.getMethodInvoker().getMethod());
            this.setActionMethodDescBodyTo(methodDesc);
            methodDesc.setAttribute("action", Boolean.TRUE);
            return methodDesc;
        }
        return this.newActionMethodDesc(classDesc, path, method, new ActionSelectorSeedImpl());
    }

    @Begin
    Begin getBeginAnnotation() {
        try {
            return SourceCreatorImpl.class.getDeclaredMethod("getBeginAnnotation", new Class[0]).getAnnotation(Begin.class);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Logic error!", ex);
        }
    }

    ClassDescBag classifyClassDescs(ClassDesc[] classDescs) {
        ClassDescBag classDescBag = new ClassDescBag();
        for (int i = 0; i < classDescs.length; ++i) {
            if (this.getClass(classDescs[i].getName()) == null) {
                classDescBag.addAsCreated(classDescs[i]);
                continue;
            }
            classDescBag.addAsUpdated(classDescs[i]);
        }
        return classDescBag;
    }

    @Override
    public ClassDesc newClassDesc(DescPool pool, Class<?> clazz, boolean onlyDeclared) {
        if (clazz == null) {
            return null;
        }
        ClassDesc classDesc = this.newClassDesc(pool, clazz.getName(), null);
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            classDesc.setSuperclassName(clazz.getSuperclass().getName());
        }
        AnnotationDesc[] ads = DescUtils.newAnnotationDescs(clazz);
        for (int i = 0; i < ads.length; ++i) {
            classDesc.setAnnotationDesc(ads[i]);
        }
        for (PropertyDescriptor descriptor : this.getPropertyDescriptors(clazz, onlyDeclared)) {
            classDesc.setPropertyDesc(new PropertyDescImpl(pool, descriptor));
        }
        for (Method method : this.getMethods(clazz, onlyDeclared)) {
            MethodDescImpl md = new MethodDescImpl(pool, method);
            classDesc.setMethodDesc(md);
            String[] source = md.getMetaValue("source");
            if (source == null) continue;
            int idx = 0;
            md.setBodyDesc(new BodyDescImpl(source[idx++]));
            ParameterDesc[] parameterDescs = md.getParameterDescs();
            for (int i = 0; idx < source.length && i < parameterDescs.length; ++idx, ++i) {
                parameterDescs[i].setName(source[idx]);
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (int i = 0; i < fields.length; ++i) {
            String name;
            int modifiers;
            String propertyName = MetaUtils.getFirstValue(fields[i], "property");
            if (propertyName != null) {
                PropertyDesc pd = classDesc.getPropertyDesc(propertyName);
                if (pd == null) {
                    pd = classDesc.addProperty(propertyName, 0);
                }
                pd.setTypeDesc(fields[i].getGenericType());
                for (Annotation annotation : fields[i].getAnnotations()) {
                    pd.setAnnotationDesc(DescUtils.newAnnotationDesc(annotation));
                }
            }
            if (!Modifier.isPublic(modifiers = fields[i].getModifiers()) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || !(name = fields[i].getName()).startsWith(PREFIX_ACTION)) continue;
            for (Method actionMethod : ClassUtils.getMethods(fields[i].getDeclaringClass(), (String)name.substring(PREFIX_ACTION.length()))) {
                MethodDesc actionMd = classDesc.getMethodDesc(new MethodDescImpl(pool, actionMethod));
                if (actionMd == null) continue;
                actionMd.setAttribute("action", Boolean.TRUE);
            }
        }
        return classDesc;
    }

    private Method[] getMethods(Class<?> clazz, boolean onlyDeclared) {
        HashSet<Method> excludeMethodSet = new HashSet<Method>();
        for (PropertyDescriptor descriptor : this.getPropertyDescriptors(clazz, onlyDeclared)) {
            Method method = descriptor.getReadMethod();
            if (method != null) {
                excludeMethodSet.add(method);
            }
            if ((method = descriptor.getWriteMethod()) == null) continue;
            excludeMethodSet.add(method);
        }
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : ClassUtils.getMethods(clazz)) {
            if (onlyDeclared && method.getDeclaringClass() != clazz || method.getDeclaringClass() == Object.class || excludeMethodSet.contains(method)) continue;
            list.add(method);
        }
        Collections.sort(list, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                Type[] types2;
                int cmp = o1.getName().compareTo(o2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                Type[] types1 = o1.getGenericParameterTypes();
                cmp = types1.length - (types2 = o2.getGenericParameterTypes()).length;
                if (cmp != 0) {
                    return cmp;
                }
                for (int i = 0; i < types1.length; ++i) {
                    cmp = types1[i].toString().compareTo(types2[i].toString());
                    if (cmp == 0) continue;
                    return cmp;
                }
                return 0;
            }
        });
        return list.toArray(new Method[0]);
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz, boolean onlyDeclared) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex);
        }
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            if (readMethod != null && readMethod.getDeclaringClass() == Object.class || writeMethod != null && writeMethod.getDeclaringClass() == Object.class) continue;
            if (onlyDeclared) {
                if (readMethod != null && readMethod.getDeclaringClass() != clazz) {
                    readMethod = null;
                }
                if (writeMethod != null && writeMethod.getDeclaringClass() != clazz) {
                    writeMethod = null;
                }
            }
            if (readMethod == null && writeMethod == null) continue;
            try {
                list.add(new PropertyDescriptor(this.getPropertyName(descriptor), readMethod, writeMethod));
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException("Can't happen!", ex);
            }
        }
        Collections.sort(list, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return list.toArray(new PropertyDescriptor[0]);
    }

    private String getPropertyName(PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        if (this.findField(descriptor.getReadMethod(), name) == null && this.findField(descriptor.getWriteMethod(), name) == null && name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            String n = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            if (this.findField(descriptor.getReadMethod(), n) != null || this.findField(descriptor.getWriteMethod(), n) != null) {
                return n;
            }
        }
        return name;
    }

    @Override
    public Field findField(Method accessorMethod, String propertyName) {
        Field field = null;
        if (accessorMethod != null) {
            String formName = MetaUtils.getFirstValue(accessorMethod, "formProperty");
            if (formName != null) {
                Field formField = this.findField(formName, accessorMethod.getDeclaringClass());
                if (formField != null) {
                    field = this.findField(propertyName, formField.getType());
                }
            } else {
                field = this.findField(propertyName, accessorMethod.getDeclaringClass());
            }
        }
        return field;
    }

    private Field findField(String propertyName, Class<?> clazz) {
        Field field = null;
        if (clazz != null && (field = DescUtils.findField(this.setting_.getFieldName(propertyName), clazz)) == null) {
            field = DescUtils.findField(propertyName, clazz);
        }
        return field;
    }

    String quote(String value) {
        if (value == null) {
            return "null";
        }
        return StringUtils.quoteString((String)value, (char)'\"');
    }

    ClassDesc[] addRelativeClassDescs(ClassDesc[] classDescs, ClassCreationHintBag hintBag) {
        HashMap<String, ArrayList<ClassDesc>> pageByDtoMap = new HashMap<String, ArrayList<ClassDesc>>();
        for (int i = 0; i < classDescs.length; ++i) {
            if (!classDescs[i].isTypeOf(ClassType.PAGE)) continue;
            PropertyDesc[] pds = classDescs[i].getPropertyDescs();
            for (int j = 0; j < pds.length; ++j) {
                ClassDesc cd = pds[j].getTypeDesc().getComponentClassDesc();
                if (!cd.isTypeOf(ClassType.DTO)) continue;
                ArrayList<ClassDesc> list = (ArrayList<ClassDesc>)pageByDtoMap.get(cd.getName());
                if (list == null) {
                    list = new ArrayList<ClassDesc>();
                    pageByDtoMap.put(cd.getName(), list);
                }
                list.add(classDescs[i]);
            }
        }
        ArrayList<ClassDesc> classDescList = new ArrayList<ClassDesc>(Arrays.asList(classDescs));
        for (int i = 0; i < classDescs.length; ++i) {
            DescPool pool = classDescs[i].getDescPool();
            if (!classDescs[i].isTypeOf(ClassType.DTO)) continue;
            EntityMetaData metaData = new EntityMetaData(pool, classDescs[i].getName());
            if (this.setting_.isDaoCreationFeatureEnabled()) {
                ClassDesc daoClassDesc = metaData.newDaoClassDesc();
                daoClassDesc.setBornOf(classDescs[i].getBornOf());
                classDescList.add(daoClassDesc);
                ClassDesc beanClassDesc = metaData.newBeanClassDesc();
                beanClassDesc.setBornOf(classDescs[i].getBornOf());
                PropertyDesc[] pds = classDescs[i].getPropertyDescs();
                for (int j = 0; j < pds.length; ++j) {
                    beanClassDesc.setPropertyDesc(pds[j].transcriptTo(pool.newPropertyDesc(pds[j].getName())));
                }
                PropertyDesc idPd = beanClassDesc.getPropertyDesc(PROPERTY_ID);
                if (idPd == null) {
                    idPd = beanClassDesc.addProperty(PROPERTY_ID, 3);
                    idPd.setTypeDesc(ID_TYPE);
                }
                idPd.setAnnotationDescOnGetter(new AnnotationDescImpl(ID_ANNOTATIONNAME, ID_BODY));
                classDescList.add(beanClassDesc);
            }
            if (!this.setting_.isDxoCreationFeatureEnabled()) continue;
            ClassDesc dxoClassDesc = metaData.newDxoClassDesc();
            dxoClassDesc.setBornOf(classDescs[i].getBornOf());
            List list = (List)pageByDtoMap.get(classDescs[i].getName());
            if (list != null) {
                Iterator itr = list.iterator();
                while (itr.hasNext()) {
                    MethodDescImpl md = new MethodDescImpl(pool, "convert");
                    ParameterDesc[] pmds = new ParameterDesc[]{new ParameterDescImpl(pool, new TypeDescImpl(pool, (ClassDesc)itr.next()))};
                    md.setParameterDescs(pmds);
                    md.setReturnTypeDesc(pool.newTypeDesc(metaData.newBeanClassDesc().getName()));
                    dxoClassDesc.setMethodDesc(md);
                }
            }
            classDescList.add(dxoClassDesc);
        }
        return classDescList.toArray(new ClassDesc[0]);
    }

    String[] getPairTypeNames(ClassDesc classDesc) {
        String[] pairTypeNames = classDesc.getMetaValue("conversion");
        if (pairTypeNames == null) {
            pairTypeNames = MetaUtils.getValue(this.getClass(classDesc.getName() + "Base"), "conversion");
        }
        return pairTypeNames;
    }

    boolean addComponentSetterToPageIfValid(ClassDesc pageClassDesc, TypeDesc typeDesc, ClassDescSet classDescSet) {
        if (DescValidator.validate(typeDesc, classDescSet).isValid()) {
            PropertyDesc propertyDesc = pageClassDesc.addProperty(typeDesc.getInstanceName(), 2);
            propertyDesc.setTypeDesc(typeDesc);
            AnnotationDesc ad = propertyDesc.getAnnotationDesc(Inject.class.getName());
            if (ad == null) {
                propertyDesc.setAnnotationDescOnSetter(new AnnotationDescImpl(Inject.class.getName()));
            }
            return true;
        }
        return false;
    }

    void writeSourceFiles(ClassDescBag classDescBag) {
        for (ClassType type : ClassType.values()) {
            ClassDesc[] classDescs = classDescBag.getClassDescs(type);
            ClassDescSet classDescSet = classDescBag.getClassDescSet();
            for (int i = 0; i < classDescs.length; ++i) {
                try {
                    this.updateClass(classDescs[i], classDescSet);
                    continue;
                }
                catch (InvalidClassDescException ex) {
                    classDescBag.remove(classDescs[i].getName());
                    classDescBag.addAsFailed(classDescs[i], ex.getLackingClassNames());
                }
            }
        }
    }

    @Override
    public void updateClass(ClassDesc classDesc) throws InvalidClassDescException {
        this.updateClass(classDesc, null);
    }

    void updateClass(ClassDesc classDesc, ClassDescSet classDescSet) throws InvalidClassDescException {
        this.adjustByExistentClass(classDesc);
        if (classDesc.isTypeOf(ClassType.PAGE)) {
            ArrayList<MethodDesc> list = new ArrayList<MethodDesc>();
            for (MethodDesc methodDesc : classDesc.getMethodDescs()) {
                if (methodDesc.getAttribute("action") == null) continue;
                list.add(methodDesc);
            }
            classDesc.setAttribute("action", list.toArray(new MethodDesc[0]));
        }
        this.writeSourceFile(classDesc, classDescSet);
    }

    @Override
    public void adjustByExistentClass(ClassDesc desc) {
        ClassDesc baseDesc;
        String className;
        Class<?> clazz;
        DescPool pool = desc.getDescPool();
        ClassDesc gapDesc = this.newClassDesc(pool, clazz = this.getClass(className = desc.getName()), true);
        if (gapDesc == null) {
            gapDesc = this.newClassDesc(pool, className, null);
        }
        String baseClassName = className + "Base";
        Class<?> baseClass = this.getClass(baseClassName);
        ClassDesc classDesc = baseDesc = desc.getType().isSubordinate() ? null : this.newClassDesc(pool, baseClass, true);
        if (baseDesc == null) {
            baseDesc = this.newClassDesc(pool, baseClassName, null);
            if (!baseClassName.equals(desc.getSuperclassName())) {
                baseDesc.setSuperclassName(desc.getSuperclassName());
            }
        }
        if (baseClass != null) {
            desc.setAbstract(Modifier.isAbstract(baseClass.getModifiers()));
        }
        ClassDesc generated = desc.transcriptTo(this.newClassDesc(pool, desc.getName(), null));
        desc.clear();
        desc.setOptionalSourceGeneratorParameter(generated.getOptionalSourceGeneratorParameter());
        desc.setAttributeMap(generated.getAttributeMap());
        ClassDesc baseDescOtherBoneOf = baseDesc.transcriptTo(pool.getClassDesc(baseDesc.getName()));
        baseDescOtherBoneOf.removeBornOfFromAllMembers(desc.getBornOf());
        desc.merge(baseDescOtherBoneOf, true);
        ClassDesc superDesc = this.newClassDesc(pool, this.getClass(desc.getSuperclassName()), false);
        if (superDesc == null) {
            superDesc = this.newClassDesc(pool, Object.class, false);
        }
        PropertyDesc[] pds = generated.getPropertyDescs();
        for (int i = 0; i < pds.length; ++i) {
            AnnotationDesc generatedAd;
            PropertyDesc generatedPd = pds[i];
            PropertyDesc basePd = baseDesc.getPropertyDesc(generatedPd.getName());
            if (basePd == null || !basePd.isReadable()) {
                this.removeModeFrom(generatedPd, 1, gapDesc);
                this.removeModeFrom(generatedPd, 1, superDesc);
            }
            if (basePd == null || !basePd.isWritable()) {
                this.removeModeFrom(generatedPd, 2, gapDesc);
                this.removeModeFrom(generatedPd, 2, superDesc);
            }
            if (!(generatedPd.isReadable() || generatedPd.isWritable() || pds[i].hasMeta("property") && !this.isFormDtoFieldPresent(superDesc, generatedPd.getName()))) {
                generated.removePropertyDesc(generatedPd.getName());
            }
            if (basePd == null || generatedPd == null) continue;
            TypeDesc baseTd = basePd.getTypeDesc();
            TypeDesc generatedTd = generatedPd.getTypeDesc();
            if (generatedTd.getCollectionImplementationClassName() == null) {
                generatedTd.setCollectionImplementationClassName(baseTd.getCollectionImplementationClassName());
            }
            ArrayList<AnnotationDesc> list = new ArrayList<AnnotationDesc>();
            for (AnnotationDesc baseAd : basePd.getAnnotationDescs()) {
                generatedAd = generatedPd.getAnnotationDesc(baseAd.getName());
                if (DescUtils.isMetaAnnotation(generatedAd) || baseAd == null) {
                    list.add(generatedAd);
                    continue;
                }
                list.add(baseAd);
            }
            generatedPd.setAnnotationDescs(list.toArray(new AnnotationDesc[0]));
            list = new ArrayList();
            for (AnnotationDesc baseAd : basePd.getAnnotationDescsOnGetter()) {
                generatedAd = generatedPd.getAnnotationDescOnGetter(baseAd.getName());
                if (DescUtils.isMetaAnnotation(generatedAd) || baseAd == null) {
                    list.add(generatedAd);
                    continue;
                }
                list.add(baseAd);
            }
            generatedPd.setAnnotationDescsOnGetter(list.toArray(new AnnotationDesc[0]));
            list = new ArrayList();
            for (AnnotationDesc baseAd : basePd.getAnnotationDescsOnSetter()) {
                generatedAd = generatedPd.getAnnotationDescOnSetter(baseAd.getName());
                if (DescUtils.isMetaAnnotation(generatedAd) || baseAd == null) {
                    list.add(generatedAd);
                    continue;
                }
                list.add(baseAd);
            }
            generatedPd.setAnnotationDescsOnSetter(list.toArray(new AnnotationDesc[0]));
        }
        MethodDesc[] mds = generated.getMethodDescs();
        for (int i = 0; i < mds.length; ++i) {
            MethodDesc generatedMd = mds[i];
            MethodDesc gapMd = gapDesc.getMethodDesc(generatedMd);
            MethodDesc baseMd = baseDesc.getMethodDesc(generatedMd);
            MethodDesc superMd = superDesc.getMethodDesc(generatedMd);
            if (baseMd == null && (gapMd != null || superMd != null)) {
                generated.removeMethodDesc(generatedMd);
            } else if (gapMd != null && !generatedMd.getReturnTypeDesc().equals(gapMd.getReturnTypeDesc())) {
                generatedMd.setReturnTypeDesc(gapMd.getReturnTypeDesc().transcriptTo(desc.getDescPool().newTypeDesc(gapMd.getReturnTypeDesc().getName())));
            } else if (superMd != null && !generatedMd.getReturnTypeDesc().equals(superMd.getReturnTypeDesc())) {
                generatedMd.setReturnTypeDesc(superMd.getReturnTypeDesc().transcriptTo(desc.getDescPool().newTypeDesc(superMd.getReturnTypeDesc().getName())));
            }
            if (baseMd == null || generated.getMethodDesc(generatedMd) == null) continue;
            ArrayList<AnnotationDesc> list = new ArrayList<AnnotationDesc>();
            for (AnnotationDesc ad : generatedMd.getAnnotationDescs()) {
                AnnotationDesc baseAd = baseMd.getAnnotationDesc(ad.getName());
                if (DescUtils.isMetaAnnotation(ad) || baseAd == null) {
                    list.add(ad);
                    continue;
                }
                list.add(baseAd);
            }
            generatedMd.setAnnotationDescs(list.toArray(new AnnotationDesc[0]));
        }
        LinkedHashMap<String, PropertyDesc> newDescPdMap = new LinkedHashMap<String, PropertyDesc>();
        LinkedHashMap<String, PropertyDesc> descPdMap = new LinkedHashMap<String, PropertyDesc>();
        for (PropertyDesc descPd : desc.getPropertyDescs()) {
            descPdMap.put(descPd.getName(), descPd);
        }
        for (PropertyDesc generatedPd : generated.getPropertyDescs()) {
            String key = generatedPd.getName();
            PropertyDesc pd = (PropertyDesc)descPdMap.get(key);
            if (pd == null) continue;
            newDescPdMap.put(key, pd);
            descPdMap.remove(key);
        }
        for (PropertyDesc descPd : descPdMap.values()) {
            newDescPdMap.put(descPd.getName(), descPd);
        }
        desc.setPropertyDescs(newDescPdMap.values().toArray(new PropertyDesc[0]));
        LinkedHashMap<MethodDescKey, MethodDesc> newDescMdMap = new LinkedHashMap<MethodDescKey, MethodDesc>();
        LinkedHashMap<MethodDescKey, MethodDesc> descMdMap = new LinkedHashMap<MethodDescKey, MethodDesc>();
        for (MethodDesc descMd : desc.getMethodDescs()) {
            descMdMap.put(new MethodDescKey(descMd), descMd);
        }
        for (MethodDesc generatedMd : generated.getMethodDescs()) {
            MethodDescKey key = new MethodDescKey(generatedMd);
            MethodDesc md = (MethodDesc)descMdMap.get(key);
            if (md == null) continue;
            newDescMdMap.put(key, md);
            descMdMap.remove(key);
        }
        for (MethodDesc descMd : descMdMap.values()) {
            newDescMdMap.put(new MethodDescKey(descMd), descMd);
        }
        desc.setMethodDescs(newDescMdMap.values().toArray(new MethodDesc[0]));
        generated.applyBornOfToAllMembers();
        desc.merge(generated, true);
    }

    boolean isFormDtoFieldPresent(ClassDesc cd, String name) {
        Class<?> clazz = this.getClass(cd.getName());
        if (clazz == null || clazz == Object.class) {
            return false;
        }
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (!name.equals(MetaUtils.getFirstValue(field, "property"))) continue;
                return true;
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return false;
    }

    void removeModeFrom(PropertyDesc pd, int mode, ClassDesc cd) {
        PropertyDesc p = cd.getPropertyDesc(pd.getName());
        if (p != null && (p.getMode() & mode) != 0) {
            pd.setMode(pd.getMode() & ~mode);
        }
    }

    public void mergeWithExistentClass(ClassDesc classDesc) {
        String className = classDesc.getName();
        classDesc.merge(this.newClassDesc(classDesc.getDescPool(), this.getClass(className), false), false);
    }

    @Override
    public void writeSourceFile(ClassDesc classDesc, ClassDescSet classDescSet) throws InvalidClassDescException {
        DescValidator.Result result = DescValidator.validate(classDesc, classDescSet);
        if (!result.isValid()) {
            throw new InvalidClassDescException(result.getClassNames());
        }
        this.writeString(this.sourceGenerator_.generateBaseSource(classDesc), this.getSourceFile(classDesc.getName() + "Base"));
        File sourceFile = this.getSourceFile(classDesc.getName());
        if (!sourceFile.exists()) {
            this.writeString(this.sourceGenerator_.generateGapSource(classDesc), sourceFile);
        }
    }

    @Override
    public void writeSourceFile(String templateName, ClassDesc classDesc, boolean force) {
        File sourceFile = this.getSourceFile(classDesc.getName());
        if (force || !sourceFile.exists()) {
            this.writeString(this.sourceGenerator_.generateClassSource(templateName, classDesc), sourceFile);
        }
    }

    void writeString(String string, File file) {
        if (string == null) {
            return;
        }
        file.getParentFile().mkdirs();
        try {
            this.writeString(string, new FileOutputStream(file));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    void writeString(String string, OutputStream os) {
        try {
            if (string == null) {
                return;
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, this.sourceEncoding_));
            writer.write(string);
            writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public MatchedPathMapping findMatchedPathMapping(String path, HttpMethod method) {
        if (path == null) {
            return null;
        }
        return this.ymir_.findMatchedPathMapping(path, method);
    }

    @Override
    public boolean isDenied(String path, HttpMethod method) {
        if (path == null) {
            return true;
        }
        MatchedPathMapping matched = this.ymir_.findMatchedPathMapping(path, method);
        if (matched == null) {
            return true;
        }
        return matched.getPathMapping().isDenied();
    }

    @Override
    public String getComponentName(String path, HttpMethod method) {
        if (path == null) {
            return null;
        }
        MatchedPathMapping matched = this.ymir_.findMatchedPathMapping(path, method);
        if (matched == null) {
            return null;
        }
        return matched.getPathMapping().getPageComponentName(matched.getVariableResolver());
    }

    @Override
    public String getClassName(String componentName) {
        LocalHotdeployS2Container hotdeployContainer;
        String className;
        if (componentName != null && (className = (hotdeployContainer = this.getApplication().getHotdeployS2Container()).getNamingConvention().fromComponentNameToClassName(componentName)) != null) {
            return className;
        }
        return null;
    }

    @Override
    public Class<?> getClass(String className) {
        if (className == null) {
            return null;
        }
        Class clazz = ClassUtils.getPrimitiveClass((String)className);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader cl = this.getClassLoader();
        try {
            return Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException ex) {
            block16: {
                if (className.indexOf(46) < 0) {
                    try {
                        return Class.forName(PACKAGEPREFIX_JAVA_LANG + className, true, cl);
                    }
                    catch (ClassNotFoundException ex2) {
                        try {
                            return Class.forName(PACKAGEPREFIX_JAVA_UTIL + className, true, cl);
                        }
                        catch (ClassNotFoundException ex3) {
                            try {
                                return Class.forName(PACKAGEPREFIX_FREYJA_RENDER_HTML + className, true, cl);
                            }
                            catch (ClassNotFoundException ex4) {
                                ClassTraverser traverser = new ClassTraverser();
                                try {
                                    traverser.addReferenceClass(Class.forName("org.seasar.ymir.landmark.Landmark", true, this.getClassLoader()));
                                }
                                catch (ClassNotFoundException ex5) {
                                    return null;
                                }
                                for (String rootPackageName : this.getRootPackageNames()) {
                                    traverser.addClassPattern(rootPackageName, className);
                                }
                                final String[] found = new String[1];
                                traverser.setClassHandler(new ClassTraversal.ClassHandler(){

                                    public void processClass(String packageName, String shortClassName) {
                                        found[0] = packageName + "." + shortClassName;
                                    }
                                });
                                traverser.traverse();
                                if (found[0] == null) break block16;
                                try {
                                    return Class.forName(found[0], true, cl);
                                }
                                catch (ClassNotFoundException ignore) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
            return null;
        }
    }

    protected ClassLoader getClassLoader() {
        return this.getApplication().getHotdeployS2Container().getContainer().getClassLoader();
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String className, String propertyName) {
        BeanInfo beanInfo;
        Class<?> clazz = this.getClass(className);
        if (clazz == null || propertyName == null) {
            return null;
        }
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex);
        }
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            if (!descriptor.getName().equals(propertyName)) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public Template getTemplate(String path) {
        return this.templateProvider_.getTemplate(path);
    }

    @Override
    public File getSourceFile(String className) {
        return new File(this.getSourceDirectory(), className.replace('.', '/') + ".java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getSourceCreatorProperties() {
        if (this.sourceCreatorProperties_ == null) {
            this.sourceCreatorProperties_ = new Properties();
            File file = this.getSourceCreatorPropertiesFile();
            if (file.exists()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    this.sourceCreatorProperties_.load(new BufferedInputStream(fis));
                }
                catch (IOException ex) {
                    this.log_.error((Object)("Can't read properties: " + file));
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return this.sourceCreatorProperties_;
    }

    @Override
    public File getSourceCreatorPropertiesFile() {
        return new File(this.getPreferencesDirectory(), "org.seasar.ymir.extension.sourceCreator.prefs");
    }

    File getMappingPropertiesFile() {
        return new File(this.getPreferencesDirectory(), "org.seasar.ymir.extension.mapping.prefs");
    }

    @Override
    public PersistentProperties getMappingProperties() {
        return new PersistentProperties(this.getMappingPropertiesFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSourceCreatorProperties() {
        if (this.sourceCreatorProperties_ == null) {
            return;
        }
        MapProperties prop = new MapProperties(new TreeMap<Object, Object>(this.sourceCreatorProperties_));
        File file = this.getSourceCreatorPropertiesFile();
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            prop.store((OutputStream)new BufferedOutputStream(fos), "ISO-8859-1");
            fos = null;
        }
        catch (IOException ex) {
            this.log_.error((Object)("Can't write properties: " + file));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public File getSourceDirectory() {
        String sourceDirectory = this.getApplication().getSourceDirectory();
        if (sourceDirectory != null) {
            return new File(sourceDirectory);
        }
        return null;
    }

    @Override
    public File getResourcesDirectory() {
        String resourcesDirectory = this.getApplication().getResourcesDirectory();
        if (resourcesDirectory != null) {
            return new File(resourcesDirectory);
        }
        return null;
    }

    File getPreferencesDirectory() {
        return new File(this.getApplication().getProjectRoot(), ".settings");
    }

    @Override
    public File getWebappSourceRoot() {
        return new File(this.getApplication().getWebappSourceRoot());
    }

    public TemplateAnalyzer getTemplateAnalyzer() {
        return this.analyzer_;
    }

    @Override
    public String getSourceEncoding() {
        return this.sourceEncoding_;
    }

    @Override
    public String getFirstRootPackageName() {
        return this.getApplication().getFirstRootPackageName();
    }

    @Override
    public String[] getRootPackageNames() {
        return this.getApplication().getRootPackageNames();
    }

    @Override
    public String getPagePackageName() {
        return this.getFirstRootPackageName() + "." + this.namingConvention_.getSubApplicationRootPackageName();
    }

    @Override
    public String getDtoPackageName() {
        return this.getFirstRootPackageName() + "." + this.namingConvention_.getDtoPackageName();
    }

    @Override
    public String getDaoPackageName() {
        return this.getFirstRootPackageName() + "." + this.namingConvention_.getDaoPackageName();
    }

    @Override
    public String getDxoPackageName() {
        return this.getFirstRootPackageName() + "." + this.namingConvention_.getDxoPackageName();
    }

    @Override
    public String getConverterPackageName() {
        return this.getFirstRootPackageName() + "." + this.namingConvention_.getConverterPackageName();
    }

    @Override
    public SourceGenerator getSourceGenerator() {
        return this.sourceGenerator_;
    }

    @Override
    public ResponseCreator getResponseCreator() {
        return this.responseCreator_;
    }

    @Override
    public Application getApplication() {
        return this.applicationManager_.findContextApplication();
    }

    @Override
    public ServletContext getServletContext() {
        return (ServletContext)this.getRootS2Container().getComponent(ServletContext.class);
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.getRootS2Container().getComponent(HttpServletRequest.class);
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)this.getRootS2Container().getComponent(HttpServletResponse.class);
    }

    Request getRequest() {
        return (Request)this.getRootS2Container().getComponent(Request.class);
    }

    S2Container getS2Container() {
        return this.getApplication().getS2Container();
    }

    S2Container getRootS2Container() {
        return SingletonS2ContainerFactory.getContainer();
    }

    public void registerUpdateAction(Object condition, UpdateAction updateAction) {
        this.actionSelector_.register(condition, updateAction);
    }

    @Override
    public ClassDesc newClassDesc(DescPool pool, String className, ClassCreationHintBag hintBag) {
        ClassHint hint;
        ClassDescImpl classDesc = new ClassDescImpl(pool, className);
        String superclassName = null;
        if (hintBag != null && (hint = hintBag.getClassHint(className)) != null) {
            superclassName = hint.getSuperclassName();
        }
        if (superclassName == null) {
            Class<?> superclass;
            Class<?> clazz = this.getClass(className);
            if (clazz != null && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
                if (superclass.getName().endsWith("Base")) {
                    superclass = superclass.getSuperclass();
                }
                superclassName = superclass.getName();
            }
            if (superclassName == null) {
                superclassName = this.setting_.getSuperclassName(className);
                if (superclassName == null && classDesc.isTypeOf(ClassType.PAGE) && className.equals(superclassName = this.setting_.getPageSuperclassName())) {
                    superclassName = null;
                }
                if (superclassName != null && (superclass = this.findClass(ClassUtils.getShortName((String)superclassName), className)) != null) {
                    superclassName = superclass.getName();
                }
            }
        }
        if (superclassName != null) {
            classDesc.setSuperclassName(superclassName);
        }
        return classDesc;
    }

    @Override
    public TemplateProvider getTemplateProvider() {
        return this.templateProvider_;
    }

    public String filterResponse(String response) {
        if (!this.shouldUpdate()) {
            return response;
        }
        if (this.setting_.isInPlaceEditorEnabled() || this.setting_.isControlPanelEnabled()) {
            String jsPrefix = "<script type=\"text/javascript\" src=\"" + this.getHttpServletRequest().getContextPath() + "/__ymir__/" + "resource/js/";
            String jsSuffix = "\"></script>";
            response = response.replace("</head>", jsPrefix + "prototype/prototype.js" + jsSuffix + jsPrefix + "scriptaculous/scriptaculous.js" + jsSuffix + jsPrefix + "sourceCreator.js" + jsSuffix + "</head>");
            if (this.setting_.isInPlaceEditorEnabled()) {
                response = Pattern.compile("(<body(\\s+[^>]*)?>)").matcher(response).replaceFirst("$1" + Matcher.quoteReplacement("<div id=\"__ymir__inPlaceEditor\">"));
                response = response.replace("</body>", "</div></body>");
            }
            if (this.setting_.isControlPanelEnabled()) {
                response = response.replace("</body>", "<div id=\"__ymir__controlPanel\">" + this.createControlPanelFormHTML(this.getRequest()) + this.createUpdateClassesButtonHTML(this.getRequest()) + "</div></body>");
            }
        }
        return response;
    }

    String createControlPanelFormHTML(Request request) {
        return this.createButtonHTML(request, "systemConsole", "SYSTEM CONSOLE");
    }

    String createUpdateClassesButtonHTML(Request request) {
        return this.createButtonHTML(request, "updateClasses", "UPDATE CLASSES");
    }

    String createButtonHTML(Request request, String taskName, String buttonLabel) {
        StringBuilder sb = new StringBuilder();
        sb.append("<form action=\"").append(request.getAbsolutePath()).append("\" method=\"post\">").append("<input type=\"hidden\" name=\"").append("__ymir__task").append("\" value=\"").append(taskName).append("\" /><input type=\"hidden\" name=\"").append("__ymir__method").append("\" value=\"").append(request.getMethod()).append("\" />");
        Iterator itr = request.getParameterNames();
        while (itr.hasNext()) {
            String encodedName;
            String name = (String)itr.next();
            if (name.startsWith("__ymir__")) continue;
            try {
                encodedName = HTMLUtils.filter((String)URLEncoder.encode(name, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Can't happen!", ex);
            }
            for (String value : request.getParameterValues(name)) {
                String encodedValue;
                try {
                    encodedValue = HTMLUtils.filter((String)URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException("Can't happen!", ex);
                }
                sb.append("<input type=\"hidden\" name=\"").append(encodedName).append("\" value=\"").append(encodedValue).append("\" />");
            }
        }
        sb.append("<input type=\"submit\" value=\"").append(buttonLabel).append("\" /></form>");
        return sb.toString();
    }

    @Override
    public String getTemplateEncoding() {
        return this.getApplication().getTemplateEncoding();
    }

    @Override
    public long getCheckedTime(Template template) {
        String key;
        Properties prop = this.getSourceCreatorProperties();
        String timeString = prop.getProperty(key = "updateClassesAction.checkedTime." + template.getPath());
        long time = timeString == null ? 0L : Long.parseLong(timeString);
        return time;
    }

    @Override
    public void updateCheckedTime(Template template) {
        Properties prop = this.getSourceCreatorProperties();
        String key = "updateClassesAction.checkedTime." + template.getPath();
        prop.setProperty(key, String.valueOf(System.currentTimeMillis()));
        this.saveSourceCreatorProperties();
    }

    @Override
    public String getJavaPreamble() {
        return IOUtils.readString((InputStream)this.getClassLoader().getResourceAsStream(RESOURCE_PREAMBLE_JAVA), (String)"UTF-8", (boolean)true);
    }

    @Override
    public SourceCreatorSetting getSourceCreatorSetting() {
        return this.setting_;
    }

    @Override
    public ExtraPathMapping getExtraPathMapping(String path, HttpMethod method) {
        PathMappingExtraData<?> pathMappingExtraData;
        MatchedPathMapping mapping = this.findMatchedPathMapping(path, method);
        if (mapping == null) {
            return null;
        }
        Class<?> clazz = mapping.getPathMapping().getClass();
        do {
            pathMappingExtraData = this.pathMappingExtraDataMap_.get(clazz);
            clazz = clazz.getSuperclass();
        } while (pathMappingExtraData == null && clazz != Object.class);
        if (pathMappingExtraData == null) {
            throw new RuntimeException("PathMappingExtraData not found. Please register PathMappingExtraData Component: " + clazz.getName());
        }
        return new ExtraPathMappingImpl(pathMappingExtraData, mapping, path, method);
    }

    @Override
    public Class<?> findClass(String name, String baseClassName) {
        int dot;
        int pre = baseClassName.length();
        while ((dot = baseClassName.lastIndexOf(46, pre)) >= 0) {
            try {
                return Class.forName(baseClassName.substring(0, dot + 1) + name);
            }
            catch (ClassNotFoundException ignore) {
                pre = dot - 1;
            }
        }
        return null;
    }

    @Override
    public MethodDesc newActionMethodDesc(ClassDesc classDesc, String path, HttpMethod method, ActionSelectorSeed seed) {
        MethodDesc methodDesc = this.getExtraPathMapping(path, method).newActionMethodDesc(classDesc, seed);
        methodDesc.setAttribute("action", Boolean.TRUE);
        String returnType = this.setting_.getActionReturnType(method);
        methodDesc.setReturnTypeDesc(returnType);
        this.setActionMethodDescBodyTo(methodDesc);
        return methodDesc;
    }

    void setActionMethodDescBodyTo(MethodDesc methodDesc) {
        String returnType = methodDesc.getReturnTypeDesc().getCompleteName();
        if (returnType.equals(String.class.getName())) {
            methodDesc.setBodyDesc(new BodyDescImpl("return \"passthrough:\";"));
        } else if (returnType.equals(Response.class.getName())) {
            methodDesc.setBodyDesc(new BodyDescImpl("return new org.seasar.ymir.response.PassthroughResponse();"));
        }
    }

    boolean isValidationFailedMethodEnabled() {
        return PropertyUtils.valueOf((String)this.applicationManager_.findContextApplication().getProperty("core.constraint.validationFailedMethod.enable"), (boolean)true);
    }

    boolean isPermissionDeniedMethodEnabled() {
        return PropertyUtils.valueOf((String)this.applicationManager_.findContextApplication().getProperty("core.constraint.permissionDeniedMethod.enable"), (boolean)true);
    }

    @Override
    public boolean isGeneratedClass(String className) {
        return className.startsWith(this.getFirstRootPackageName() + ".");
    }

    @Override
    public boolean isDtoClass(String className) {
        if (className == null) {
            return false;
        }
        return this.setting_.isOnDtoSearchPath(className) || new ClassDescImpl(null, className).isTypeOf(ClassType.DTO);
    }
}

