/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.seasar.kvasir.util.collection.MapProperties;
import org.seasar.ymir.Application;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.extension.creator.action.impl.AbstractAction;
import org.seasar.ymir.extension.creator.util.SourceCreatorUtils;
import org.seasar.ymir.util.StringUtils;

public class CreateConfigurationAction
extends AbstractAction
implements UpdateAction {
    private static final String PARAMPREFIX_KEY = "__ymir__key_";

    public CreateConfigurationAction(SourceCreator sourceCreator) {
        super(sourceCreator);
    }

    public Response act(Request request, PathMetaData pathMetaData) {
        if (this.isSkipButtonPushed(request)) {
            return null;
        }
        String subTask = request.getParameter("__ymir__subTask");
        if ("create".equals(subTask)) {
            return this.actCreate(request, pathMetaData);
        }
        return this.actDefault(request, pathMetaData);
    }

    Response actDefault(Request request, PathMetaData pathMetaData) {
        Application application = this.getSourceCreator().getApplication();
        String originalProjectRoot = SourceCreatorUtils.getOriginalProjectRoot(application);
        boolean shouldSpecifyProjectRoot = originalProjectRoot != null || application.getProjectRoot() == null;
        boolean existsProjectRoot = originalProjectRoot != null && new File(originalProjectRoot).exists();
        boolean canBeEmptyProjectRoot = SourceCreatorUtils.findProjectRootDirectory(application) != null;
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("application", application);
        variableMap.put("setting", this.getSourceCreatorSetting());
        variableMap.put("reconfigured", this.isReconfigured());
        variableMap.put("shouldSpecifyProjectRoot", shouldSpecifyProjectRoot);
        variableMap.put("existsProjectRoot", existsProjectRoot);
        variableMap.put("originalProjectRoot", originalProjectRoot);
        variableMap.put("canBeEmptyProjectRoot", canBeEmptyProjectRoot);
        return this.getSourceCreator().getResponseCreator().createResponse("createConfiguration", variableMap);
    }

    boolean isReconfigured() {
        return this.getSourceCreator().getApplication().getFirstRootPackageName() != null;
    }

    Response actCreate(Request request, PathMetaData pathMetaDataf) {
        String method = request.getParameter("__ymir__method");
        if (method == null) {
            return null;
        }
        Application application = this.getSourceCreator().getApplication();
        MapProperties orderedProp = SourceCreatorUtils.readAppPropertiesInOrder(application);
        orderedProp.removeProperty("projectRoot");
        TreeSet nameSet = new TreeSet();
        Iterator itr = request.getParameterNames();
        while (itr.hasNext()) {
            nameSet.add(itr.next());
        }
        for (String name : nameSet) {
            if (!name.startsWith(PARAMPREFIX_KEY)) continue;
            boolean remove = false;
            String key = name.substring(PARAMPREFIX_KEY.length());
            String value = request.getParameter(name).trim();
            if ("projectRoot".equals(key)) {
                if (value.trim().length() == 0) {
                    remove = true;
                    value = SourceCreatorUtils.findProjectRootDirectory(application);
                }
                application.setProjectRoot(value);
            } else if ("extension.sourceCreator.superclass".equals(key)) {
                if (!StringUtils.isEmpty((String)value)) {
                    application.setProperty(key, value);
                    this.getSourceCreator().writeSourceFile("PageSuperclass.java", this.getSourceCreator().newClassDesc(this.newDescPool(), value, null), false);
                } else {
                    application.removeProperty(key);
                    remove = true;
                }
            } else {
                application.setProperty(key, value);
            }
            if (remove) continue;
            orderedProp.setProperty(key, value);
        }
        String propertiesFilePath = application.getDefaultPropertiesFilePath();
        if (propertiesFilePath != null) {
            File file = new File(propertiesFilePath);
            file.getParentFile().mkdirs();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                SourceCreatorUtils.writeHeader(fos, null);
                orderedProp.store((OutputStream)fos);
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't write property file: " + file.getAbsolutePath());
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        boolean successfullySynchronized = this.synchronizeResources(null);
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("createConfiguration_create", variableMap);
    }
}

