/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.mapping.impl;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.kvasir.util.el.VariableResolver;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.ParameterDesc;
import org.seasar.ymir.extension.creator.impl.MethodDescImpl;
import org.seasar.ymir.extension.creator.impl.ParameterDescImpl;
import org.seasar.ymir.extension.creator.mapping.ActionSelectorSeed;
import org.seasar.ymir.extension.creator.mapping.PathMappingExtraData;
import org.seasar.ymir.impl.YmirPathMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YmirPathMappingExtraData
implements PathMappingExtraData<YmirPathMapping> {
    @Override
    public Class<YmirPathMapping> getPathMappingClass() {
        return YmirPathMapping.class;
    }

    @Override
    public MethodDesc newActionMethodDesc(ClassDesc classDesc, YmirPathMapping pathMapping, VariableResolver resolver, String path, HttpMethod method, ActionSelectorSeed seed) {
        YmirPathMapping.Button button;
        StringBuilder sb = new StringBuilder();
        sb.append(pathMapping.getActionName(resolver));
        String buttonName = seed.getButtonName();
        String patternString = "_([a-zA-Z][a-zA-Z0-9]*)";
        ArrayList<ParameterDescImpl> pdList = new ArrayList<ParameterDescImpl>();
        if (buttonName != null && patternString != null && (button = new YmirPathMapping.Button(buttonName)).isValid()) {
            sb.append(this.createActionSuffix(button.getName(), patternString));
            String[] parameters = button.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Class<Object> type;
                try {
                    Integer.parseInt(parameters[i]);
                    type = Integer.TYPE;
                }
                catch (NumberFormatException ex) {
                    try {
                        Double.parseDouble(parameters[i]);
                        type = Double.TYPE;
                    }
                    catch (NumberFormatException ex2) {
                        type = String.class;
                    }
                }
                pdList.add(new ParameterDescImpl(classDesc.getDescPool(), type, "index" + (i == 0 ? "" : String.valueOf(i + 1))));
            }
        }
        MethodDescImpl md = new MethodDescImpl(classDesc.getDescPool(), sb.toString());
        md.setParameterDescs(pdList.toArray(new ParameterDesc[0]));
        return md;
    }

    String createActionSuffix(String buttonName, String patternString) {
        int parenB = patternString.indexOf(40);
        if (parenB < 0) {
            throw new RuntimeException("Illegal button name pattern: " + patternString);
        }
        int parenE = patternString.indexOf(41, parenB + 1);
        if (parenE < 0) {
            throw new RuntimeException("Illegal button name pattern: " + patternString);
        }
        return this.getMinimumMatchedString(patternString.substring(0, parenB)) + buttonName + this.getMinimumMatchedString(patternString.substring(parenE + 1));
    }

    String getMinimumMatchedString(String patternString) {
        if (patternString == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Pattern pattern = Pattern.compile("\\[([^]]+)\\]");
        Matcher matcher = pattern.matcher(patternString);
        int pre = 0;
        while (matcher.find(pre)) {
            sb.append(patternString.substring(pre, matcher.start()));
            sb.append(matcher.group(1).charAt(0));
            pre = matcher.end();
        }
        sb.append(patternString.substring(pre));
        String s = sb.toString();
        sb = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (escaped) {
                sb.append(ch);
                escaped = false;
                continue;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            if (ch == '.') {
                sb.append('_');
                continue;
            }
            if (ch == '^' || ch == '$' || ch == '?' || ch == '*' || ch == '+' || ch == '(' || ch == ')') continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public MethodDesc newRenderActionMethodDesc(ClassDesc classDesc, YmirPathMapping pathMapping, VariableResolver resolver, String path, HttpMethod method, ActionSelectorSeed seed) {
        return new MethodDescImpl(classDesc.getDescPool(), "_prerender");
    }
}

