package org.seasar.ymir;

/**
 * フレームワークにおけるライフサイクル毎のオブジェクトの振る舞いを規定するためのインタフェースです。
 * <p>コンテナに登録されているコンポーネントのうちこのインタフェースを実装しているものについて、
 * フレームワークの初期化時（通常Webアプリケーションコンテキストの初期化タイミングと同一）に
 * {@link #init()}が呼び出されます。
 * また、フレームワークの終了時（通常Webアプリケーションコンテキストの破棄タイミングと同一）に
 * {@link #destroy()}が呼び出されます。
 * </p>
 * <p><b>同期化：</b>
 * このインタフェースの実装クラスはスレッドセーフである必要はありません。
 * </p>
 * 
 * @author YOKOTA Takehiko
 */
public interface LifecycleListener {
    /**
     * このオブジェクトを初期化します。
     */
    void init();

    /**
     * このオブジェクトを破棄する際に必要な処理を行います。
     */
    void destroy();
}
