/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.ymir.Dispatcher;
import org.seasar.ymir.FormFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletUtils {
    public static final String ATTR_INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String ATTR_INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String ATTR_INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String ATTR_INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String ATTR_FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String ATTR_FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String ATTR_FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String ATTR_FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    public static final String ATTR_ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    public static final int PORT_HTTP = 80;
    public static final int PORT_HTTPS = 443;
    private static final String PROTOCOL_DOMAIN_DELIMITER = "://";
    public static final String SEGMENT_PARENT = "..";
    public static final String SEGMENT_CURRENT = ".";
    private static final Pattern PATTERN_SESSIONID = Pattern.compile(";jsessionid=[^#?]+");
    private static final String REPLACEMENT_OMIT_SESSIONID = "";
    private static final Pattern PATTERN_STRIPPED_URL = Pattern.compile("([^;#?]*)[;#?].*");
    private static final Pattern PATTERN_EMBED_SESSIONID = Pattern.compile("[;#?]");

    protected ServletUtils() {
    }

    public static String getRequestContextPath(HttpServletRequest request) {
        if (ServletUtils.wasForwareded(request)) {
            return (String)request.getAttribute(ATTR_FORWARD_CONTEXT_PATH);
        }
        return request.getContextPath();
    }

    public static String getContextPath(HttpServletRequest request) {
        Dispatcher dispatcher = ServletUtils.getDispatcher((ServletRequest)request);
        if (dispatcher == Dispatcher.INCLUDE) {
            return (String)request.getAttribute(ATTR_INCLUDE_CONTEXT_PATH);
        }
        if (dispatcher == Dispatcher.FORWARD) {
            return request.getContextPath();
        }
        return request.getContextPath();
    }

    public static String getRequestPath(HttpServletRequest request) {
        String path = ServletUtils.getNativeRequestPath(request);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getPath(HttpServletRequest request) {
        String path = ServletUtils.getNativePath(request);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getNativeRequestPath(HttpServletRequest request) {
        String pathInfo;
        String servletPath;
        StringBuilder sb = new StringBuilder();
        if (ServletUtils.wasForwareded(request)) {
            servletPath = (String)request.getAttribute(ATTR_FORWARD_SERVLET_PATH);
            pathInfo = (String)request.getAttribute(ATTR_FORWARD_PATH_INFO);
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        sb.append(servletPath);
        if (pathInfo != null) {
            sb.append(pathInfo);
        }
        return sb.toString();
    }

    public static String getNativePath(HttpServletRequest request) {
        String pathInfo;
        String servletPath;
        StringBuilder sb = new StringBuilder();
        Dispatcher dispatcher = ServletUtils.getDispatcher((ServletRequest)request);
        if (dispatcher == Dispatcher.INCLUDE) {
            servletPath = (String)request.getAttribute(ATTR_INCLUDE_SERVLET_PATH);
            pathInfo = (String)request.getAttribute(ATTR_INCLUDE_PATH_INFO);
        } else if (dispatcher == Dispatcher.FORWARD) {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        sb.append(servletPath);
        if (pathInfo != null) {
            sb.append(pathInfo);
        }
        return sb.toString();
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getQueryString(HttpServletRequest request) {
        Dispatcher dispatcher = ServletUtils.getDispatcher((ServletRequest)request);
        if (dispatcher == Dispatcher.INCLUDE) {
            return (String)request.getAttribute(ATTR_INCLUDE_QUERY_STRING);
        }
        if (dispatcher == Dispatcher.FORWARD) {
            return request.getQueryString();
        }
        return request.getQueryString();
    }

    public static String getQueryString(String path) {
        if (path == null) {
            return null;
        }
        int question = path.indexOf(63);
        if (question >= 0) {
            String rawQueryString = path.substring(question + 1);
            if (rawQueryString.trim().length() == 0) {
                return null;
            }
            return rawQueryString;
        }
        return null;
    }

    public static Dispatcher getDispatcher(ServletRequest request) {
        if (request.getAttribute(ATTR_ERROR_EXCEPTION) != null) {
            return Dispatcher.ERROR;
        }
        if (request.getAttribute(ATTR_INCLUDE_CONTEXT_PATH) != null) {
            return Dispatcher.INCLUDE;
        }
        if (request.getAttribute(ATTR_FORWARD_CONTEXT_PATH) != null) {
            return Dispatcher.FORWARD;
        }
        return Dispatcher.REQUEST;
    }

    public static String constructURI(String path, Map<String, ? extends Object> paramMap, String encoding) throws UnsupportedEncodingException {
        if (paramMap == null) {
            return path;
        }
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        StringBuilder sb = new StringBuilder(path);
        String delim = "?";
        for (Map.Entry<String, ? extends Object> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            String encodedKey = URLEncoder.encode(key, encoding);
            String[] values = value instanceof String[] ? (String[])value : new String[]{value.toString()};
            for (int i = 0; i < values.length; ++i) {
                sb.append(delim);
                delim = "&";
                sb.append(encodedKey);
                sb.append("=");
                sb.append(URLEncoder.encode(values[i], encoding));
            }
        }
        return sb.toString();
    }

    static boolean wasForwareded(HttpServletRequest request) {
        return request.getAttribute(ATTR_FORWARD_CONTEXT_PATH) != null;
    }

    public static void setNoCache(HttpServletResponse response) {
        ServletUtils.setNoCache(response, false);
    }

    public static void setNoCache(HttpServletResponse response, boolean force) {
        if (response == null || !force && response.containsHeader("Cache-Control")) {
            return;
        }
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        response.setDateHeader("Expires", 1L);
    }

    public static String constructURL(HttpServletRequest request, String scheme, int port, String absolutePath) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(scheme).append(PROTOCOL_DOMAIN_DELIMITER);
        sb.append(request.getServerName());
        if (!(SCHEME_HTTP.equals(scheme) && port == 80 || SCHEME_HTTPS.equals(scheme) && port == 443)) {
            sb.append(':').append(port);
        }
        sb.append(absolutePath);
        return sb.toString();
    }

    public static String getRequestURL(HttpServletRequest request) {
        return ServletUtils.constructRequestURL(request, request.getScheme(), request.getServerPort());
    }

    public static String constructRequestURL(HttpServletRequest request, String scheme, int port) {
        String queryString;
        String pathInfo;
        String servletPath;
        String contextPath;
        StringBuilder sb = new StringBuilder(256);
        sb.append(scheme).append(PROTOCOL_DOMAIN_DELIMITER);
        sb.append(request.getServerName());
        if (!(SCHEME_HTTP.equals(scheme) && port == 80 || SCHEME_HTTPS.equals(scheme) && port == 443)) {
            sb.append(':').append(port);
        }
        if (ServletUtils.wasForwareded(request)) {
            contextPath = (String)request.getAttribute(ATTR_FORWARD_CONTEXT_PATH);
            servletPath = (String)request.getAttribute(ATTR_FORWARD_SERVLET_PATH);
            pathInfo = (String)request.getAttribute(ATTR_FORWARD_PATH_INFO);
            queryString = (String)request.getAttribute(ATTR_FORWARD_QUERY_STRING);
        } else {
            contextPath = request.getContextPath();
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
            queryString = request.getQueryString();
        }
        sb.append(contextPath).append(servletPath);
        if (pathInfo != null) {
            sb.append(pathInfo);
        }
        if (queryString != null) {
            sb.append('?').append(queryString);
        }
        return sb.toString();
    }

    public static Map<String, String[]> parseParameters(String param, String encoding) throws UnsupportedEncodingException {
        if (param == null) {
            return null;
        }
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        StringTokenizer st = new StringTokenizer(param, "&");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String tkn = st.nextToken();
            int equal = tkn.indexOf("=");
            if (equal >= 0) {
                name = tkn.substring(0, equal);
                value = tkn.substring(equal + 1);
            } else {
                name = tkn;
                value = REPLACEMENT_OMIT_SESSIONID;
            }
            name = URLDecoder.decode(name, encoding);
            value = URLDecoder.decode(value, encoding);
            Object[] current = (String[])map.get(name);
            if (current == null) {
                map.put(name, new String[]{value});
                continue;
            }
            map.put(name, (String[])ArrayUtil.add((Object[])current, (Object)value));
        }
        return map;
    }

    public static String getTrunk(String path) {
        if (path == null) {
            return null;
        }
        int question = path.indexOf(63);
        if (question < 0) {
            return path;
        }
        return path.substring(0, question);
    }

    public static void addParameter(Object name, Object value, Map<String, String[]> parameterMap, Map<String, FormFile[]> fileParameterMap) {
        if (!(name instanceof String)) {
            throw new IllegalArgumentException("Parameter name must be a string: " + name);
        }
        String stringName = (String)name;
        if (value != null) {
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    ServletUtils.addParameter(name, Array.get(value, i), parameterMap, fileParameterMap);
                }
            } else if (value instanceof Collection) {
                for (Object v : (Collection)value) {
                    ServletUtils.addParameter(name, v, parameterMap, fileParameterMap);
                }
            } else if (fileParameterMap != null && value instanceof FormFile) {
                ServletUtils.addToMap(fileParameterMap, stringName, new FormFile[]{(FormFile)value});
            } else {
                ServletUtils.addToMap(parameterMap, stringName, new String[]{value.toString()});
            }
        }
    }

    public static <V> void addToMap(Map<String, V[]> map, String name, V[] values) {
        Object[] vs = map.get(name);
        if (vs == null) {
            vs = values;
        } else {
            ArrayList<V> list = new ArrayList<V>();
            list.addAll(Arrays.asList(vs));
            list.addAll(Arrays.asList(values));
            Object[] newVs = list.toArray((Object[])Array.newInstance(vs.getClass().getComponentType(), 0));
            vs = newVs;
        }
        map.put(name, vs);
    }

    public static String toAbsolutePath(String basePath, String path) {
        String segment;
        int idx;
        String parameter;
        int slash;
        if (path == null) {
            return null;
        }
        if (path.length() == 0 || path.startsWith(";") || path.startsWith("?") || path.startsWith("#")) {
            return basePath + path;
        }
        String absolutePath = path.startsWith("/") ? path : ((slash = basePath.lastIndexOf(47)) >= 0 ? basePath.substring(0, slash + 1) + path : basePath + "/" + path);
        int semicolon = absolutePath.indexOf(59);
        int question = absolutePath.indexOf(63);
        if (semicolon < 0) {
            if (question < 0) {
                parameter = REPLACEMENT_OMIT_SESSIONID;
            } else {
                parameter = absolutePath.substring(question);
                absolutePath = absolutePath.substring(0, question);
            }
        } else if (question < 0 || semicolon < question) {
            parameter = absolutePath.substring(semicolon);
            absolutePath = absolutePath.substring(0, semicolon);
        } else {
            parameter = absolutePath.substring(question);
            absolutePath = absolutePath.substring(0, question);
        }
        int pre = 0;
        LinkedList<String> segmentList = new LinkedList<String>();
        while ((idx = absolutePath.indexOf(47, pre)) >= 0) {
            segment = absolutePath.substring(pre, idx);
            if (segment.equals(SEGMENT_PARENT)) {
                if (!segmentList.isEmpty()) {
                    segmentList.removeLast();
                }
            } else if (!segment.equals(SEGMENT_CURRENT)) {
                segmentList.addLast(segment);
            }
            pre = idx + 1;
        }
        segment = absolutePath.substring(pre);
        if (segment.equals(SEGMENT_PARENT)) {
            if (!segmentList.isEmpty()) {
                segmentList.removeLast();
            }
        } else if (!segment.equals(SEGMENT_CURRENT)) {
            segmentList.addLast(segment);
        }
        StringBuilder sb = new StringBuilder();
        String delim = REPLACEMENT_OMIT_SESSIONID;
        Iterator itr = segmentList.iterator();
        while (itr.hasNext()) {
            sb.append(delim).append((String)itr.next());
            delim = "/";
        }
        if (absolutePath.endsWith("/") || absolutePath.endsWith("/.") || absolutePath.endsWith("/..")) {
            sb.append("/");
        }
        sb.append(parameter);
        return sb.toString();
    }

    public static boolean isSessionIdEmbedded(String url) {
        if (url == null) {
            return false;
        }
        return PATTERN_SESSIONID.matcher(url).find();
    }

    public static String omitSessionId(String url) {
        if (url == null) {
            return null;
        }
        return PATTERN_SESSIONID.matcher(url).replaceFirst(REPLACEMENT_OMIT_SESSIONID);
    }

    public static String embedSessionId(String url, HttpServletRequest request) {
        String tail;
        String head;
        if (url == null || ServletUtils.isSessionIdEmbedded(url)) {
            return url;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return url;
        }
        Matcher matcher = PATTERN_EMBED_SESSIONID.matcher(url);
        if (matcher.find()) {
            head = url.substring(0, matcher.start());
            tail = url.substring(matcher.start());
        } else {
            head = url;
            tail = REPLACEMENT_OMIT_SESSIONID;
        }
        return head + ";jsessionid=" + session.getId() + tail;
    }

    public static String stripParameters(String url) {
        if (url == null) {
            return null;
        }
        Matcher matcher = PATTERN_STRIPPED_URL.matcher(url);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return url;
    }
}

