/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.ymir.Response;
import org.seasar.ymir.util.LogUtils;

public class RequestLoggingFilter
implements Filter {
    private static final Log log_ = LogFactory.getLog(RequestLoggingFilter.class);
    private static final String LF = System.getProperty("line.separator");
    private static final String IND = "  ";
    protected FilterConfig config_ = null;
    protected boolean errorLogging_;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config_ = filterConfig;
        this.errorLogging_ = this.getBooleanParameter(filterConfig, "errorLogging_", true);
    }

    protected boolean getBooleanParameter(FilterConfig filterConfig, String name, boolean defaultValue) {
        String value = filterConfig.getInitParameter(name);
        if (value == null) {
            return defaultValue;
        }
        return BooleanConversionUtil.toPrimitiveBoolean((Object)value);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            String msg = "Request that is Not Http is unsupported: " + servletRequest;
            throw new UnsupportedOperationException(msg);
        }
        if (!(servletResponse instanceof HttpServletResponse)) {
            String msg = "Response that is Not Http is unsupported: " + servletResponse;
            throw new UnsupportedOperationException(msg);
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Long before = null;
        if (log_.isDebugEnabled()) {
            this.before(request, response);
            before = System.currentTimeMillis();
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (RuntimeException e) {
            this.logError("RuntimeException occurred at " + this.gerServletPath((ServletRequest)request), e);
            throw e;
        }
        catch (ServletException e) {
            this.logError("ServletException occurred at " + this.gerServletPath((ServletRequest)request), e.getRootCause());
            throw e;
        }
        catch (IOException e) {
            this.logError("IOException occurred at " + this.gerServletPath((ServletRequest)request), e);
            throw e;
        }
        catch (Error e) {
            this.logError("Error occurred at " + this.gerServletPath((ServletRequest)request), e);
            throw e;
        }
        finally {
            if (log_.isDebugEnabled()) {
                Long after = System.currentTimeMillis();
                this.after(request, response, before, after);
            }
        }
    }

    protected void before(HttpServletRequest request, HttpServletResponse response) {
        StringBuilder sb = new StringBuilder();
        sb.append("* * * * * * * * * * {BEGIN}: " + this.gerServletPath((ServletRequest)request)).append(LF);
        sb.append(IND).append("Request=").append(request.toString().trim()).append(LF);
        sb.append(IND).append("RequestedSessionId=").append(request.getRequestedSessionId()).append(LF);
        HttpSession session = request.getSession(false);
        sb.append(IND).append("Actual session ID=").append(session != null ? session.getId() : "(none)").append(LF);
        sb.append(IND).append("REQUEST_URI=").append(request.getRequestURI());
        sb.append(", SERVLET_PATH=").append(request.getServletPath()).append(LF);
        sb.append(IND).append("CharacterEncoding=" + request.getCharacterEncoding());
        sb.append(", ContentLength=").append(request.getContentLength());
        sb.append(", ContentType=").append(request.getContentType());
        sb.append(", Locale=").append(request.getLocale());
        sb.append(", Locales=");
        Enumeration locales = request.getLocales();
        boolean first = true;
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(locale.toString());
        }
        sb.append(", Scheme=").append(request.getScheme());
        sb.append(", isSecure=").append(request.isSecure()).append(LF);
        sb.append(IND).append("SERVER_PROTOCOL=").append(request.getProtocol());
        sb.append(", REMOTE_ADDR=").append(request.getRemoteAddr());
        sb.append(", REMOTE_HOST=").append(request.getRemoteHost());
        sb.append(", SERVER_NAME=").append(request.getServerName());
        sb.append(", SERVER_PORT=").append(request.getServerPort()).append(LF);
        sb.append(IND).append("ContextPath=").append(request.getContextPath());
        sb.append(", REQUEST_METHOD=").append(request.getMethod());
        sb.append(", PathInfo=").append(request.getPathInfo());
        sb.append(", RemoteUser=").append(request.getRemoteUser()).append(LF);
        sb.append(IND).append("QUERY_STRING=").append(request.getQueryString()).append(LF);
        this.buildRequestHeaders(sb, request);
        this.buildCookies(sb, request);
        this.buildRequestParameters(sb, request);
        this.buildSessionAttributes(sb, request);
        String logString = sb.toString();
        if (logString.endsWith(LF)) {
            logString = logString.substring(0, logString.length() - LF.length());
        }
        log_.debug((Object)logString);
    }

    protected void after(HttpServletRequest request, HttpServletResponse response, Long before, Long after) {
        StringBuilder sb = new StringBuilder();
        sb.append(LF);
        sb.append(IND).append("Response=").append(response.getClass().getName()).append(LF);
        HttpSession session = request.getSession(false);
        sb.append(IND).append("Session ID=").append(session != null ? session.getId() : "(none)").append(LF);
        sb.append(IND).append("CharacterEncoding=").append(response.getCharacterEncoding());
        sb.append(", ContentType=").append(response.getContentType());
        sb.append(", Locale=").append(response.getLocale());
        sb.append(LF);
        this.buildRequestAttributes(sb, request);
        this.buildSessionAttributes(sb, request);
        sb.append("* * * * * * * * * * {END}: ").append(this.gerServletPath((ServletRequest)request));
        sb.append(" [" + this.convertToPerformanceView(after - before) + "]").append(LF);
        sb.append(LF);
        String logString = sb.toString();
        log_.debug((Object)logString);
    }

    protected String gerServletPath(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getServletPath();
        }
        return "";
    }

    protected void buildRequestHeaders(StringBuilder sb, HttpServletRequest request) {
        for (String name : this.toSortedSet(request.getHeaderNames())) {
            String value = request.getHeader(name);
            sb.append(IND);
            sb.append("[header] ").append(name);
            sb.append("=").append(value);
            sb.append(LF);
        }
    }

    protected void buildCookies(StringBuilder sb, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (int i = 0; i < cookies.length; ++i) {
            sb.append(IND);
            sb.append("[cookie] ").append(cookies[i].getName());
            sb.append("=").append(cookies[i].getValue());
            sb.append(LF);
        }
    }

    protected void buildRequestParameters(StringBuilder sb, HttpServletRequest request) {
        for (String name : this.toSortedSet(request.getParameterNames())) {
            sb.append(IND);
            sb.append("[param] ").append(name).append("=");
            String[] values = request.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(values[i]);
            }
            sb.append(LF);
        }
    }

    protected void buildRequestAttributes(StringBuilder sb, HttpServletRequest request) {
        for (String name : this.toSortedSet(request.getAttributeNames())) {
            Object attr = request.getAttribute(name);
            sb.append(IND);
            sb.append("[request] ").append(name).append("=").append(LogUtils.addIndent(this.filterAttribute(attr), IND));
            sb.append(LF);
        }
    }

    protected void buildSessionAttributes(StringBuilder sb, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        for (String name : this.toSortedSet(session.getAttributeNames())) {
            Object attr = session.getAttribute(name);
            sb.append(IND);
            sb.append("[session] ").append(name).append("=").append(LogUtils.addIndent(this.filterAttribute(attr), IND));
            sb.append(LF);
        }
    }

    protected Object filterAttribute(Object attribute) {
        if (attribute instanceof Response) {
            return attribute.getClass().getName() + "@" + System.identityHashCode(attribute);
        }
        return LogUtils.toString(attribute);
    }

    protected void logError(String msg, Throwable e) {
        if (this.errorLogging_) {
            log_.error((Object)msg, e);
        } else {
            log_.debug((Object)msg, e);
        }
    }

    public void destroy() {
        this.config_ = null;
    }

    protected SortedSet toSortedSet(Enumeration enu) {
        TreeSet set = new TreeSet();
        set.addAll(Collections.list(enu));
        return set;
    }

    protected String convertToPerformanceView(long afterMinusBefore) {
        if (afterMinusBefore < 0L) {
            return String.valueOf(afterMinusBefore);
        }
        long sec = afterMinusBefore / 1000L;
        long min = sec / 60L;
        sec %= 60L;
        long mil = afterMinusBefore % 1000L;
        StringBuffer sb = new StringBuffer();
        if (min >= 10L) {
            sb.append(min).append("m");
        } else if (min < 10L && min >= 0L) {
            sb.append("0").append(min).append("m");
        }
        if (sec >= 10L) {
            sb.append(sec).append("s");
        } else if (sec < 10L && sec >= 0L) {
            sb.append("0").append(sec).append("s");
        }
        if (mil >= 100L) {
            sb.append(mil).append("ms");
        } else if (mil < 100L && mil >= 10L) {
            sb.append("0").append(mil).append("ms");
        } else if (mil < 10L && mil >= 0L) {
            sb.append("00").append(mil).append("ms");
        }
        return sb.toString();
    }
}

