/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scope.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import org.seasar.ymir.scope.impl.AbstractServletScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieScope
extends AbstractServletScope {
    @Override
    public Object getAttribute(String name, Class<?> type) {
        if (name == null) {
            return null;
        }
        Cookie[] cookies = this.getRequest().getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!name.equals(cookies[i].getName())) continue;
                if (type.isAssignableFrom(Cookie.class)) {
                    return cookies[i];
                }
                return cookies[i].getValue();
            }
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name == null) {
            return;
        }
        if (value != null && value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                this.addCookie(name, Array.get(value, i));
            }
        } else {
            this.addCookie(name, value);
        }
    }

    protected void addCookie(String name, Object value) {
        Cookie cookie;
        if (value instanceof Cookie) {
            cookie = (Cookie)value;
        } else {
            cookie = new Cookie(name, String.valueOf(value));
            if (value == null) {
                cookie.setMaxAge(0);
            }
        }
        if (cookie.getPath() == null) {
            String path = this.getRequest().getContextPath();
            if (path.length() == 0) {
                path = "/";
            }
            cookie.setPath(path);
        }
        this.getResponse().addCookie(cookie);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        Cookie[] cookies = this.getRequest().getCookies();
        ArrayList<String> list = new ArrayList<String>();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                list.add(cookies[i].getName());
            }
        }
        return list.iterator();
    }
}

