/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.response.scheme.impl;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import org.apache.commons.beanutils.BeanUtils;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.kvasir.util.el.EvaluationException;
import org.seasar.kvasir.util.el.TextTemplateEvaluator;
import org.seasar.kvasir.util.el.VariableResolver;
import org.seasar.kvasir.util.el.impl.SimpleTextTemplateEvaluator;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.Path;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.response.TransitionResponse;
import org.seasar.ymir.response.scheme.Strategy;

public abstract class AbstractTransitionStrategy
implements Strategy {
    private static final String ENCODING = "UTF-8";
    private static final TextTemplateEvaluator evaluator_ = new SimpleTextTemplateEvaluator();

    public Response constructResponse(String path, Object component) {
        TransitionResponse response = this.newResponse();
        response.setPath(this.constructPath(path, component));
        return response;
    }

    public abstract TransitionResponse newResponse();

    protected String constructPath(String path, Object component) {
        if (!this.isRichPathExpressionAvailable()) {
            return path;
        }
        Path p = null;
        int lparen = path.lastIndexOf(40);
        if (lparen >= 0 && path.endsWith(")")) {
            p = new Path(path.substring(0, lparen), this.getCharacterEncoding());
            this.parseFunctionTypeParameters(path.substring(lparen + 1, path.length() - 1), component, p);
        } else {
            int question = path.indexOf(63);
            if (question >= 0) {
                p = new Path(path.substring(0, question), this.getCharacterEncoding());
                if (path.indexOf(61, question + 1) >= 0) {
                    this.parseExpressionTypeParameters(path.substring(question + 1), component, p);
                } else {
                    this.parseSimpleTypeParameters(path.substring(question + 1), component, p);
                }
            }
        }
        if (p != null) {
            return p.asString();
        }
        return path;
    }

    protected boolean isRichPathExpressionAvailable() {
        return PropertyUtils.valueOf((String)YmirContext.getYmir().getApplication().getProperty("core.response.strategy.richPathExpressionAvailable"), (boolean)true);
    }

    String getCharacterEncoding() {
        return ((Request)YmirContext.getYmir().getApplication().getS2Container().getComponent(Request.class)).getCharacterEncoding();
    }

    void parseFunctionTypeParameters(String parameter, Object component, Path path) {
        String[] params = parameter.split(",");
        for (int i = 0; i < params.length; ++i) {
            String name = this.decodeURL(params[i].trim());
            path.addParameter(name, this.getProperty(component, name));
        }
    }

    String getProperty(Object component, String name) {
        if (component != null) {
            try {
                return BeanUtils.getProperty((Object)component, (String)name);
            }
            catch (IllegalAccessException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    void parseExpressionTypeParameters(String parameter, Object component, Path path) {
        ComponentVariableResolver resolver = new ComponentVariableResolver(component);
        String[] params = parameter.split("&");
        for (int i = 0; i < params.length; ++i) {
            int equal = params[i].indexOf(61);
            if (equal < 0) continue;
            try {
                path.addParameter(evaluator_.evaluateAsString(this.decodeURL(params[i].substring(0, equal)), (VariableResolver)resolver), evaluator_.evaluateAsString(this.decodeURL(params[i].substring(equal + 1)), (VariableResolver)resolver));
                continue;
            }
            catch (EvaluationException ex) {
                throw new IllegalClientCodeRuntimeException("Expression type parameter's format is wrong: " + parameter, ex);
            }
        }
    }

    void parseSimpleTypeParameters(String parameter, Object component, Path path) {
        String[] params = parameter.split("&");
        for (int i = 0; i < params.length; ++i) {
            String name = this.decodeURL(params[i]);
            path.addParameter(name, this.getProperty(component, name));
        }
    }

    String decodeURL(String string) {
        try {
            return URLDecoder.decode(string, ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private class ComponentVariableResolver
    implements VariableResolver {
        private Object component_;

        public ComponentVariableResolver(Object component) {
            this.component_ = component;
        }

        public Object getValue(Object key) {
            if (key instanceof String) {
                return AbstractTransitionStrategy.this.getProperty(this.component_, (String)key);
            }
            return null;
        }
    }
}

