/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.converter.impl;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.converter.PropertyHandler;
import org.seasar.ymir.converter.TypeConversionException;
import org.seasar.ymir.converter.TypeConversionManager;
import org.seasar.ymir.converter.TypeConverter;
import org.seasar.ymir.converter.impl.BeanUtilsPropertyHandler;
import org.seasar.ymir.hotdeploy.HotdeployManager;
import org.seasar.ymir.hotdeploy.impl.AbstractHotdeployEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConversionManagerImpl
implements TypeConversionManager {
    private static final String TRUE_NUMBER = "1";
    private static final String FALSE_NUMBER = "0";
    private HotdeployManager hotdeployManager_;
    private final Map<Class<?>, TypeConverter<?>> typeConverterMap_ = new HashMap();
    private final PropertyUtilsBean propertyUtilsBean_ = this.prepare(this.newPropertyUtilsBean());
    private static final Log log_ = LogFactory.getLog(TypeConversionManagerImpl.class);

    protected PropertyUtilsBean newPropertyUtilsBean() {
        return new PropertyUtilsBean();
    }

    protected PropertyUtilsBean prepare(PropertyUtilsBean propertyUtilsBean) {
        return propertyUtilsBean;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setHotdeployManager(HotdeployManager hotdeployManager) {
        this.hotdeployManager_ = hotdeployManager;
        this.hotdeployManager_.addEventListener(new AbstractHotdeployEventListener(){

            public void stop() {
                TypeConversionManagerImpl.this.propertyUtilsBean_.clearDescriptors();
            }
        });
    }

    @Binding(value="@org.seasar.ymir.util.ContainerUtils@findAllComponents(container, @org.seasar.ymir.converter.TypeConverter@class)", bindingType=BindingType.MUST)
    public void setTypeConverters(TypeConverter<?>[] typeConverters) {
        for (int i = 0; i < typeConverters.length; ++i) {
            this.register(typeConverters[i]);
        }
    }

    public void register(TypeConverter<?> typeConverter) {
        Class<?> type = typeConverter.getType();
        this.typeConverterMap_.put(type, typeConverter);
    }

    @Override
    public <T> T convert(Object value, Class<T> type) {
        return this.convert(value, type, null);
    }

    @Override
    public <T> T convert(Object value, Class<T> type, Annotation[] hint) {
        Class<Object> typeComponentType;
        if (hint == null) {
            hint = new Annotation[]{};
        }
        if (value == null) {
            return this.convertStringTo(null, type, hint);
        }
        Class<?> clazz = value.getClass();
        boolean isArray = clazz.isArray();
        boolean typeIsArray = type.isArray();
        Class<Object> clazz2 = typeComponentType = typeIsArray ? type.getComponentType() : type;
        if (isArray) {
            if (typeIsArray) {
                Object[] converted = (Object[])Array.newInstance(typeComponentType, Array.getLength(value));
                for (int i = 0; i < converted.length; ++i) {
                    converted[i] = this.convertComponent(Array.get(value, i), typeComponentType, hint);
                }
                return (T)converted;
            }
            if (Array.getLength(value) > 0) {
                return this.convertComponent(Array.get(value, 0), typeComponentType, hint);
            }
            return this.convertComponent(null, typeComponentType, hint);
        }
        if (typeIsArray) {
            Object[] converted = (Object[])Array.newInstance(typeComponentType, 1);
            converted[0] = this.convertComponent(value, typeComponentType, hint);
            return (T)converted;
        }
        return this.convertComponent(value, typeComponentType, hint);
    }

    @Override
    public <T> T tryToConvert(Object value, Class<T> type) throws TypeConversionException {
        return this.tryToConvert(value, type, null);
    }

    @Override
    public <T> T tryToConvert(Object value, Class<T> type, Annotation[] hint) throws TypeConversionException {
        Class<Object> typeComponentType;
        if (hint == null) {
            hint = new Annotation[]{};
        }
        if (value == null) {
            return this.tryToConvertStringTo(null, type, hint);
        }
        Class<?> clazz = value.getClass();
        boolean isArray = clazz.isArray();
        boolean typeIsArray = type.isArray();
        Class<Object> clazz2 = typeComponentType = typeIsArray ? type.getComponentType() : type;
        if (isArray) {
            if (typeIsArray) {
                Object[] converted = (Object[])Array.newInstance(typeComponentType, Array.getLength(value));
                for (int i = 0; i < converted.length; ++i) {
                    converted[i] = this.tryToConvertComponent(Array.get(value, i), typeComponentType, hint);
                }
                return (T)converted;
            }
            if (Array.getLength(value) > 0) {
                return this.tryToConvertComponent(Array.get(value, 0), typeComponentType, hint);
            }
            return this.tryToConvertComponent(null, typeComponentType, hint);
        }
        if (typeIsArray) {
            Object[] converted = (Object[])Array.newInstance(typeComponentType, 1);
            converted[0] = this.tryToConvertComponent(value, typeComponentType, hint);
            return (T)converted;
        }
        return this.tryToConvertComponent(value, typeComponentType, hint);
    }

    <T> T convertComponent(Object value, Class<T> componentType, Annotation[] hint) {
        if (value == null || value instanceof String) {
            return this.convertStringTo((String)value, componentType, hint);
        }
        if (componentType.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return this.convertStringTo(this.convertToString(value, hint), componentType, hint);
    }

    <T> T tryToConvertComponent(Object value, Class<T> componentType, Annotation[] hint) throws TypeConversionException {
        if (value == null || value instanceof String) {
            return this.tryToConvertStringTo((String)value, componentType, hint);
        }
        if (componentType.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return this.tryToConvertStringTo(this.convertToString(value, hint), componentType, hint);
    }

    protected <T> T convertStringTo(String value, Class<T> type, Annotation[] hint) {
        TypeConverter<T> converter = this.getTypeConverter(type);
        if (converter == null) {
            return null;
        }
        return converter.convert(value, hint);
    }

    protected <T> T tryToConvertStringTo(String value, Class<T> type, Annotation[] hint) throws TypeConversionException {
        TypeConverter<T> converter = this.getTypeConverter(type);
        if (converter == null) {
            return null;
        }
        return converter.tryToConvert(value, hint);
    }

    protected String adjust(String value, Class<?> type) {
        if (this.isNumericType(type)) {
            if ("true".equals(value)) {
                return TRUE_NUMBER;
            }
            if ("false".equals(value)) {
                return FALSE_NUMBER;
            }
        }
        return value;
    }

    protected boolean isNumericType(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE;
    }

    protected String convertToString(Object value, Annotation[] hint) {
        TypeConverter<?> converter = this.getTypeConverter(value.getClass());
        if (converter == null) {
            TypeConverter<String> stringConverter = this.getTypeConverter(String.class);
            if (stringConverter == null) {
                return value != null ? value.toString() : null;
            }
            return stringConverter.convert(value, hint);
        }
        return converter.convertToString(value, hint);
    }

    <T> TypeConverter<T> getTypeConverter(Class<T> type) {
        return this.typeConverterMap_.get(type);
    }

    @Override
    public PropertyHandler getPropertyHandler(Object bean, String name) {
        PropertyDescriptor pd;
        block9: {
            pd = null;
            try {
                pd = this.propertyUtilsBean_.getPropertyDescriptor(bean, name);
            }
            catch (IllegalArgumentException ex) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("Can't get PropertyDescriptor: beanClass=" + bean.getClass() + ", name=" + name), (Throwable)ex);
                }
            }
            catch (IllegalAccessException ex) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("Can't get PropertyDescriptor: beanClass=" + bean.getClass() + ", name=" + name), (Throwable)ex);
                }
            }
            catch (InvocationTargetException ex) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("Can't get PropertyDescriptor: beanClass=" + bean.getClass() + ", name=" + name), (Throwable)ex);
                }
            }
            catch (NoSuchMethodException ex) {
                if (!log_.isDebugEnabled()) break block9;
                log_.debug((Object)("Can't get PropertyDescriptor: beanClass=" + bean.getClass() + ", name=" + name), (Throwable)ex);
            }
        }
        if (pd == null) {
            return null;
        }
        return new BeanUtilsPropertyHandler(this.propertyUtilsBean_, pd, bean, name);
    }
}

