/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.convention;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.cms.pluggable.impl.PluggableNamingConventionImpl;
import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.creator.ComponentCreatorImpl;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.StringUtil;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.IllegalClientCodeRuntimeException;

public class YmirNamingConvention
extends PluggableNamingConventionImpl {
    private static final char PACKAGE_SEPARATOR = '_';
    private static final String PACKAGE_SEPARATOR_STR = "_";
    public static final String SUFFIX_EXCEPTIONHANDLER = "Handler";
    public static final String SUFFIX_CONSTRAINT = "Constraint";
    public static final String APPKEY_NAMINGCONVENTION_HOTDEPLOYABLEONLYPACKAGEFORCREATOR = "namingConvention.hotdeployableOnlyPackageForCreator";
    private boolean hotdeployableOnlyPackageForCreator_;
    private Set<String> creatorPackageNameSet_ = new HashSet<String>();
    private String[] targetPackageNames_ = new String[0];
    private static final Log log_ = LogFactory.getLog(YmirNamingConvention.class);

    public void setHotdeployableOnlyPackageForCreator(boolean hotdeployableOnlyPackageForCreator) {
        this.hotdeployableOnlyPackageForCreator_ = hotdeployableOnlyPackageForCreator;
    }

    public void setCreators(ComponentCreator[] creators) {
        this.creatorPackageNameSet_.clear();
        for (ComponentCreator creator : creators) {
            if (!(creator instanceof ComponentCreatorImpl)) {
                log_.warn((Object)("Can't get nameSuffix from ComponentCreator: " + creator.getClass()));
            }
            this.creatorPackageNameSet_.add(this.fromSuffixToPackageName(((ComponentCreatorImpl)creator).getNameSuffix()));
        }
        this.adjustTargetPackageNames();
    }

    public void addRootPackageName(String rootPackageName) {
        for (String name : PropertyUtils.toLines((String)rootPackageName)) {
            super.addRootPackageName(name);
        }
        this.adjustTargetPackageNames();
    }

    public void setSubApplicationRootPackageName(String subApplicationRootPackageName) {
        super.setSubApplicationRootPackageName(subApplicationRootPackageName);
        this.adjustTargetPackageNames();
    }

    void adjustTargetPackageNames() {
        ArrayList<String> targetPackageNameList = new ArrayList<String>();
        for (String rootPackageName : this.getRootPackageNames()) {
            targetPackageNameList.add(rootPackageName + "." + this.getSubApplicationRootPackageName() + ".");
            for (String creatorPackageName : this.creatorPackageNameSet_) {
                targetPackageNameList.add(rootPackageName + "." + creatorPackageName + ".");
            }
        }
        this.targetPackageNames_ = targetPackageNameList.toArray(new String[0]);
    }

    public boolean isHotdeployableOnlyPackageForCreator() {
        return this.hotdeployableOnlyPackageForCreator_;
    }

    public String fromComponentNameToPartOfClassName(String componentName) {
        if (componentName == null) {
            throw new EmptyRuntimeException("componentName");
        }
        String[] names = this.split(componentName);
        StringBuilder buf = new StringBuilder(50);
        for (int i = 0; i < names.length; ++i) {
            if (i == names.length - 1) {
                buf.append(StringUtil.capitalize((String)names[i]));
                continue;
            }
            buf.append(names[i]).append(".");
        }
        return buf.toString();
    }

    String[] split(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int prefixLength = 0;
        boolean separatorDetected = true;
        StringTokenizer st = new StringTokenizer(str, PACKAGE_SEPARATOR_STR, true);
        while (st.hasMoreTokens()) {
            String tkn = st.nextToken();
            if (separatorDetected) {
                if (PACKAGE_SEPARATOR_STR.equals(tkn)) {
                    ++prefixLength;
                    continue;
                }
                separatorDetected = false;
                if (prefixLength > 0) {
                    StringBuilder sb = new StringBuilder(prefixLength + tkn.length());
                    for (int i = 0; i < prefixLength; ++i) {
                        sb.append('_');
                    }
                    sb.append(tkn);
                    tkn = sb.toString();
                    prefixLength = 0;
                }
                list.add(tkn);
                continue;
            }
            separatorDetected = true;
        }
        if (prefixLength > 0) {
            StringBuilder sb = new StringBuilder(prefixLength);
            for (int i = 0; i < prefixLength; ++i) {
                sb.append('_');
            }
            list.add(sb.toString());
        }
        return list.toArray(new String[0]);
    }

    public void addIgnorePackageName(String ignorePackageName) {
        String[] ignorePackageNames = PropertyUtils.toLines((String)ignorePackageName);
        String[] rootPackageNames = this.getRootPackageNames();
        if (rootPackageNames == null || rootPackageNames.length == 0) {
            throw new IllegalClientCodeRuntimeException("Must be set rootPackageName before adding ignorePackageName");
        }
        for (String name : ignorePackageNames) {
            String absoluteName = name.startsWith(".") ? rootPackageNames[0] + name : name;
            super.addIgnorePackageName(absoluteName);
        }
    }

    public boolean isTargetClassName(String className) {
        if (!this.hotdeployableOnlyPackageForCreator_) {
            return super.isTargetClassName(className);
        }
        for (int i = 0; i < this.targetPackageNames_.length; ++i) {
            if (!className.startsWith(this.targetPackageNames_[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isHotdeployTargetClassName(String className) {
        return this.isTargetClassName(className);
    }

    public String[] getTargetPackageNames() {
        return this.targetPackageNames_;
    }
}

