/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.render;

import java.io.Serializable;
import java.util.ArrayList;
import org.seasar.ymir.render.PageNumber;

public class Paging
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CLASSNAME_PAGINGRESULTBEAN = "org.seasar.dbflute.cbean.PagingResultBean";
    private static final String METHODNAME_GETALLRECORDCOUNT = "getAllRecordCount";
    private static final String METHODNAME_GETALLPAGECOUNT = "getAllPageCount";
    private static final String METHODNAME_GETPAGESIZE = "getPageSize";
    private static final String METHODNAME_GETCURRENTPAGENUMBER = "getCurrentPageNumber";
    private static final String METHODNAME_GETPAGERANGESIZE = "getPageRangeSize";
    private int allRecordCount_;
    private int allPageCount_;
    private int pageSize_;
    private int currentPageNumber_;
    private boolean existPrePage_;
    private boolean existNextPage_;
    private int pageRangeSize_;
    private PageNumber[] pageNumbers_;

    public Paging() {
    }

    public Paging(int allRecordCount, int allPageCount, int pageSize, int currentPageNumber, int pageRangeSize) {
        this.initialize(allRecordCount, allPageCount, pageSize, currentPageNumber, pageRangeSize);
    }

    public void initialize(int allRecordCount, int allPageCount, int pageSize, int currentPageNumber, int pageRangeSize) {
        this.allRecordCount_ = allRecordCount;
        this.allPageCount_ = allPageCount;
        this.pageSize_ = pageSize;
        this.currentPageNumber_ = currentPageNumber;
        this.existPrePage_ = currentPageNumber > 1;
        this.existNextPage_ = currentPageNumber < allPageCount;
        this.pageRangeSize_ = pageRangeSize;
        this.pageNumbers_ = this.updatePageNumbers();
    }

    public Paging(Object pagingResultBean) {
        Class<?> beanClass = pagingResultBean.getClass();
        if (!beanClass.getName().equals(CLASSNAME_PAGINGRESULTBEAN)) {
            throw new IllegalArgumentException("Must be an instnaceof org.seasar.dbflute.cbean.PagingResultBean class, but: " + beanClass.getName());
        }
        try {
            this.initialize((Integer)beanClass.getMethod(METHODNAME_GETALLRECORDCOUNT, new Class[0]).invoke(pagingResultBean, new Object[0]), (Integer)beanClass.getMethod(METHODNAME_GETALLPAGECOUNT, new Class[0]).invoke(pagingResultBean, new Object[0]), (Integer)beanClass.getMethod(METHODNAME_GETPAGESIZE, new Class[0]).invoke(pagingResultBean, new Object[0]), (Integer)beanClass.getMethod(METHODNAME_GETCURRENTPAGENUMBER, new Class[0]).invoke(pagingResultBean, new Object[0]), (Integer)beanClass.getMethod(METHODNAME_GETPAGERANGESIZE, new Class[0]).invoke(pagingResultBean, new Object[0]));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private PageNumber[] updatePageNumbers() {
        int endPageNumber;
        ArrayList<PageNumber> pageNumbers = new ArrayList<PageNumber>();
        int startPageNumber = this.currentPageNumber_ - this.pageRangeSize_;
        if (startPageNumber < 1) {
            startPageNumber = 1;
        }
        if ((endPageNumber = this.currentPageNumber_ + this.pageRangeSize_) > this.allPageCount_) {
            endPageNumber = this.allPageCount_;
        }
        for (int pageNumber = startPageNumber; pageNumber <= endPageNumber; ++pageNumber) {
            pageNumbers.add(new PageNumber(pageNumber, pageNumber == this.currentPageNumber_));
        }
        return pageNumbers.toArray(new PageNumber[0]);
    }

    public int getAllRecordCount() {
        return this.allRecordCount_;
    }

    public int getAllPageCount() {
        return this.allPageCount_;
    }

    public int getPageSize() {
        return this.pageSize_;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber_;
    }

    public int getPrePageNumber() {
        return this.currentPageNumber_ - 1;
    }

    public int getNextPageNumber() {
        return this.currentPageNumber_ + 1;
    }

    public boolean isExistPrePage() {
        return this.existPrePage_;
    }

    public boolean isExistNextPage() {
        return this.existNextPage_;
    }

    public int getPageRangeSize() {
        return this.pageRangeSize_;
    }

    public PageNumber[] getPageNumbers() {
        return this.pageNumbers_;
    }
}

