/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.annotation.handler.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.annotation.SuppressInheritance;
import org.seasar.ymir.annotation.handler.AnnotationElements;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.annotation.handler.impl.AnnotationExistenceChecker;
import org.seasar.ymir.annotation.handler.impl.AnnotationGatherer;
import org.seasar.ymir.annotation.handler.impl.MarkedAnnotationGatherer;
import org.seasar.ymir.cache.CacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandlerImpl
implements AnnotationHandler {
    private Map<Key, Boolean> presentMap_;
    private Map<Key, Annotation[]> annotationsMap_;
    private Map<Key, Annotation[]> markedAnnotationsMap_;
    private boolean inherited_ = true;

    @Binding(bindingType=BindingType.MUST)
    public void setCacheManager(CacheManager cacheManager) {
        this.presentMap_ = cacheManager.newMap();
        this.annotationsMap_ = cacheManager.newMap();
        this.markedAnnotationsMap_ = cacheManager.newMap();
    }

    public boolean isInherited() {
        return this.inherited_;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setInherited(boolean inherited) {
        this.inherited_ = inherited;
    }

    @Override
    public boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        if (element == null) {
            return false;
        }
        Key key = new Key(element, annotationClass);
        Boolean present = this.presentMap_.get(key);
        if (present == null) {
            present = this.isAnnotationPresent0(element, annotationClass);
            this.presentMap_.put(key, present);
        }
        return present;
    }

    protected boolean isAnnotationPresent0(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        AnnotationExistenceChecker checker = new AnnotationExistenceChecker(annotationClass);
        for (Annotation annotation : this.getAnnotations(element)) {
            if (AnnotationElements.newInstance(annotation).accept(checker, new Object[0]) == null) continue;
            return true;
        }
        return false;
    }

    protected Annotation[] getAnnotations(AnnotatedElement element) {
        if (this.inherited_) {
            if (element instanceof Method) {
                Method method = (Method)element;
                String name = method.getName();
                Class<?>[] parameterTypes = method.getParameterTypes();
                Class<?> clazz = method.getDeclaringClass();
                LinkedHashMap<Class<? extends Annotation>, Annotation> map = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
                while (true) {
                    if (method != null) {
                        for (Annotation annotation : method.getAnnotations()) {
                            if (map.containsKey(annotation.annotationType())) continue;
                            map.put(annotation.annotationType(), annotation);
                        }
                        if (method.isAnnotationPresent(SuppressInheritance.class)) break;
                    }
                    if ((clazz = clazz.getSuperclass()) == Object.class || clazz == null) break;
                    try {
                        method = clazz.getDeclaredMethod(name, parameterTypes);
                    }
                    catch (NoSuchMethodException ex) {
                        method = null;
                    }
                }
                return map.values().toArray(new Annotation[0]);
            }
            if (element instanceof Class) {
                Class clazz = (Class)element;
                LinkedHashMap<Class<? extends Annotation>, Annotation> map = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
                do {
                    for (Annotation annotation : clazz.getAnnotations()) {
                        if (map.containsKey(annotation.annotationType())) continue;
                        map.put(annotation.annotationType(), annotation);
                    }
                } while (!clazz.isAnnotationPresent(SuppressInheritance.class) && (clazz = clazz.getSuperclass()) != Object.class && clazz != null);
                return map.values().toArray(new Annotation[0]);
            }
        }
        return element.getAnnotations();
    }

    @Override
    public <T extends Annotation> T[] getAnnotations(AnnotatedElement element, Class<T> annotationClass) {
        if (element == null) {
            return (Annotation[])Array.newInstance(annotationClass, 0);
        }
        Key key = new Key(element, annotationClass);
        Annotation[] annotations = this.annotationsMap_.get(key);
        if (annotations == null) {
            annotations = this.getAnnotations0(element, annotationClass);
            this.annotationsMap_.put(key, annotations);
        }
        return annotations;
    }

    protected <T extends Annotation> T[] getAnnotations0(AnnotatedElement element, Class<T> annotationClass) {
        return this.getAnnotations0(this.getAnnotations(element), annotationClass);
    }

    protected <T extends Annotation> T[] getAnnotations0(Annotation[] annotations, Class<T> annotationClass) {
        AnnotationGatherer gatherer = new AnnotationGatherer(annotationClass);
        for (Annotation annotation : annotations) {
            AnnotationElements.newInstance(annotation).accept(gatherer, new Object[0]);
        }
        return gatherer.getAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annotationClass) {
        Annotation[] annotations = this.getAnnotations(element, annotationClass);
        if (annotations.length == 0) {
            return null;
        }
        if (annotations.length == 1) {
            return (T)annotations[0];
        }
        throw new IllegalStateException("Multiple annotations found: element=" + element + ", annotationClass=" + annotationClass);
    }

    @Override
    public Annotation[] getMarkedAnnotations(AnnotatedElement element, Class<? extends Annotation> metaAnnotationClass) {
        if (element == null) {
            return new Annotation[0];
        }
        Key key = new Key(element, metaAnnotationClass);
        Annotation[] markedAnnotations = this.markedAnnotationsMap_.get(key);
        if (markedAnnotations == null) {
            markedAnnotations = this.getMarkedAnnotations0(element, metaAnnotationClass);
            this.markedAnnotationsMap_.put(key, markedAnnotations);
        }
        return markedAnnotations;
    }

    protected Annotation[] getMarkedAnnotations0(AnnotatedElement element, Class<? extends Annotation> metaAnnotationClass) {
        return this.getMarkedAnnotations0(this.getAnnotations(element), metaAnnotationClass);
    }

    protected Annotation[] getMarkedAnnotations0(Annotation[] annotations, Class<? extends Annotation> metaAnnotationClass) {
        MarkedAnnotationGatherer gatherer = new MarkedAnnotationGatherer(metaAnnotationClass);
        for (Annotation annotation : annotations) {
            AnnotationElements.newInstance(annotation).accept(gatherer, new Object[0]);
        }
        return gatherer.getAnnotations();
    }

    @Override
    public Annotation[] getMarkedAnnotations(Class<? extends Annotation> metaAnnotationClass, Annotation ... annotations) {
        return this.getMarkedAnnotations0(annotations, metaAnnotationClass);
    }

    @Override
    public <T extends Annotation> T[] getParameterAnnotations(Method method, int index, Class<T> annotationClass) {
        if (method == null) {
            return (Annotation[])Array.newInstance(annotationClass, 0);
        }
        Key key = new Key(method, index, annotationClass);
        Annotation[] annotations = this.annotationsMap_.get(key);
        if (annotations == null) {
            annotations = this.getAnnotations0(method.getParameterAnnotations()[index], annotationClass);
            this.annotationsMap_.put(key, annotations);
        }
        return annotations;
    }

    @Override
    public Annotation[] getMarkedParameterAnnotations(Method method, int index, Class<? extends Annotation> metaAnnotationClass) {
        if (method == null) {
            return new Annotation[0];
        }
        Key key = new Key(method, index, metaAnnotationClass);
        Annotation[] markedAnnotations = this.markedAnnotationsMap_.get(key);
        if (markedAnnotations == null) {
            markedAnnotations = this.getMarkedAnnotations0(method.getParameterAnnotations()[index], metaAnnotationClass);
            this.markedAnnotationsMap_.put(key, markedAnnotations);
        }
        return markedAnnotations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Key {
        private AnnotatedElement element_;
        private int index_;
        private Class<? extends Annotation> annotationType_;

        public Key(AnnotatedElement element, Class<? extends Annotation> annotationType) {
            this(element, -1, annotationType);
        }

        public Key(AnnotatedElement element, int index, Class<? extends Annotation> annotationType) {
            this.element_ = element;
            this.index_ = index;
            this.annotationType_ = annotationType;
        }

        public int hashCode() {
            return this.element_.hashCode() + this.index_ + this.annotationType_.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Key o = (Key)obj;
            return o.element_ == this.element_ && o.index_ == this.index_ && o.annotationType_ == this.annotationType_;
        }

        public String toString() {
            return "(" + this.element_ + ", " + this.index_ + ", " + this.annotationType_ + ")";
        }
    }
}

