/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.response.constructor.impl;

import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.Response;
import org.seasar.ymir.response.VoidResponse;
import org.seasar.ymir.response.constructor.ResponseConstructor;
import org.seasar.ymir.response.scheme.Strategy;
import org.seasar.ymir.response.scheme.StrategySelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringResponseConstructor
implements ResponseConstructor<String> {
    private StrategySelector strategySelector_;

    @Override
    public Class<String> getTargetClass() {
        return String.class;
    }

    @Override
    public Response constructResponse(Object page, String returnValue) {
        String path;
        String scheme;
        if (returnValue == null) {
            return VoidResponse.INSTANCE;
        }
        int colon = returnValue.indexOf(58);
        if (colon < 0) {
            scheme = "forward";
            path = returnValue;
        } else {
            scheme = returnValue.substring(0, colon);
            path = returnValue.substring(colon + 1);
        }
        Strategy strategy = this.strategySelector_.getStrategy(scheme);
        if (strategy == null) {
            throw new IllegalClientCodeRuntimeException("Unknown scheme '" + scheme + "' is specified: " + returnValue);
        }
        return strategy.constructResponse(path, page);
    }

    public void setStrategySelector(StrategySelector strategySelector) {
        this.strategySelector_ = strategySelector;
    }
}

