/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.response.scheme.impl;

import java.io.InputStream;
import org.seasar.ymir.Response;
import org.seasar.ymir.impl.AsIsInputStreamFactory;
import org.seasar.ymir.mime.MimeTypeDetector;
import org.seasar.ymir.response.SelfContainedResponse;
import org.seasar.ymir.response.scheme.Strategy;

public class ResourceStrategy
implements Strategy {
    public static final String SCHEME = "resource";
    private MimeTypeDetector detector_;

    public void setMimeTypeDetector(MimeTypeDetector detector) {
        this.detector_ = detector;
    }

    public String getScheme() {
        return SCHEME;
    }

    public Response constructResponse(String path, Object component) {
        String mimeType;
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (in == null) {
            throw new IllegalArgumentException("Resource does not exist: path=" + path + ", classLoader=" + Thread.currentThread().getContextClassLoader());
        }
        String contentType = "application/octet-stream";
        if (this.detector_ != null && (mimeType = this.detector_.getMimeType(path)) != null) {
            contentType = mimeType.startsWith("text/") ? mimeType + "; charset=UTF-8" : mimeType;
        }
        return new SelfContainedResponse(new AsIsInputStreamFactory(in), contentType);
    }
}

