/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.converter.impl;

import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.ymir.converter.TypeConversionException;
import org.seasar.ymir.converter.impl.DateConverterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateConverter
extends DateConverterBase<java.sql.Date> {
    public static final String PATTERN = "yyyy-MM-dd";

    public SqlDateConverter() {
        this.type_ = java.sql.Date.class;
        this.pattern_ = PATTERN;
    }

    @Override
    protected java.sql.Date doConvert(Object value, Annotation[] hint) throws TypeConversionException {
        if (value instanceof Number) {
            return new java.sql.Date(((Number)value).longValue());
        }
        if (value instanceof Date) {
            return new java.sql.Date(((Date)value).getTime());
        }
        try {
            return new java.sql.Date(new SimpleDateFormat(this.getPattern(hint)).parse(value.toString()).getTime());
        }
        catch (Exception ex) {
            throw new TypeConversionException(ex, value, this.getType());
        }
    }
}

