/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.scope;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.ComponentMetaDataFactory;
import org.seasar.ymir.Dispatch;
import org.seasar.ymir.Dispatcher;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.PageComponentVisitor;
import org.seasar.ymir.Phase;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.impl.PageComponentImpl;
import org.seasar.ymir.impl.VisitorForInvoking;
import org.seasar.ymir.interceptor.impl.AbstractYmirProcessInterceptor;
import org.seasar.ymir.scope.ScopeManager;
import org.seasar.ymir.util.ClassUtils;

public class ScopeInterceptor
extends AbstractYmirProcessInterceptor {
    private ActionManager actionManager_;
    private ComponentMetaDataFactory componentMetaDataFactory_;
    private ScopeManager scopeManager_;
    private PageComponentVisitor<?> visitorForInvokingInPhase_;
    private PageComponentVisitor<?> visitorForInjecting_ = new VisitorForInjecting();
    private PageComponentVisitor<?> visitorForPopulating_ = new VisitorForPopulating();
    private PageComponentVisitor<?> visitorForOutjecting_ = new VisitorForOutjecting();
    private ThreadLocal<Boolean> injected_ = new ThreadLocal();
    private static final Log log_ = LogFactory.getLog(ScopeInterceptor.class);

    @Binding(bindingType=BindingType.MUST)
    public void setActionManager(ActionManager actionManager) {
        this.actionManager_ = actionManager;
        this.initPageComponentVisitor();
    }

    @Binding(bindingType=BindingType.MUST)
    public void setComponentMetaDataFactory(ComponentMetaDataFactory componentMetaDataFactory) {
        this.componentMetaDataFactory_ = componentMetaDataFactory;
        this.initPageComponentVisitor();
    }

    @Binding(bindingType=BindingType.MUST)
    public void setScopeManager(ScopeManager scopeManager) {
        this.scopeManager_ = scopeManager;
    }

    void initPageComponentVisitor() {
        if (this.actionManager_ == null || this.componentMetaDataFactory_ == null) {
            return;
        }
        this.visitorForInvokingInPhase_ = new VisitorForInvoking(this.actionManager_, this.componentMetaDataFactory_);
    }

    boolean isInjected() {
        Boolean injected = this.injected_.get();
        return injected != null && injected != false;
    }

    void setInjected(boolean injected) {
        if (injected) {
            this.injected_.set(Boolean.TRUE);
        } else {
            this.injected_.set(null);
        }
    }

    public void enteringDispatch(Request request, String path, Dispatcher dispatcher) {
        this.setInjected(false);
    }

    public Action actionInvoking(Request request, Action action) {
        Dispatch dispatch = request.getCurrentDispatch();
        PageComponent pageComponent = dispatch.getPageComponent();
        String actionName = dispatch.getActionName();
        pageComponent.accept(this.visitorForInjecting_, actionName);
        pageComponent.accept(this.visitorForInvokingInPhase_, new Object[]{Phase.OBJECT_INJECTED, actionName});
        pageComponent.accept(this.visitorForPopulating_, actionName);
        pageComponent.accept(this.visitorForInvokingInPhase_, new Object[]{Phase.OBJECT_POPULATED, actionName});
        this.setInjected(true);
        return action;
    }

    public Response responseCreated(Request request, Response response) {
        PageComponent pageComponent = request.getCurrentDispatch().getPageComponent();
        if (pageComponent != null) {
            pageComponent.accept(this.visitorForOutjecting_, request.getCurrentDispatch().getActionName());
        }
        return response;
    }

    public Action exceptionHandlerActionInvoking(Request request, Action action, boolean global) {
        if (global) {
            Object handler = action.getTarget();
            PageComponentImpl pageComponent = new PageComponentImpl(handler, handler.getClass());
            pageComponent.accept(this.visitorForInjecting_, new Object[0]);
            pageComponent.accept(this.visitorForPopulating_, new Object[0]);
        } else if (!this.isInjected()) {
            PageComponent pageComponent = request.getCurrentDispatch().getPageComponent();
            if (pageComponent == null) {
                Object handler = action.getTarget();
                pageComponent = new PageComponentImpl(handler, handler.getClass());
            }
            String actionName = request.getCurrentDispatch().getActionName();
            pageComponent.accept(this.visitorForInjecting_, actionName);
            pageComponent.accept(this.visitorForPopulating_, actionName);
        }
        return action;
    }

    public Response responseCreatedByExceptionHandler(Request request, Response response, Object handler, boolean global) {
        if (global) {
            PageComponentImpl pageComponent = new PageComponentImpl(handler, handler.getClass());
            pageComponent.accept(this.visitorForOutjecting_, new Object[0]);
        }
        return response;
    }

    public void leftDispatch(Request request) {
        this.setInjected(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VisitorForOutjecting
    extends PageComponentVisitor<Object> {
        VisitorForOutjecting() {
        }

        @Override
        public Object process(PageComponent pageComponent, Object ... parameters) {
            String actionName;
            String string = actionName = parameters.length >= 1 ? (String)parameters[0] : null;
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("Outjection from " + ClassUtils.getPrettyName(pageComponent.getPageClass()) + " start"));
            }
            ScopeInterceptor.this.scopeManager_.outjectScopeAttributes(pageComponent, actionName);
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("Outjection from " + ClassUtils.getPrettyName(pageComponent.getPageClass()) + " end"));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VisitorForPopulating
    extends PageComponentVisitor<Object> {
        VisitorForPopulating() {
        }

        @Override
        public Object process(PageComponent pageComponent, Object ... parameters) {
            String actionName;
            String string = actionName = parameters.length >= 1 ? (String)parameters[0] : null;
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("Population to " + ClassUtils.getPrettyName(pageComponent.getPageClass()) + " start"));
            }
            ScopeInterceptor.this.scopeManager_.populateScopeAttributes(pageComponent, actionName);
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("Population to " + ClassUtils.getPrettyName(pageComponent.getPageClass()) + " end"));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VisitorForInjecting
    extends PageComponentVisitor<Object> {
        VisitorForInjecting() {
        }

        @Override
        public Object process(PageComponent pageComponent, Object ... parameters) {
            String actionName;
            String string = actionName = parameters.length >= 1 ? (String)parameters[0] : null;
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("Injection to " + ClassUtils.getPrettyName(pageComponent.getPageClass()) + " start"));
            }
            ScopeInterceptor.this.scopeManager_.injectScopeAttributes(pageComponent, actionName);
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("Injection to " + ClassUtils.getPrettyName(pageComponent.getPageClass()) + " end"));
            }
            return null;
        }
    }
}

