/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.converter.impl;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.seasar.ymir.converter.PropertyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtilsPropertyHandler
implements PropertyHandler {
    private static final String INDEXED_DELIM2 = "]";
    private static final String MAPPED_DELIM2 = ")";
    private PropertyUtilsBean propertyUtilsBean_;
    private PropertyDescriptor propertyDescriptor_;
    private Object bean_;
    private String name_;
    private boolean indexed_;
    private boolean mapped_;
    private Class<?> propertyType;

    public BeanUtilsPropertyHandler(PropertyUtilsBean propertyUtilsBean, PropertyDescriptor propertyDescriptor, Object bean, String name) {
        Method method;
        Class<?> type;
        this.propertyUtilsBean_ = propertyUtilsBean;
        this.propertyDescriptor_ = propertyDescriptor;
        this.bean_ = bean;
        this.name_ = name;
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            this.indexed_ = true;
        } else if (propertyDescriptor instanceof MappedPropertyDescriptor) {
            this.mapped_ = true;
        } else if (name.endsWith(INDEXED_DELIM2)) {
            Method method2;
            Class<?> type2 = propertyDescriptor.getPropertyType();
            if (type2.isArray()) {
                this.propertyType = type2.getComponentType();
            } else if (List.class.isAssignableFrom(type2) && (method2 = propertyDescriptor.getReadMethod()) != null) {
                Type returnType = method2.getGenericReturnType();
                this.propertyType = returnType instanceof ParameterizedType ? this.toClass(((ParameterizedType)returnType).getActualTypeArguments()[0]) : Object.class;
            }
        } else if (name.endsWith(MAPPED_DELIM2) && Map.class.isAssignableFrom(type = propertyDescriptor.getPropertyType()) && (method = propertyDescriptor.getReadMethod()) != null) {
            Type returnType = method.getGenericReturnType();
            this.propertyType = returnType instanceof ParameterizedType ? this.toClass(((ParameterizedType)returnType).getActualTypeArguments()[1]) : Object.class;
        }
    }

    Class<?> toClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            return this.toClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        return Object.class;
    }

    @Override
    public Class<?> getPropertyType() {
        if (this.propertyType != null) {
            return this.propertyType;
        }
        if (this.indexed_) {
            return ((IndexedPropertyDescriptor)this.propertyDescriptor_).getIndexedPropertyType();
        }
        if (this.mapped_) {
            return ((MappedPropertyDescriptor)this.propertyDescriptor_).getMappedPropertyType();
        }
        return this.propertyDescriptor_.getPropertyType();
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor_;
    }

    @Override
    public Method getReadMethod() {
        if (this.indexed_) {
            return ((IndexedPropertyDescriptor)this.propertyDescriptor_).getIndexedReadMethod();
        }
        if (this.mapped_) {
            return ((MappedPropertyDescriptor)this.propertyDescriptor_).getMappedReadMethod();
        }
        return this.propertyDescriptor_.getReadMethod();
    }

    @Override
    public Method getWriteMethod() {
        if (this.indexed_) {
            return ((IndexedPropertyDescriptor)this.propertyDescriptor_).getIndexedWriteMethod();
        }
        if (this.mapped_) {
            return ((MappedPropertyDescriptor)this.propertyDescriptor_).getMappedWriteMethod();
        }
        return this.propertyDescriptor_.getWriteMethod();
    }

    @Override
    public void setProperty(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        this.propertyUtilsBean_.setProperty(this.bean_, this.name_, value);
    }

    @Override
    public Object getProperty() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.propertyUtilsBean_.getProperty(this.bean_, this.name_);
    }
}

