/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.amf;

import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfMessageDeserializer;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.Java15AmfMessageSerializer;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.RemotingMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.ymir.util.StringUtils;

public class AmfUtils {
    private static final MessageSerializer SERIALIZER = new Java15AmfMessageSerializer();
    private static final MessageDeserializer DESERIALIZER = new AmfMessageDeserializer();

    public static boolean isAmfType(HttpServletRequest req) {
        String contentType = req.getHeader("content-type");
        return !StringUtils.isEmpty((String)contentType) && contentType.equals("application/x-amf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionContext createActionContext(HttpServletRequest request) throws IOException {
        ActionContext actionContext = new ActionContext();
        SerializationContext serializationContext = SerializationContext.getSerializationContext();
        ServletInputStream inputStream = request.getInputStream();
        MessageDeserializer messageDeserializer = DESERIALIZER;
        synchronized (messageDeserializer) {
            DESERIALIZER.initialize(serializationContext, (InputStream)inputStream, new AmfTrace());
            int contentLength = request.getContentLength();
            actionContext.setDeserializedBytes(contentLength);
            actionContext.setRequestMessage(new ActionMessage());
            try {
                DESERIALIZER.readMessage(actionContext.getRequestMessage(), actionContext);
            }
            catch (ClassNotFoundException ex) {
                IOException ioex = new IOException("Can't read AMF message");
                ioex.initCause(ex);
                throw ioex;
            }
        }
        return actionContext;
    }

    public static void createActionContextForErrorResponse(Throwable t, OutputStream os) {
        ActionContext actionContext = new ActionContext();
        actionContext.setStatus(1);
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(actionContext.getRequestMessageBody().getResponseURI());
        actionContext.setVersion(3);
        actionContext.getResponseMessage().addBody(responseBody);
        responseBody.setData((Object)AmfUtils.createErrorMessage(t));
        responseBody.setReplyMethod("/onStatus");
        AmfUtils.sendResponseMessage(actionContext, os);
    }

    public static ErrorMessage createErrorMessage(Throwable t) {
        ErrorMessage message = new ErrorMessage();
        message.rootCause = t;
        String faultString = t.getMessage();
        if (StringUtils.isEmpty((String)faultString)) {
            faultString = t.toString();
        }
        message.faultString = faultString;
        String faultDetail = t.getLocalizedMessage();
        if (StringUtils.isEmpty((String)faultDetail)) {
            faultDetail = t.toString();
        }
        message.faultDetail = faultDetail;
        message.faultCode = t.toString();
        message.extendedData = CollectionsUtil.newHashMap();
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendResponseMessage(ActionContext actionContext, OutputStream os) {
        SerializationContext serContext = SerializationContext.getSerializationContext();
        try {
            ActionMessage responseMessage = actionContext.getResponseMessage();
            MessageSerializer messageSerializer = SERIALIZER;
            synchronized (messageSerializer) {
                SERIALIZER.initialize(serContext, os, new AmfTrace());
                SERIALIZER.writeMessage(responseMessage);
            }
        }
        catch (Throwable t) {
            if (actionContext.getStatus() == 1) {
                throw new IllegalStateException(t);
            }
            AmfUtils.handleError(actionContext, t, os);
        }
    }

    public static void handleError(ActionContext actionContext, Throwable t, OutputStream os) {
        actionContext.setStatus(1);
        ActionMessage actionMessage = new ActionMessage();
        actionContext.setResponseMessage(actionMessage);
        int bodyCount = actionContext.getRequestMessage().getBodyCount();
        actionContext.setMessageNumber(0);
        while (actionContext.getMessageNumber() < bodyCount) {
            MessageBody responseBody = new MessageBody();
            MessageBody requestMessageBody = actionContext.getRequestMessageBody();
            responseBody.setTargetURI(requestMessageBody.getResponseURI());
            actionContext.getResponseMessage().addBody(responseBody);
            ErrorMessage errorMessage = AmfUtils.createErrorMessage(t);
            Object data = AmfUtils.getSingleRequestMessageBodyData(actionContext);
            AmfUtils.addMessageInfo(data, errorMessage);
            responseBody.setData((Object)errorMessage);
            responseBody.setReplyMethod("/onStatus");
            actionMessage.addBody(responseBody);
            actionContext.incrementMessageNumber();
        }
        AmfUtils.sendResponseMessage(actionContext, os);
    }

    static Object getSingleRequestMessageBodyData(ActionContext actionContext) {
        MessageBody reqBody = actionContext.getRequestMessageBody();
        if (reqBody == null) {
            return null;
        }
        Object data = reqBody.getData();
        if (data == null) {
            return null;
        }
        if (data.getClass().isArray()) {
            return ((Object[])data)[0];
        }
        return data;
    }

    static void addMessageInfo(Object data, ErrorMessage errorMessage) {
        if (data instanceof Message) {
            Message message = (Message)data;
            Object clientId = message.getClientId();
            if (clientId != null) {
                errorMessage.setClientId((Object)clientId.toString());
            }
            String messageId = message.getMessageId();
            String destination = message.getDestination();
            if (messageId != null) {
                errorMessage.setCorrelationId(messageId);
                errorMessage.setDestination(destination);
            }
            if (message instanceof RemotingMessage) {
                RemotingMessage rm = (RemotingMessage)message;
                String operation = rm.getOperation();
                errorMessage.extendedData.put("operation", operation);
                errorMessage.extendedData.put("target", destination + "." + operation);
            }
        }
    }

    public static boolean processIfCommandMessage(ActionContext actionContext) {
        MessageBody requestBody = actionContext.getRequestMessageBody();
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(requestBody.getResponseURI());
        boolean commandMessage = false;
        Object[] bodyObjects = (Object[])requestBody.getData();
        for (int i = 0; i < bodyObjects.length; ++i) {
            Object body = bodyObjects[i];
            if (!(body instanceof CommandMessage)) continue;
            commandMessage = true;
            CommandMessage command = (CommandMessage)body;
            if (command.getOperation() != 5) break;
            responseBody.setReplyMethod("/onResult");
            break;
        }
        if (commandMessage) {
            ActionMessage responseMessage = new ActionMessage();
            responseMessage.setVersion(actionContext.getVersion());
            responseMessage.addBody(responseBody);
            actionContext.setResponseMessage(responseMessage);
        }
        return commandMessage;
    }

    public static RemotingMessage getRemotingMessage(ActionContext actionContext) {
        MessageBody requestBody = actionContext.getRequestMessageBody();
        Object[] bodyObjects = (Object[])requestBody.getData();
        for (int i = 0; i < bodyObjects.length; ++i) {
            Object body = bodyObjects[i];
            if (!(body instanceof RemotingMessage)) continue;
            return (RemotingMessage)body;
        }
        return null;
    }

    public static void sendResopnse(ActionContext actionContext, RemotingMessage message, Object response, OutputStream os) {
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(actionContext.getRequestMessageBody().getResponseURI());
        responseBody.setReplyMethod("/onResult");
        AcknowledgeMessage acknowledge = new AcknowledgeMessage();
        acknowledge.setClientId(message.getClientId());
        acknowledge.setCorrelationId(message.getMessageId());
        acknowledge.setDestination(message.getDestination());
        acknowledge.setBody(response);
        acknowledge.setHeader("DSMessagingVersion", (Object)3.0);
        responseBody.setData((Object)acknowledge);
        ActionMessage responseMessage = new ActionMessage();
        responseMessage.setVersion(actionContext.getVersion());
        responseMessage.addBody(responseBody);
        actionContext.setResponseMessage(responseMessage);
        AmfUtils.sendResponseMessage(actionContext, os);
    }
}

