/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.amf;

import flex.messaging.io.amf.ActionContext;
import flex.messaging.messages.RemotingMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.io.IORuntimeException;
import org.seasar.kvasir.util.io.InputStreamFactory;
import org.seasar.kvasir.util.io.impl.ByteArrayInputStreamFactory;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.MethodInvoker;
import org.seasar.ymir.MethodInvokerWrapper;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.WrappingRuntimeException;
import org.seasar.ymir.amf.Amf;
import org.seasar.ymir.amf.AmfUtils;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.cache.CacheManager;
import org.seasar.ymir.interceptor.impl.AbstractYmirProcessInterceptor;
import org.seasar.ymir.response.SelfContainedResponse;
import org.seasar.ymir.response.VoidResponse;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmfInterceptor
extends AbstractYmirProcessInterceptor {
    private ActionManager actionManager_;
    private AnnotationHandler annotationHandler_;
    private ThreadLocal<Boolean> enabled_ = new ThreadLocal();
    private ThreadLocal<ActionContext> actionContext_ = new ThreadLocal();
    private Map<Class<?>, Map<String, Method>> methodMap_;

    @Binding(bindingType=BindingType.MUST)
    public void setActionManager(ActionManager actionManager) {
        this.actionManager_ = actionManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setCacheManager(CacheManager cacheManager) {
        this.methodMap_ = cacheManager.newMap();
    }

    public double getPriority() {
        return 0.0;
    }

    public Response enteringRequest(ServletContext context, HttpServletRequest httpRequest, HttpServletResponse httpResponse, String path) {
        ActionContext actionContext;
        if (!AmfUtils.isAmfType(httpRequest)) {
            return null;
        }
        try {
            actionContext = AmfUtils.createActionContext(httpRequest);
        }
        catch (Throwable t) {
            AmfUtils.createActionContextForErrorResponse(t, this.getOutputStream(httpResponse));
            return VoidResponse.INSTANCE;
        }
        if (AmfUtils.processIfCommandMessage(actionContext)) {
            AmfUtils.sendResponseMessage(actionContext, this.getOutputStream(httpResponse));
            return VoidResponse.INSTANCE;
        }
        this.enabled_.set(Boolean.TRUE);
        this.actionContext_.set(actionContext);
        return null;
    }

    OutputStream getOutputStream(HttpServletResponse httpResponse) {
        try {
            return httpResponse.getOutputStream();
        }
        catch (IOException ex) {
            throw new IORuntimeException("Can't open response stream", (Throwable)ex);
        }
    }

    public PageComponent pageComponentCreated(Request request, PageComponent pageComponent) {
        if (!this.isEnabled()) {
            return pageComponent;
        }
        Class pageClass = pageComponent.getPageClass();
        if (!this.methodMap_.containsKey(pageClass)) {
            HashMap<String, Method> map = new HashMap<String, Method>();
            for (Method method : ClassUtils.getMethods((Class)pageClass)) {
                Amf amf = (Amf)this.annotationHandler_.getAnnotation((AnnotatedElement)method, Amf.class);
                if (amf == null) continue;
                map.put(this.getName(amf, method), method);
            }
            this.methodMap_.put(pageClass, Collections.unmodifiableMap(map));
        }
        return pageComponent;
    }

    String getName(Amf amf, Method method) {
        if (amf.value().length() > 0) {
            return amf.value();
        }
        return method.getName();
    }

    public Action actionInvoking(Request request, Action action) {
        if (!this.isEnabled()) {
            return action;
        }
        return this.createAction(request.getCurrentDispatch().getPageComponent());
    }

    Action createAction(PageComponent pageComponent) {
        final RemotingMessage message = AmfUtils.getRemotingMessage(this.getActionContext());
        if (message == null) {
            return null;
        }
        Method method = this.findMethod(pageComponent.getPageClass(), message.getOperation());
        if (method == null) {
            return null;
        }
        Action action = this.actionManager_.newAction(pageComponent.getPage(), pageComponent.getPageClass(), method, message.getParameters().toArray());
        return this.actionManager_.newAction(action, (MethodInvoker)new MethodInvokerWrapper(action.getMethodInvoker()){

            public Class<? extends Object> getReturnType() {
                return Response.class;
            }

            public Object invoke(Object component, Object[] parameters) throws WrappingRuntimeException {
                Object returned = super.invoke(component, parameters);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                AmfUtils.sendResopnse(AmfInterceptor.this.getActionContext(), message, returned, baos);
                return new SelfContainedResponse((InputStreamFactory)new ByteArrayInputStreamFactory(baos.toByteArray()));
            }
        });
    }

    Method findMethod(Class<?> pageClass, String name) {
        Map<String, Method> map = this.methodMap_.get(pageClass);
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public void leavingRequest(Request request) {
        if (!this.isEnabled()) {
            return;
        }
        this.enabled_.set(null);
        this.actionContext_.set(null);
    }

    public Response exceptionProcessingStarted(Request request, Throwable t) {
        if (!this.isEnabled()) {
            return null;
        }
        ActionContext actionContext = this.getActionContext();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AmfUtils.handleError(actionContext, t, baos);
        return new SelfContainedResponse((InputStreamFactory)new ByteArrayInputStreamFactory(baos.toByteArray()));
    }

    boolean isEnabled() {
        Boolean enabled = this.enabled_.get();
        return enabled != null ? enabled : false;
    }

    ActionContext getActionContext() {
        return this.actionContext_.get();
    }
}

