/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.conversation.impl;

import java.util.regex.Pattern;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.LifecycleListener;
import org.seasar.ymir.conversation.ConversationManager;
import org.seasar.ymir.conversation.Conversations;
import org.seasar.ymir.conversation.impl.ConversationsImpl;
import org.seasar.ymir.hotdeploy.HotdeployManager;
import org.seasar.ymir.window.WindowManager;

public class ConversationManagerImpl
implements ConversationManager,
LifecycleListener {
    private static final String ATTR_CONVERSATIONS = "org.seasar.ymir.conversation.conversations";
    private S2Container container_;
    private ApplicationManager applicationManager_;
    private HotdeployManager hotdeployManager_;
    private WindowManager windowManager_;

    S2Container getS2Container() {
        if (this.container_ != null) {
            return this.container_;
        }
        return this.applicationManager_.getContextApplication().getS2Container();
    }

    void setS2Container(S2Container container) {
        this.container_ = container;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setHotdeployManager(HotdeployManager hotdeployManager) {
        this.hotdeployManager_ = hotdeployManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setWindowManager(WindowManager windowManager) {
        this.windowManager_ = windowManager;
    }

    public void init() {
        this.windowManager_.addStraddlingAttributeNamePattern(Pattern.quote(ATTR_CONVERSATIONS));
    }

    public void destroy() {
    }

    public Conversations getConversations() {
        return this.getConversations(true);
    }

    public Conversations getConversations(boolean create) {
        Conversations conversations = (Conversations)this.windowManager_.getScopeAttribute(ATTR_CONVERSATIONS);
        if (conversations == null && create) {
            conversations = this.newConversations();
            this.windowManager_.setScopeAttribute(ATTR_CONVERSATIONS, conversations);
        }
        return conversations;
    }

    protected Conversations newConversations() {
        ConversationsImpl impl = new ConversationsImpl();
        impl.setHotdeployManager(this.hotdeployManager_);
        impl.setApplicationManager(this.applicationManager_);
        return impl;
    }
}

