package org.seasar.ymir;

/**
 * サーブレットの処理フェーズを表すenumです。
 */
public enum Dispatcher {
    /**
     * 処理フェーズが不明であることを表します。
     */
    UNKNOWN,

    /**
     * 処理フェーズが「リクエスト」であることを表します。
     * <p>HTTPリクエストを受け取った直後であることを表します。
     * </p>
     */
    REQUEST,

    /**
     * 処理フェーズが「フォワード」であることを表します。
     * <p>HTTPリクエストの処理が別のパスに対する処理として内部的に転送されてきたことを表します。
     * </p>
     */
    FORWARD,

    /**
     * 処理フェーズが「インクルード」であることを表します。
     * <p>HTTPリクエストの処理中に別のパスに対する一時的な処理が発生したことを表します。
     * </p>
     */
    INCLUDE,

    /**
     * 処理フェーズが「エラー」であることを表します。
     * <p>HTTPリクエストの処理中になんらかのエラーが発生したためにエラー処理を開始したことを表します。
     * </p>
     */
    ERROR
}
