/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexibleList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess {
    private static final int DEFAULT_MAXINDEX = 999;
    private static final int MAXINDEX_UNLIMITED = -1;
    private SortedMap<Integer, E> map = new TreeMap<Integer, E>();
    private int maxIndex = 999;

    public void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
    }

    @Override
    public void add(int index, E element) {
        if (!this.validateIndex(index)) {
            return;
        }
        if (this.map.isEmpty()) {
            this.map.put(index, element);
        } else {
            TreeMap<Integer, E> m = new TreeMap<Integer, E>();
            Iterator<Map.Entry<Integer, E>> itr = this.map.tailMap(index).entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<Integer, E> entry = itr.next();
                m.put(entry.getKey() + 1, entry.getValue());
                itr.remove();
            }
            this.map.put(index, element);
            for (Map.Entry entry : m.entrySet()) {
                this.map.put((Integer)entry.getKey(), (E)entry.getValue());
            }
        }
    }

    private boolean validateIndex(int index) {
        if (this.maxIndex == -1) {
            return index >= 0;
        }
        return index >= 0 && index <= this.maxIndex;
    }

    @Override
    public E get(int index) {
        return (E)this.map.get(index);
    }

    @Override
    public E remove(int index) {
        return (E)this.map.remove(index);
    }

    @Override
    public E set(int index, E element) {
        if (!this.validateIndex(index)) {
            return null;
        }
        return this.map.put(index, element);
    }

    @Override
    public int size() {
        if (this.map.isEmpty()) {
            return 0;
        }
        return this.map.lastKey() + 1;
    }
}

