/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.kvasir.util.io.IOUtils;

public class ArtifactMetaData {
    private static final String KEY_GROUPID = "groupId";
    private static final String KEY_ARTIFACTID = "artifactId";
    private static final String KEY_VERSION = "version";
    private static final String UNKNOWN = "unknown";
    private String groupId_;
    private String artifactId_;
    private String version_;
    private String timestamp_;
    private static Log log_ = LogFactory.getLog(ArtifactMetaData.class);

    private ArtifactMetaData(String groupId, String artifactId, String version, String timestamp) {
        this.groupId_ = groupId;
        this.artifactId_ = artifactId;
        this.version_ = version;
        this.timestamp_ = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtifactMetaData newInstance(URL resource) {
        if (resource == null) {
            return null;
        }
        Properties prop = new Properties();
        InputStream is = null;
        try {
            is = resource.openStream();
            prop.load(is);
        }
        catch (IOException ex) {
            log_.warn((Object)("Can't get version information from '" + resource.toExternalForm() + "'"), (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            is = null;
        }
        String timestamp = null;
        try {
            is = resource.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
            String line = br.readLine();
            line = br.readLine();
            if (line != null && line.startsWith("#")) {
                timestamp = line.substring(1).trim();
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Can't happen!", ex);
        }
        catch (IOException ex) {
            log_.warn((Object)("Can't read '" + resource.toExternalForm() + "'"), (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return new ArtifactMetaData(prop.getProperty(KEY_GROUPID), prop.getProperty(KEY_ARTIFACTID), prop.getProperty(KEY_VERSION), timestamp);
    }

    public String getGroupId() {
        return this.groupId_;
    }

    public String getArtifactId() {
        return this.artifactId_;
    }

    public String getVersion() {
        return this.version_;
    }

    public String getTimestamp() {
        return this.timestamp_;
    }

    public String getSignature() {
        return (this.groupId_ != null ? this.groupId_ : UNKNOWN) + ":" + (this.artifactId_ != null ? this.artifactId_ : UNKNOWN) + "-" + (this.version_ != null ? this.version_ : UNKNOWN) + " (" + (this.timestamp_ != null ? this.timestamp_ : UNKNOWN) + ")";
    }
}

