/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.kvasir.util.io.IOUtils;
import org.seasar.ymir.util.ServletUtils;

public class JavaResourceServlet
extends HttpServlet {
    private static final String INITPARAM_WEBROOTPACKAGEPATH = "webrootPackagePath";
    private static final String INITPRARM_ENCODING = "encoding";
    private static final String DEFAULT_WEBROOTPACKAGEPATH = "org/seasar/ymir/webroot";
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_MIMETYPE = "application/octet-stream";
    private String webrootPackagePath_;
    private String encoding_;

    public void init() throws ServletException {
        super.init();
        String webrootPackagePath = this.getInitParameter(INITPARAM_WEBROOTPACKAGEPATH);
        if (webrootPackagePath == null) {
            webrootPackagePath = DEFAULT_WEBROOTPACKAGEPATH;
        }
        if (webrootPackagePath.endsWith("/")) {
            webrootPackagePath = webrootPackagePath.substring(0, webrootPackagePath.length() - 1);
        }
        this.webrootPackagePath_ = webrootPackagePath;
        this.encoding_ = this.getInitParameter(INITPRARM_ENCODING);
        if (this.encoding_ == null) {
            this.encoding_ = "UTF-8";
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doProcess(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doProcess(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcess(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = ServletUtils.getPath(req);
        InputStream is = this.getServletContext().getResourceAsStream(path);
        if (is == null && (is = this.getClassLoader().getResourceAsStream(this.webrootPackagePath_ + path)) == null) {
            resp.sendError(404);
            return;
        }
        try {
            String contentType = this.getServletContext().getMimeType(path);
            if (contentType == null) {
                contentType = DEFAULT_MIMETYPE;
            }
            if (contentType.startsWith("text/")) {
                contentType = contentType + ";charset=" + this.encoding_;
            }
            resp.setContentType(contentType);
            IOUtils.pipe((InputStream)is, (OutputStream)resp.getOutputStream(), (boolean)false, (boolean)false);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }
}

