/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.render;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.seasar.ymir.render.Candidate;
import org.seasar.ymir.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Candidate[] EMPTY_CANDIDATES = new Candidate[0];
    private String[] selectedValues_;
    private Candidate[] candidates_;
    private transient Map<String, Candidate> candidateMap_ = new HashMap<String, Candidate>();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.candidateMap_ = new HashMap<String, Candidate>();
        this.initializeCandidateMap();
        this.updateCandidates();
    }

    public String getSelectedValue() {
        String[] values = this.getSelectedValues();
        if (values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Integer getSelectedValueAsInteger() {
        String value = this.getSelectedValue();
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public String[] getSelectedValues() {
        if (this.selectedValues_ == null) {
            if (this.candidates_ == null) {
                return EMPTY_STRINGS;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (Candidate candidate : this.candidates_) {
                if (!candidate.isSelected()) continue;
                list.add(candidate.getValue());
            }
            return list.toArray(EMPTY_STRINGS);
        }
        if (this.candidates_ == null) {
            return this.selectedValues_;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String value : this.selectedValues_) {
            if (!this.candidateMap_.containsKey(value)) continue;
            list.add(value);
        }
        return list.toArray(EMPTY_STRINGS);
    }

    public Integer[] getSelectedValuesAsInteger() {
        String[] values = this.getSelectedValues();
        Integer[] integers = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            integers[i] = Integer.valueOf(values[i]);
        }
        return integers;
    }

    public void setSelectedValues(String ... values) {
        this.selectedValues_ = values;
        this.updateCandidates();
    }

    public void setSelectedValue(String value) {
        this.setSelectedValues(value);
    }

    public void setSelectedValueObjects(Object ... valueObjects) {
        String[] values = new String[valueObjects.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = StringUtils.asString(valueObjects[i]);
        }
        this.setSelectedValues(values);
    }

    public void setSelectedValueObject(Object value) {
        this.setSelectedValueObjects(value);
    }

    public <C extends Candidate> C getSelectedCandidate() {
        List<C> candidateList = this.getSelectedCandidateList();
        if (candidateList.isEmpty()) {
            return null;
        }
        return (C)((Candidate)candidateList.get(0));
    }

    public Candidate[] getSelectedCandidates() {
        return this.getSelectedCandidateList().toArray(EMPTY_CANDIDATES);
    }

    public <C extends Candidate> List<C> getSelectedCandidateList() {
        if (this.selectedValues_ == null) {
            if (this.candidates_ == null) {
                return Collections.emptyList();
            }
            ArrayList<Candidate> list = new ArrayList<Candidate>();
            for (Candidate candidate : this.candidates_) {
                if (!candidate.isSelected()) continue;
                list.add(candidate);
            }
            return list;
        }
        if (this.candidates_ == null) {
            return Collections.emptyList();
        }
        ArrayList<Candidate> list = new ArrayList<Candidate>();
        for (String value : this.selectedValues_) {
            Candidate candidate = this.candidateMap_.get(value);
            if (candidate == null) continue;
            list.add(candidate);
        }
        return list;
    }

    public <C extends Candidate> C[] getCandidates() {
        return this.candidates_;
    }

    public Selector setCandidates(Candidate ... candidates) {
        this.candidates_ = candidates;
        this.initializeCandidateMap();
        this.updateCandidates();
        return this;
    }

    private void initializeCandidateMap() {
        this.candidateMap_.clear();
        if (this.candidates_ != null) {
            for (Candidate candidate : this.candidates_) {
                this.candidateMap_.put(candidate.getValue(), candidate);
            }
        }
    }

    public <C extends Candidate> List<C> getCandidateList() {
        if (this.candidates_ == null) {
            return null;
        }
        return new ArrayList<Candidate>(Arrays.asList(this.candidates_));
    }

    public <E extends Candidate> Selector setCandidateList(List<E> candidateList) {
        return this.setCandidates(candidateList.toArray(EMPTY_CANDIDATES));
    }

    private void updateCandidates() {
        if (this.selectedValues_ == null || this.candidates_ == null) {
            return;
        }
        HashSet<String> valueSet = new HashSet<String>(Arrays.asList(this.selectedValues_));
        for (Candidate candidate : this.candidates_) {
            candidate.setSelected(valueSet.contains(candidate.getValue()));
        }
    }
}

