/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.mock.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import org.seasar.kvasir.util.io.Resource;
import org.seasar.kvasir.util.io.ResourceNotFoundException;
import org.seasar.ymir.mock.servlet.MockRequestDispatcherFactory;
import org.seasar.ymir.mock.servlet.MockServletContext;
import org.seasar.ymir.mock.servlet.RequestDispatcherFactory;

public class MockServletContextImpl
extends org.seasar.framework.mock.servlet.MockServletContextImpl
implements MockServletContext {
    private static final long serialVersionUID = 2458242111693537876L;
    private Resource root_;
    private RequestDispatcherFactory requestDispatcherFactory_ = new MockRequestDispatcherFactory();

    public MockServletContextImpl(String path) {
        super(path);
    }

    public void setRoot(Resource root) {
        this.root_ = root;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.requestDispatcherFactory_.newInstance(path, null);
    }

    public void setRequestDispatcherFactory(RequestDispatcherFactory requestDispatcherFactory) {
        this.requestDispatcherFactory_ = requestDispatcherFactory;
    }

    public String getRealPath(String path) {
        if (this.root_ != null) {
            if ("".equals(path) || "/".equals(path)) {
                return this.root_.toFile().getAbsolutePath();
            }
            Resource resource = this.root_.getChildResource(path);
            if (resource.exists()) {
                return resource.toFile().getAbsolutePath();
            }
            return null;
        }
        return super.getRealPath(path);
    }

    public InputStream getResourceAsStream(String path) {
        if (this.root_ != null) {
            Resource resource = this.root_.getChildResource(path);
            if (resource.exists()) {
                try {
                    return resource.getInputStream();
                }
                catch (ResourceNotFoundException ex) {
                    return null;
                }
            }
            return null;
        }
        return super.getResourceAsStream(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.root_ != null) {
            if ("".equals(path) || "/".equals(path)) {
                return this.root_.getURL();
            }
            Resource resource = this.root_.getChildResource(path);
            if (resource.exists()) {
                return resource.getURL();
            }
            return null;
        }
        return super.getResource(path);
    }

    public Set getResourcePaths(String path) {
        if (this.root_ != null) {
            Resource resource = this.getResource0(path);
            String spath = path + (path.endsWith("/") ? "" : "/");
            if (resource.exists()) {
                HashSet<String> set = new HashSet<String>();
                for (Resource child : resource.listResources()) {
                    set.add(spath + child.getName() + (child.isDirectory() ? "/" : ""));
                }
                return set;
            }
            return null;
        }
        return super.getResourcePaths(path);
    }

    Resource getResource0(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() == 0) {
            return this.root_;
        }
        return this.root_.getChildResource(path);
    }
}

