/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.ymir.message.Note;
import org.seasar.ymir.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Notes {
    public static final String CATEGORY_DELIMITER = "+";
    private static final String CATEGORY_DELIMITER_PATTERN = "\\+";
    public static final String GLOBAL_NOTE = "org.seasar.ymir.message.GLOBAL_NOTE";
    private List<Note> list_ = new ArrayList<Note>();
    private Map<String, List<Note>> map_ = new LinkedHashMap<String, List<Note>>();
    private boolean accessed_ = false;

    public Notes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notes(Notes notes) {
        if (notes != null) {
            boolean accessed = notes.isAccessed();
            try {
                this.add(notes);
            }
            finally {
                notes.setAccessed(accessed);
            }
        }
    }

    public Notes add(Notes notes) {
        if (notes == null) {
            return this;
        }
        Iterator<String> categories = notes.categories();
        while (categories.hasNext()) {
            String category = categories.next();
            Iterator<Note> itr = notes.get(category);
            while (itr.hasNext()) {
                Note note = itr.next();
                this.add(category, note);
            }
        }
        return this;
    }

    public Notes add(Note note) {
        return this.add(GLOBAL_NOTE, note);
    }

    public Notes add(String category, Note note) {
        return this.add(note, category.split(CATEGORY_DELIMITER_PATTERN, -1));
    }

    public Notes add(Note note, String ... categories) {
        this.list_.add(note);
        for (String category : StringUtils.unique(categories)) {
            List<Note> noteList = this.map_.get(category);
            if (noteList == null) {
                noteList = new ArrayList<Note>();
                this.map_.put(category, noteList);
            }
            noteList.add(note);
        }
        return this;
    }

    public Notes clear() {
        this.list_.clear();
        this.map_.clear();
        this.accessed_ = false;
        return this;
    }

    public Iterator<Note> get() {
        this.accessed_ = true;
        return Collections.unmodifiableCollection(this.list_).iterator();
    }

    public Note[] getNotes() {
        this.accessed_ = true;
        return this.list_.toArray(new Note[0]);
    }

    public boolean isAccessed() {
        return this.accessed_;
    }

    public void setAccessed(boolean accessed) {
        this.accessed_ = accessed;
    }

    public Iterator<Note> get(String category) {
        this.accessed_ = true;
        List<Note> noteList = this.map_.get(category);
        if (noteList == null) {
            noteList = new ArrayList<Note>();
        }
        return Collections.unmodifiableCollection(noteList).iterator();
    }

    public Note[] getNotes(String category) {
        this.accessed_ = true;
        List<Note> noteList = this.map_.get(category);
        if (noteList == null) {
            return new Note[0];
        }
        return noteList.toArray(new Note[0]);
    }

    public boolean isEmpty() {
        return this.list_.isEmpty();
    }

    public Iterator<String> categories() {
        return Collections.unmodifiableSet(this.map_.keySet()).iterator();
    }

    public int size() {
        return this.list_.size();
    }

    public int size(String category) {
        List<Note> noteList = this.map_.get(category);
        if (noteList == null) {
            return 0;
        }
        return noteList.size();
    }

    public boolean contains(String category) {
        return this.map_.containsKey(category);
    }

    public boolean containsValue(String value) {
        int n = this.list_.size();
        for (int i = 0; i < n; ++i) {
            Note note = this.list_.get(i);
            String v = note.getValue();
            if (!(v != null ? v.equals(value) : value == null)) continue;
            return true;
        }
        return false;
    }
}

