/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.seasar.kvasir.util.MimeUtils;
import org.seasar.kvasir.util.io.IOUtils;
import org.seasar.ymir.HttpServletResponseFilter;
import org.seasar.ymir.Updater;

public class UpdaterResponseFilter
extends HttpServletResponseWrapper
implements HttpServletResponseFilter {
    private Updater[] updaters_;
    private String type_;
    private ByteArrayOutputStream outputStream_;
    private ServletOutputStream servletOutputStream_;
    private StringWriter writer_;
    private PrintWriter printWriter_;
    private boolean propagateContentType_ = true;
    private String charset_;

    public UpdaterResponseFilter(HttpServletRequest request, HttpServletResponse response, Updater[] updaters) {
        super(response);
        this.updaters_ = updaters;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.shouldBuffering()) {
            if (this.servletOutputStream_ == null) {
                this.outputStream_ = new ByteArrayOutputStream();
                this.servletOutputStream_ = new ServletOutputStream(){

                    public void write(int b) throws IOException {
                        UpdaterResponseFilter.this.outputStream_.write(b);
                    }
                };
            }
            return this.servletOutputStream_;
        }
        return this.getResponse().getOutputStream();
    }

    boolean shouldBuffering() {
        return this.type_ != null && this.type_.startsWith("text/") && this.type_.indexOf("html") >= 0;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.shouldBuffering()) {
            if (this.printWriter_ == null) {
                this.writer_ = new StringWriter();
                this.printWriter_ = new PrintWriter(this.writer_);
            }
            return this.printWriter_;
        }
        return this.getResponse().getWriter();
    }

    public void setContentType(String type) {
        this.type_ = type;
        if (this.propagateContentType_) {
            this.getResponse().setContentType(type);
        }
    }

    public void setCharacterEncoding(String charset) {
        this.charset_ = charset;
        if (this.propagateContentType_) {
            super.setCharacterEncoding(charset);
        }
    }

    public String getCharacterEncoding() {
        String charset = this.charset_;
        if (charset == null && (charset = MimeUtils.getCharset((String)this.type_)) == null) {
            charset = super.getCharacterEncoding();
        }
        return charset;
    }

    public void commit() throws IOException {
        if (this.shouldBuffering()) {
            String response;
            if (this.outputStream_ != null) {
                try {
                    this.outputStream_.flush();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Can't happen!", ex);
                }
                byte[] bytes = this.outputStream_.toByteArray();
                try {
                    response = new String(bytes, this.getCharacterEncoding());
                }
                catch (UnsupportedEncodingException ex) {
                    this.commit(bytes);
                    return;
                }
            }
            if (this.printWriter_ != null) {
                this.printWriter_.flush();
                response = this.writer_.toString();
            } else {
                return;
            }
            this.commit(this.filterResponse(response));
        }
    }

    String filterResponse(String response) {
        for (int i = 0; i < this.updaters_.length; ++i) {
            response = this.updaters_[i].filterResponse(response);
        }
        return response;
    }

    void commit(String response) throws IOException {
        IOUtils.writeString((OutputStream)this.getResponse().getOutputStream(), (String)response, (String)this.getCharacterEncoding(), (boolean)false, (boolean)false);
    }

    void commit(byte[] response) throws IOException {
        IOUtils.writeBytes((OutputStream)this.getResponse().getOutputStream(), (byte[])response, (boolean)false);
    }

    public void setPropagateContentType(boolean propagateContentType) {
        this.propagateContentType_ = propagateContentType;
    }
}

