/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.net.URL;
import org.seasar.cms.pluggable.hotdeploy.LocalHotdeployS2Container;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.Application;
import org.seasar.ymir.PathMappingProvider;
import org.seasar.ymir.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplication
implements Application {
    public static final String KEY_PROJECTROOT = "projectRoot";
    public static final String KEY_WEBAPPSOURCEROOT = "webappSourceRoot";
    public static final String KEY_ROOTPACKAGENAME = "rootPackageName";
    public static final String KEY_RESOURCESDIRECTORY = "resourcesDirectory";
    public static final String KEY_SOURCEDIRECTORY = "sourceDirectory";
    public static final String KEY_TEMPLATEENCODING = "templateEncoding";
    private static final String PROPERTIESPATH = "app.properties";
    private static final String LOCALPROPERTIESPATH = "app-local.properties";
    private String id_;
    private LocalHotdeployS2Container ondemandContainer_;
    private PathMappingProvider pathMappingProvider_;

    protected AbstractApplication(String id, LocalHotdeployS2Container ondemandContainer, PathMappingProvider pathMappingProvider) {
        this.id_ = id;
        this.ondemandContainer_ = ondemandContainer;
        this.pathMappingProvider_ = pathMappingProvider;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public String getProjectRoot() {
        return this.getProperty(KEY_PROJECTROOT);
    }

    @Override
    public void setProjectRoot(String projectRoot) {
        this.setProperty(KEY_PROJECTROOT, projectRoot);
    }

    @Override
    @Deprecated
    public String getRootPackageName() {
        return this.getProperty(KEY_ROOTPACKAGENAME);
    }

    @Override
    @Deprecated
    public void setRootPackageName(String rootPackageName) {
        this.setProperty(KEY_ROOTPACKAGENAME, rootPackageName);
    }

    @Override
    public String[] getRootPackageNames() {
        return PropertyUtils.toLines((String)this.getProperty(KEY_ROOTPACKAGENAME));
    }

    @Override
    public String getFirstRootPackageName() {
        String[] rootPackageNames = this.getRootPackageNames();
        if (rootPackageNames.length > 0) {
            return rootPackageNames[0];
        }
        return null;
    }

    @Override
    public String getResourcesDirectory() {
        String resourcesDirectory = this.getProperty(KEY_RESOURCESDIRECTORY);
        if (resourcesDirectory == null) {
            String projectRoot = this.getProjectRoot();
            if (projectRoot != null) {
                resourcesDirectory = projectRoot + "/src/main/resources";
            }
        } else {
            String projectRoot = this.getProjectRoot();
            if (projectRoot != null && FileUtils.isRelativePath(resourcesDirectory)) {
                resourcesDirectory = projectRoot + "/" + resourcesDirectory;
            }
        }
        return resourcesDirectory;
    }

    @Override
    public void setResourcesDirectory(String resourcesDirectory) {
        this.setProperty(KEY_RESOURCESDIRECTORY, resourcesDirectory);
    }

    @Override
    public String getSourceDirectory() {
        String sourceDirectory = this.getProperty(KEY_SOURCEDIRECTORY);
        if (sourceDirectory == null) {
            String projectRoot = this.getProjectRoot();
            if (projectRoot != null) {
                sourceDirectory = projectRoot + "/src/main/java";
            }
        } else {
            String projectRoot = this.getProjectRoot();
            if (projectRoot != null && FileUtils.isRelativePath(sourceDirectory)) {
                sourceDirectory = projectRoot + "/" + sourceDirectory;
            }
        }
        return sourceDirectory;
    }

    @Override
    public void setSourceDirectory(String sourceDirectory) {
        this.setProperty(KEY_SOURCEDIRECTORY, sourceDirectory);
    }

    @Override
    public String getWebappSourceRoot() {
        String webappSourceRoot = this.getProperty(KEY_WEBAPPSOURCEROOT);
        if (webappSourceRoot == null) {
            String projectRoot = this.getProjectRoot();
            if (projectRoot != null) {
                webappSourceRoot = projectRoot + "/src/main/webapp";
            }
        } else {
            String projectRoot = this.getProjectRoot();
            if (projectRoot != null && FileUtils.isRelativePath(webappSourceRoot)) {
                webappSourceRoot = projectRoot + "/" + webappSourceRoot;
            }
        }
        return webappSourceRoot;
    }

    public void setWebappSourceRoot(String webappSourceRoot) {
        this.setProperty(KEY_WEBAPPSOURCEROOT, webappSourceRoot);
    }

    @Override
    public String getDefaultPropertiesFilePath() {
        String resourcesDirectory = this.getResourcesDirectory();
        if (resourcesDirectory == null) {
            return null;
        }
        return resourcesDirectory + "/" + PROPERTIESPATH;
    }

    @Override
    public URL getDefaultPropertiesResourceURL() {
        return this.getClass().getClassLoader().getResource(PROPERTIESPATH);
    }

    @Override
    public String getDefaultLocalPropertiesFilePath() {
        String resourcesDirectory = this.getResourcesDirectory();
        if (resourcesDirectory == null) {
            return null;
        }
        return resourcesDirectory + "/" + LOCALPROPERTIESPATH;
    }

    @Override
    public URL getDefaultLocalPropertiesResourceURL() {
        return this.getClass().getClassLoader().getResource(LOCALPROPERTIESPATH);
    }

    @Override
    public String getTemplateEncoding() {
        String templateEncoding = this.getProperty(KEY_TEMPLATEENCODING);
        if (templateEncoding == null) {
            templateEncoding = "UTF-8";
        }
        return templateEncoding;
    }

    @Override
    public LocalHotdeployS2Container getHotdeployS2Container() {
        return this.ondemandContainer_;
    }

    @Override
    public PathMappingProvider getPathMappingProvider() {
        return this.pathMappingProvider_;
    }

    @Override
    public boolean isCapable(Class<?> clazz) {
        int i$ = 0;
        String[] arr$ = this.getRootPackageNames();
        int len$ = arr$.length;
        if (i$ < len$) {
            String rootPackageName = arr$[i$];
            return clazz.getName().startsWith(rootPackageName + ".");
        }
        return false;
    }
}

