/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.history.impl;

import java.util.Arrays;
import java.util.LinkedList;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.conversation.ConversationManager;
import org.seasar.ymir.conversation.Conversations;
import org.seasar.ymir.history.Conversation;
import org.seasar.ymir.history.History;
import org.seasar.ymir.history.HistoryElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryImpl
implements History {
    private static final long serialVersionUID = -2052864334032766177L;
    protected static final int DEFAULT_RECORDCOUNT = 10;
    private LinkedList<HistoryElement> elementList_ = new LinkedList();
    private int recordCount_;

    public HistoryImpl() {
        this(10);
    }

    public HistoryImpl(int recordCount) {
        this.setRecordCount(recordCount);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementList_.isEmpty();
    }

    @Override
    public synchronized HistoryElement[] getElements() {
        return this.elementList_.toArray(new HistoryElement[0]);
    }

    @Override
    public synchronized HistoryElement peekElement(String path) {
        for (HistoryElement element : this.elementList_) {
            if (!path.equals(element.getPath().getTrunk())) continue;
            return element;
        }
        return null;
    }

    @Override
    public synchronized HistoryElement peekElement() {
        return this.elementList_.peek();
    }

    @Override
    public synchronized HistoryElement popElement() {
        return this.elementList_.poll();
    }

    @Override
    public synchronized void pushElement(HistoryElement element) {
        this.elementList_.addFirst(element);
        if (this.recordCount_ >= 0 && this.elementList_.size() > this.recordCount_) {
            this.elementList_.removeLast();
        }
    }

    @Override
    public synchronized void setElements(HistoryElement[] elements) {
        this.elementList_.clear();
        this.elementList_.addAll(Arrays.asList(elements));
    }

    @Override
    public boolean equalsPageTo(Class<?> pageClass, HistoryElement element) {
        if (element == null) {
            return false;
        }
        return pageClass == element.getPageClass();
    }

    @Override
    public boolean equalsPathTo(String path, HistoryElement element) {
        if (element == null) {
            return false;
        }
        return path.equals(element.getPath().getTrunk());
    }

    @Override
    public synchronized HistoryElement peekElementInCurrentConversation() {
        ConversationManager conversationManager = this.getConversationManager();
        Conversations conversations = conversationManager.getConversations(false);
        if (conversations == null) {
            return null;
        }
        String conversationName = conversations.getCurrentConversationName();
        if (conversationName == null) {
            return null;
        }
        for (HistoryElement element : this.elementList_) {
            Conversation conversation = element.getConversation();
            if (conversation == null || !conversationName.equals(conversation.getName())) continue;
            return element;
        }
        return null;
    }

    ConversationManager getConversationManager() {
        return (ConversationManager)YmirContext.getYmir().getApplication().getS2Container().getComponent(ConversationManager.class);
    }

    @Override
    public void setRecordCount(int recordCount) {
        this.recordCount_ = recordCount;
    }
}

