/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.converter.impl;

import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.ymir.constraint.annotation.Datetime;
import org.seasar.ymir.converter.impl.TypeConverterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateConverterBase<T extends Date>
extends TypeConverterBase<T> {
    protected String pattern_;

    public void setPattern(String pattern) {
        this.pattern_ = pattern;
    }

    protected String getPattern(Annotation[] hint) {
        String pattern = this.getPatternOrNull(hint);
        if (pattern == null) {
            pattern = this.pattern_;
        }
        return pattern;
    }

    protected String getPatternOrNull(Annotation[] hint) {
        String pattern = null;
        for (int i = 0; i < hint.length; ++i) {
            if (hint[i].annotationType() != Datetime.class) continue;
            Datetime annotation = (Datetime)hint[i];
            if (annotation.pattern().length() > 0) {
                pattern = annotation.pattern();
                break;
            }
            if (annotation.value().length() > 0) {
                pattern = annotation.value();
                break;
            }
            pattern = "yyyy-MM-dd HH:mm:ss";
            break;
        }
        return pattern;
    }

    @Override
    public String convertToString(T value, Annotation[] hint) {
        return new SimpleDateFormat(this.getPattern(hint)).format((Date)value);
    }
}

