/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.converter.impl;

import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.ymir.converter.TypeConversionException;
import org.seasar.ymir.converter.impl.DateConverterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateConverter
extends DateConverterBase<Date> {
    public static final String PATTERN = "yyyy-MM-dd HH:mm:ss";

    public DateConverter() {
        this.type_ = Date.class;
        this.pattern_ = PATTERN;
    }

    @Override
    protected Date doConvert(Object value, Annotation[] hint) throws TypeConversionException {
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        try {
            return new SimpleDateFormat(this.getPattern(hint)).parse(value.toString());
        }
        catch (Exception ex) {
            throw new TypeConversionException(ex, value, this.getType());
        }
    }
}

